/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.graph;

import com.google.common.collect.Lists;
import de.cau.cs.kieler.core.math.KVector;
import de.cau.cs.kieler.klay.layered.graph.LGraphElement;
import de.cau.cs.kieler.klay.layered.graph.LInsets;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.graph.Layer;
import de.cau.cs.kieler.klay.layered.properties.InternalProperties;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public final class LGraph
extends LGraphElement
implements Iterable<Layer> {
    private static final long serialVersionUID = -8006835373897072852L;
    private final KVector size = new KVector();
    private final LInsets insets = new LInsets(0.0, 0.0, 0.0, 0.0);
    private final KVector offset = new KVector();
    private final List<LNode> layerlessNodes = Lists.newArrayList();
    private final List<Layer> layers = Lists.newArrayList();

    public String toString() {
        if (this.layers.isEmpty()) {
            return "G-unlayered" + this.layerlessNodes.toString();
        }
        if (this.layerlessNodes.isEmpty()) {
            return "G-layered" + this.layers.toString();
        }
        return "G[layerless" + this.layerlessNodes.toString() + ", layers" + this.layers.toString() + "]";
    }

    public KVector getSize() {
        return this.size;
    }

    public KVector getActualSize() {
        float borderSpacing = ((Float)this.getProperty(InternalProperties.BORDER_SPACING)).floatValue();
        return new KVector(this.size.x + this.insets.left + this.insets.right + (double)(2.0f * borderSpacing), this.size.y + this.insets.top + this.insets.bottom + (double)(2.0f * borderSpacing));
    }

    public LInsets getInsets() {
        return this.insets;
    }

    public KVector getOffset() {
        return this.offset;
    }

    public List<LNode> getLayerlessNodes() {
        return this.layerlessNodes;
    }

    public List<Layer> getLayers() {
        return this.layers;
    }

    @Override
    public Iterator<Layer> iterator() {
        return this.layers.iterator();
    }

    public LNode[][] toNodeArray() {
        LNode[][] lgraphArray = new LNode[this.layers.size()][];
        ListIterator<Layer> layerIter = this.layers.listIterator();
        while (layerIter.hasNext()) {
            Layer layer = layerIter.next();
            int layerIndex = layerIter.previousIndex();
            lgraphArray[layerIndex] = layer.getNodes().toArray(new LNode[layer.getNodes().size()]);
        }
        return lgraphArray;
    }
}

