/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.graph;

import com.google.common.collect.Lists;
import de.cau.cs.kieler.core.math.KVector;
import de.cau.cs.kieler.core.properties.IProperty;
import de.cau.cs.kieler.kiml.options.LayoutOptions;
import de.cau.cs.kieler.kiml.options.PortConstraints;
import de.cau.cs.kieler.kiml.options.PortSide;
import de.cau.cs.kieler.kiml.util.adapters.GraphAdapters;
import de.cau.cs.kieler.kiml.util.nodespacing.LabelSide;
import de.cau.cs.kieler.kiml.util.nodespacing.Spacing;
import de.cau.cs.kieler.klay.layered.graph.LEdge;
import de.cau.cs.kieler.klay.layered.graph.LGraph;
import de.cau.cs.kieler.klay.layered.graph.LInsets;
import de.cau.cs.kieler.klay.layered.graph.LLabel;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.graph.LPort;
import de.cau.cs.kieler.klay.layered.graph.LShape;
import de.cau.cs.kieler.klay.layered.graph.Layer;
import de.cau.cs.kieler.klay.layered.properties.InternalProperties;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public final class LGraphAdapters {
    public static final PortComparator DEFAULT_PORTLIST_SORTER = new PortComparator();

    private LGraphAdapters() {
        throw new IllegalStateException("Private constructor, not to be instantiated!");
    }

    public static LGraphAdapter adapt(LGraph graph) {
        return LGraphAdapters.adapt(graph, false);
    }

    public static LGraphAdapter adapt(LGraph graph, boolean transparentNorthSouthEdges) {
        return new LGraphAdapter(graph, transparentNorthSouthEdges);
    }

    private static abstract class AbstractLShapeAdapter<T extends LShape>
    implements GraphAdapters.GraphElementAdapter<T> {
        protected T element;

        public AbstractLShapeAdapter(T element) {
            this.element = element;
        }

        public KVector getSize() {
            return ((LShape)((Object)this.element)).getSize();
        }

        public void setSize(KVector size) {
            ((LShape)((Object)this.element)).getSize().x = size.x;
            ((LShape)((Object)this.element)).getSize().y = size.y;
        }

        public KVector getPosition() {
            return ((LShape)((Object)this.element)).getPosition();
        }

        public void setPosition(KVector pos) {
            ((LShape)((Object)this.element)).getPosition().x = pos.x;
            ((LShape)((Object)this.element)).getPosition().y = pos.y;
        }

        public <P> P getProperty(IProperty<P> prop) {
            if (prop.equals((Object)LayoutOptions.SPACING)) {
                return (P)this.element.getProperty(InternalProperties.SPACING);
            }
            if (prop.equals((Object)LayoutOptions.OFFSET)) {
                return (P)this.element.getProperty(InternalProperties.OFFSET);
            }
            return (P)this.element.getProperty(prop);
        }

        public int getVolatileId() {
            return ((LShape)((Object)this.element)).id;
        }

        public void setVolatileId(int volatileId) {
            ((LShape)((Object)this.element)).id = volatileId;
        }
    }

    static final class LEdgeAdapter
    implements GraphAdapters.EdgeAdapter<LEdge> {
        private LEdge element;
        private List<GraphAdapters.LabelAdapter<?>> labelAdapters = null;

        public LEdgeAdapter(LEdge edge) {
            this.element = edge;
        }

        public Iterable<GraphAdapters.LabelAdapter<?>> getLabels() {
            if (this.labelAdapters == null) {
                this.labelAdapters = Lists.newArrayListWithCapacity((int)this.element.getLabels().size());
                for (LLabel l : this.element.getLabels()) {
                    this.labelAdapters.add(new LLabelAdapter(l));
                }
            }
            return this.labelAdapters;
        }
    }

    public static final class LGraphAdapter
    implements GraphAdapters.GraphAdapter<LGraph> {
        protected LGraph element;
        private List<GraphAdapters.NodeAdapter<?>> nodeAdapters = null;
        private boolean transparentNorthSouthEdges;

        private LGraphAdapter(LGraph element, boolean transparentNorthSouthEdges) {
            this.element = element;
            this.transparentNorthSouthEdges = transparentNorthSouthEdges;
        }

        public KVector getSize() {
            return this.element.getSize();
        }

        public void setSize(KVector size) {
            this.element.getSize().x = size.x;
            this.element.getSize().y = size.y;
        }

        public KVector getPosition() {
            throw new UnsupportedOperationException("Not supported by LGraph");
        }

        public void setPosition(KVector pos) {
            throw new UnsupportedOperationException("Not supported by LGraph");
        }

        public <P> P getProperty(IProperty<P> prop) {
            return (P)this.element.getProperty(prop);
        }

        public Iterable<GraphAdapters.NodeAdapter<?>> getNodes() {
            if (this.nodeAdapters == null) {
                this.nodeAdapters = Lists.newArrayList();
                for (Layer l : this.element.getLayers()) {
                    for (LNode n : l.getNodes()) {
                        this.nodeAdapters.add(new LNodeAdapter(n, this.transparentNorthSouthEdges));
                    }
                }
            }
            return this.nodeAdapters;
        }

        public int getVolatileId() {
            return this.element.id;
        }

        public void setVolatileId(int volatileId) {
            this.element.id = volatileId;
        }
    }

    static final class LLabelAdapter
    extends AbstractLShapeAdapter<LLabel>
    implements GraphAdapters.LabelAdapter<LLabel> {
        public LLabelAdapter(LLabel element) {
            super(element);
        }

        public LabelSide getSide() {
            return (LabelSide)((LLabel)this.element).getProperty(LabelSide.LABEL_SIDE);
        }
    }

    static final class LNodeAdapter
    extends AbstractLShapeAdapter<LNode>
    implements GraphAdapters.NodeAdapter<LNode> {
        private List<GraphAdapters.LabelAdapter<?>> labelAdapters = null;
        private List<GraphAdapters.PortAdapter<?>> portAdapters = null;
        private boolean transparentNorthSouthEdges;

        public LNodeAdapter(LNode element, boolean transparentNorthSouthEdges) {
            super(element);
            this.transparentNorthSouthEdges = transparentNorthSouthEdges;
        }

        public Iterable<GraphAdapters.LabelAdapter<?>> getLabels() {
            if (this.labelAdapters == null) {
                this.labelAdapters = Lists.newArrayListWithCapacity((int)((LNode)this.element).getLabels().size());
                for (LLabel l : ((LNode)this.element).getLabels()) {
                    this.labelAdapters.add(new LLabelAdapter(l));
                }
            }
            return this.labelAdapters;
        }

        public Iterable<GraphAdapters.PortAdapter<?>> getPorts() {
            if (this.portAdapters == null) {
                this.portAdapters = Lists.newArrayListWithCapacity((int)((LNode)this.element).getPorts().size());
                for (LPort p : ((LNode)this.element).getPorts()) {
                    this.portAdapters.add(new LPortAdapter(p, this.transparentNorthSouthEdges));
                }
            }
            return this.portAdapters;
        }

        public Iterable<GraphAdapters.EdgeAdapter<?>> getIncomingEdges() {
            return Collections.emptyList();
        }

        public Iterable<GraphAdapters.EdgeAdapter<?>> getOutgoingEdges() {
            return Collections.emptyList();
        }

        public void sortPortList() {
            this.sortPortList(DEFAULT_PORTLIST_SORTER);
        }

        public void sortPortList(Comparator<?> comparator) {
            if (((PortConstraints)((LNode)this.element).getProperty(LayoutOptions.PORT_CONSTRAINTS)).isOrderFixed()) {
                Collections.sort(((LNode)this.element).getPorts(), comparator);
            }
        }

        public boolean isCompoundNode() {
            return (Boolean)((LNode)this.element).getProperty(InternalProperties.COMPOUND_NODE);
        }

        public Spacing.Insets getInsets() {
            LInsets linsets = ((LNode)this.element).getInsets();
            return new Spacing.Insets(linsets.top, linsets.left, linsets.bottom, linsets.right);
        }

        public void setInsets(Spacing.Insets insets) {
            ((LNode)this.element).getInsets().left = insets.left;
            ((LNode)this.element).getInsets().top = insets.top;
            ((LNode)this.element).getInsets().right = insets.right;
            ((LNode)this.element).getInsets().bottom = insets.bottom;
        }

        public Spacing.Margins getMargin() {
            LInsets lmargins = ((LNode)this.element).getMargin();
            return new Spacing.Margins(lmargins.top, lmargins.left, lmargins.bottom, lmargins.right);
        }

        public void setMargin(Spacing.Margins margin) {
            ((LNode)this.element).getMargin().left = margin.left;
            ((LNode)this.element).getMargin().top = margin.top;
            ((LNode)this.element).getMargin().right = margin.right;
            ((LNode)this.element).getMargin().bottom = margin.bottom;
        }
    }

    static final class LPortAdapter
    extends AbstractLShapeAdapter<LPort>
    implements GraphAdapters.PortAdapter<LPort> {
        private List<GraphAdapters.LabelAdapter<?>> labelAdapters = null;
        private List<GraphAdapters.EdgeAdapter<?>> incomingEdgeAdapters = null;
        private List<GraphAdapters.EdgeAdapter<?>> outgoingEdgeAdapters = null;
        private boolean transparentNorthSouthEdges;

        public LPortAdapter(LPort element, boolean transparentNorthSouthEdges) {
            super(element);
            this.transparentNorthSouthEdges = transparentNorthSouthEdges;
        }

        public PortSide getSide() {
            return ((LPort)this.element).getSide();
        }

        public Iterable<GraphAdapters.LabelAdapter<?>> getLabels() {
            if (this.labelAdapters == null) {
                this.labelAdapters = Lists.newArrayListWithCapacity((int)((LPort)this.element).getLabels().size());
                for (LLabel l : ((LPort)this.element).getLabels()) {
                    this.labelAdapters.add(new LLabelAdapter(l));
                }
            }
            return this.labelAdapters;
        }

        public Spacing.Margins getMargin() {
            LInsets lmargins = ((LPort)this.element).getMargin();
            return new Spacing.Margins(lmargins.top, lmargins.left, lmargins.bottom, lmargins.right);
        }

        public void setMargin(Spacing.Margins margin) {
            ((LPort)this.element).getMargin().left = margin.left;
            ((LPort)this.element).getMargin().top = margin.top;
            ((LPort)this.element).getMargin().right = margin.right;
            ((LPort)this.element).getMargin().bottom = margin.bottom;
        }

        public Iterable<GraphAdapters.EdgeAdapter<?>> getIncomingEdges() {
            if (this.transparentNorthSouthEdges && ((LPort)this.element).getNode().getType() == LNode.NodeType.NORTH_SOUTH_PORT) {
                return Collections.emptyList();
            }
            if (this.incomingEdgeAdapters == null) {
                LNode portDummy;
                this.incomingEdgeAdapters = Lists.newArrayList();
                for (LEdge e : ((LPort)this.element).getIncomingEdges()) {
                    this.incomingEdgeAdapters.add(new LEdgeAdapter(e));
                }
                if (this.transparentNorthSouthEdges && (portDummy = (LNode)((Object)((LPort)this.element).getProperty(InternalProperties.PORT_DUMMY))) != null) {
                    for (LEdge e : portDummy.getIncomingEdges()) {
                        this.incomingEdgeAdapters.add(new LEdgeAdapter(e));
                    }
                }
            }
            return this.incomingEdgeAdapters;
        }

        public Iterable<GraphAdapters.EdgeAdapter<?>> getOutgoingEdges() {
            if (this.transparentNorthSouthEdges && ((LPort)this.element).getNode().getType() == LNode.NodeType.NORTH_SOUTH_PORT) {
                return Collections.emptyList();
            }
            if (this.outgoingEdgeAdapters == null) {
                LNode portDummy;
                this.outgoingEdgeAdapters = Lists.newArrayList();
                for (LEdge e : ((LPort)this.element).getOutgoingEdges()) {
                    this.outgoingEdgeAdapters.add(new LEdgeAdapter(e));
                }
                if (this.transparentNorthSouthEdges && (portDummy = (LNode)((Object)((LPort)this.element).getProperty(InternalProperties.PORT_DUMMY))) != null) {
                    for (LEdge e : portDummy.getOutgoingEdges()) {
                        this.outgoingEdgeAdapters.add(new LEdgeAdapter(e));
                    }
                }
            }
            return this.outgoingEdgeAdapters;
        }

        public boolean hasCompoundConnections() {
            return (Boolean)((LPort)this.element).getProperty(InternalProperties.INSIDE_CONNECTIONS);
        }
    }

    public static class PortComparator
    implements Comparator<LPort> {
        @Override
        public int compare(LPort port1, LPort port2) {
            int indexDifference;
            int ordinalDifference = port1.getSide().ordinal() - port2.getSide().ordinal();
            if (ordinalDifference != 0) {
                return ordinalDifference;
            }
            Integer index1 = (Integer)port1.getProperty(LayoutOptions.PORT_INDEX);
            Integer index2 = (Integer)port2.getProperty(LayoutOptions.PORT_INDEX);
            if (index1 != null && index2 != null && (indexDifference = index1 - index2) != 0) {
                return indexDifference;
            }
            switch (port1.getSide()) {
                case NORTH: {
                    return Double.compare(port1.getPosition().x, port2.getPosition().x);
                }
                case EAST: {
                    return Double.compare(port1.getPosition().y, port2.getPosition().y);
                }
                case SOUTH: {
                    return Double.compare(port2.getPosition().x, port1.getPosition().x);
                }
                case WEST: {
                    return Double.compare(port2.getPosition().y, port1.getPosition().y);
                }
            }
            throw new IllegalStateException("Port side is undefined");
        }
    }
}

