/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.graph;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import de.cau.cs.kieler.core.math.KVector;
import de.cau.cs.kieler.kiml.options.PortSide;
import de.cau.cs.kieler.klay.layered.graph.LEdge;
import de.cau.cs.kieler.klay.layered.graph.LGraph;
import de.cau.cs.kieler.klay.layered.graph.LInsets;
import de.cau.cs.kieler.klay.layered.graph.LLabel;
import de.cau.cs.kieler.klay.layered.graph.LPort;
import de.cau.cs.kieler.klay.layered.graph.LShape;
import de.cau.cs.kieler.klay.layered.graph.Layer;
import de.cau.cs.kieler.klay.layered.properties.InteractiveReferencePoint;
import de.cau.cs.kieler.klay.layered.properties.InternalProperties;
import de.cau.cs.kieler.klay.layered.properties.PortType;
import de.cau.cs.kieler.klay.layered.properties.Properties;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class LNode
extends LShape {
    private static final long serialVersionUID = -4272570519129722541L;
    private LGraph graph;
    private Layer layer;
    private NodeType type = NodeType.NORMAL;
    private final List<LPort> ports = Lists.newArrayListWithCapacity((int)6);
    private final List<LLabel> labels = Lists.newArrayListWithCapacity((int)2);
    private final LInsets margin = new LInsets();
    private final LInsets insets = new LInsets();

    public LNode(LGraph graph) {
        this.graph = graph;
    }

    public String toString() {
        return "n_" + this.getDesignation();
    }

    public String getName() {
        if (!this.labels.isEmpty()) {
            return this.labels.get(0).getText();
        }
        return null;
    }

    public String getDesignation() {
        String name = this.getName();
        if (name == null) {
            return Integer.toString(this.id);
        }
        return name;
    }

    public Layer getLayer() {
        return this.layer;
    }

    public void setLayer(Layer thelayer) {
        if (this.layer != null) {
            this.layer.getNodes().remove((Object)this);
        }
        this.layer = thelayer;
        if (this.layer != null) {
            this.layer.getNodes().add(this);
        }
    }

    public LGraph getGraph() {
        if (this.graph == null && this.layer != null) {
            return this.layer.getGraph();
        }
        return this.graph;
    }

    public void setGraph(LGraph newGraph) {
        assert (this.layer == null);
        this.graph = newGraph;
    }

    public void setLayer(int index, Layer newlayer) {
        if (newlayer != null && (index < 0 || index > newlayer.getNodes().size())) {
            throw new IllegalArgumentException("index must be >= 0 and <= layer node count");
        }
        if (this.layer != null) {
            this.layer.getNodes().remove((Object)this);
        }
        this.layer = newlayer;
        if (newlayer != null) {
            newlayer.getNodes().add(index, this);
        }
    }

    public NodeType getType() {
        return this.type;
    }

    public void setType(NodeType type) {
        this.type = type;
    }

    public List<LPort> getPorts() {
        return this.ports;
    }

    public Iterable<LPort> getPorts(PortType portType) {
        switch (portType) {
            case INPUT: {
                return Iterables.filter(this.ports, LPort.INPUT_PREDICATE);
            }
            case OUTPUT: {
                return Iterables.filter(this.ports, LPort.OUTPUT_PREDICATE);
            }
        }
        return Collections.emptyList();
    }

    public Iterable<LPort> getPorts(PortSide side) {
        switch (side) {
            case NORTH: {
                return Iterables.filter(this.ports, LPort.NORTH_PREDICATE);
            }
            case EAST: {
                return Iterables.filter(this.ports, LPort.EAST_PREDICATE);
            }
            case SOUTH: {
                return Iterables.filter(this.ports, LPort.SOUTH_PREDICATE);
            }
            case WEST: {
                return Iterables.filter(this.ports, LPort.WEST_PREDICATE);
            }
        }
        return Collections.emptyList();
    }

    public Iterable<LPort> getPorts(PortType portType, PortSide side) {
        Predicate<LPort> typePredicate = null;
        switch (portType) {
            case INPUT: {
                typePredicate = LPort.INPUT_PREDICATE;
                break;
            }
            case OUTPUT: {
                typePredicate = LPort.OUTPUT_PREDICATE;
            }
        }
        Predicate<LPort> sidePredicate = null;
        switch (side) {
            case NORTH: {
                sidePredicate = LPort.NORTH_PREDICATE;
                break;
            }
            case EAST: {
                sidePredicate = LPort.EAST_PREDICATE;
                break;
            }
            case SOUTH: {
                sidePredicate = LPort.SOUTH_PREDICATE;
                break;
            }
            case WEST: {
                sidePredicate = LPort.WEST_PREDICATE;
            }
        }
        if (typePredicate != null && sidePredicate != null) {
            return Iterables.filter(this.ports, (Predicate)Predicates.and(typePredicate, sidePredicate));
        }
        return Collections.emptyList();
    }

    public Iterable<LEdge> getIncomingEdges() {
        ArrayList iterables = Lists.newArrayList();
        for (LPort port : this.ports) {
            iterables.add(port.getIncomingEdges());
        }
        return Iterables.concat((Iterable)iterables);
    }

    public Iterable<LEdge> getOutgoingEdges() {
        ArrayList iterables = Lists.newArrayList();
        for (LPort port : this.ports) {
            iterables.add(port.getOutgoingEdges());
        }
        return Iterables.concat((Iterable)iterables);
    }

    public Iterable<LEdge> getConnectedEdges() {
        ArrayList iterables = Lists.newArrayList();
        for (LPort port : this.ports) {
            iterables.add(port.getConnectedEdges());
        }
        return Iterables.concat((Iterable)iterables);
    }

    public List<LLabel> getLabels() {
        return this.labels;
    }

    public LInsets getMargin() {
        return this.margin;
    }

    public LInsets getInsets() {
        return this.insets;
    }

    public int getIndex() {
        if (this.layer == null) {
            return -1;
        }
        return this.layer.getNodes().indexOf((Object)this);
    }

    public void borderToContentAreaCoordinates(boolean horizontal, boolean vertical) {
        LGraph thegraph = this.getGraph();
        LInsets graphInsets = thegraph.getInsets();
        float borderSpacing = ((Float)thegraph.getProperty(InternalProperties.BORDER_SPACING)).floatValue();
        KVector offset = thegraph.getOffset();
        KVector pos = this.getPosition();
        if (horizontal) {
            pos.x = pos.x - graphInsets.left - (double)borderSpacing - offset.x;
        }
        if (vertical) {
            pos.y = pos.y - graphInsets.top - (double)borderSpacing - offset.y;
        }
    }

    public KVector getInteractiveReferencePoint() {
        switch ((InteractiveReferencePoint)((Object)this.getGraph().getProperty(Properties.INTERACTIVE_REFERENCE_POINT))) {
            case CENTER: {
                KVector nodePos = this.getPosition();
                KVector nodeSize = this.getSize();
                return new KVector(nodePos.x + nodeSize.x / 2.0, nodePos.y + nodeSize.y / 2.0);
            }
            case TOP_LEFT: {
                return new KVector(this.getPosition());
            }
        }
        return null;
    }

    public static enum NodeType {
        NORMAL,
        LONG_EDGE,
        EXTERNAL_PORT,
        NORTH_SOUTH_PORT,
        LABEL,
        BIG_NODE;


        public String getColor() {
            switch (this) {
                case BIG_NODE: {
                    return "#cccccc";
                }
                case EXTERNAL_PORT: {
                    return "#cc99cc";
                }
                case LONG_EDGE: {
                    return "#eaed00";
                }
                case NORTH_SOUTH_PORT: {
                    return "#0034de";
                }
                case LABEL: {
                    return "#75c3c3";
                }
            }
            return "#000000";
        }
    }
}

