/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.graph.transform;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import de.cau.cs.kieler.core.kgraph.KEdge;
import de.cau.cs.kieler.core.kgraph.KGraphElement;
import de.cau.cs.kieler.core.kgraph.KLabel;
import de.cau.cs.kieler.core.kgraph.KNode;
import de.cau.cs.kieler.core.kgraph.KPort;
import de.cau.cs.kieler.core.math.KVector;
import de.cau.cs.kieler.core.math.KVectorChain;
import de.cau.cs.kieler.core.properties.IPropertyHolder;
import de.cau.cs.kieler.kiml.klayoutdata.KEdgeLayout;
import de.cau.cs.kieler.kiml.klayoutdata.KLayoutData;
import de.cau.cs.kieler.kiml.klayoutdata.KPoint;
import de.cau.cs.kieler.kiml.klayoutdata.KShapeLayout;
import de.cau.cs.kieler.kiml.labels.ILabelManager;
import de.cau.cs.kieler.kiml.labels.LabelManagementOptions;
import de.cau.cs.kieler.kiml.options.Direction;
import de.cau.cs.kieler.kiml.options.EdgeLabelPlacement;
import de.cau.cs.kieler.kiml.options.HierarchyHandling;
import de.cau.cs.kieler.kiml.options.LayoutOptions;
import de.cau.cs.kieler.kiml.options.PortConstraints;
import de.cau.cs.kieler.kiml.options.PortLabelPlacement;
import de.cau.cs.kieler.kiml.options.PortSide;
import de.cau.cs.kieler.kiml.util.KimlUtil;
import de.cau.cs.kieler.kiml.util.adapters.GraphAdapters;
import de.cau.cs.kieler.kiml.util.adapters.KGraphAdapters;
import de.cau.cs.kieler.kiml.util.labelspacing.LabelSpaceCalculation;
import de.cau.cs.kieler.kiml.util.nodespacing.Spacing;
import de.cau.cs.kieler.klay.layered.graph.LEdge;
import de.cau.cs.kieler.klay.layered.graph.LGraph;
import de.cau.cs.kieler.klay.layered.graph.LGraphElement;
import de.cau.cs.kieler.klay.layered.graph.LGraphUtil;
import de.cau.cs.kieler.klay.layered.graph.LInsets;
import de.cau.cs.kieler.klay.layered.graph.LLabel;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.graph.LPort;
import de.cau.cs.kieler.klay.layered.p3order.CrossingMinimizationStrategy;
import de.cau.cs.kieler.klay.layered.p4nodes.NodePlacementStrategy;
import de.cau.cs.kieler.klay.layered.properties.GraphProperties;
import de.cau.cs.kieler.klay.layered.properties.InternalProperties;
import de.cau.cs.kieler.klay.layered.properties.PortType;
import de.cau.cs.kieler.klay.layered.properties.Properties;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

class KGraphImporter {
    private final Map<KGraphElement, LGraphElement> nodeAndPortMap = Maps.newHashMap();

    KGraphImporter() {
    }

    public LGraph importGraph(KNode kgraph) {
        LGraph topLevelGraph = this.createLGraph(kgraph);
        Set graphProperties = (Set)topLevelGraph.getProperty(InternalProperties.GRAPH_PROPERTIES);
        this.checkExternalPorts(kgraph, graphProperties);
        if (graphProperties.contains((Object)GraphProperties.EXTERNAL_PORTS)) {
            for (KPort kport : kgraph.getPorts()) {
                this.transformExternalPort(kgraph, topLevelGraph, kport);
            }
        }
        if (((Boolean)topLevelGraph.getProperty(LayoutOptions.LAYOUT_PARTITIONS)).booleanValue()) {
            graphProperties.add(GraphProperties.PARTITIONS);
        }
        if (((KShapeLayout)kgraph.getData(KShapeLayout.class)).getProperty(LayoutOptions.HIERARCHY_HANDLING) == HierarchyHandling.INCLUDE_CHILDREN) {
            this.importHierarchicalGraph(kgraph, topLevelGraph);
        } else {
            this.importFlatGraph(kgraph, topLevelGraph);
        }
        return topLevelGraph;
    }

    private void importFlatGraph(KNode kgraph, LGraph lgraph) {
        for (KNode child : kgraph.getChildren()) {
            if (((Boolean)((KShapeLayout)child.getData(KShapeLayout.class)).getProperty(LayoutOptions.NO_LAYOUT)).booleanValue()) continue;
            this.transformNode(child, lgraph);
        }
        for (KNode child : kgraph.getChildren()) {
            KShapeLayout childLayout = (KShapeLayout)child.getData(KShapeLayout.class);
            boolean enableInsideSelfLoops = (Boolean)childLayout.getProperty(LayoutOptions.SELF_LOOP_INSIDE);
            for (KEdge kedge : child.getOutgoingEdges()) {
                boolean connectsToSibling;
                KEdgeLayout kedgeLayout = (KEdgeLayout)kedge.getData(KEdgeLayout.class);
                boolean isToBeLaidOut = (Boolean)kedgeLayout.getProperty(LayoutOptions.NO_LAYOUT) == false;
                boolean isInsideSelfLoop = enableInsideSelfLoops && kedge.getTarget() == child && (Boolean)kedgeLayout.getProperty(LayoutOptions.SELF_LOOP_INSIDE) != false;
                boolean connectsToGraph = kedge.getTarget() == kgraph;
                boolean bl = connectsToSibling = kedge.getTarget().getParent() == kgraph;
                if (!isToBeLaidOut || isInsideSelfLoop || !connectsToGraph && !connectsToSibling) continue;
                this.transformEdge(kedge, lgraph);
            }
        }
        KShapeLayout shapeLayout = (KShapeLayout)kgraph.getData(KShapeLayout.class);
        boolean enableInsideSelfLoops = (Boolean)shapeLayout.getProperty(LayoutOptions.SELF_LOOP_INSIDE);
        for (KEdge kedge : kgraph.getOutgoingEdges()) {
            boolean connectsToChild;
            KEdgeLayout kedgeLayout = (KEdgeLayout)kedge.getData(KEdgeLayout.class);
            boolean isToBeLaidOut = (Boolean)kedgeLayout.getProperty(LayoutOptions.NO_LAYOUT) == false;
            boolean isInsideSelfLoop = enableInsideSelfLoops && kedge.getTarget() == kgraph && (Boolean)kedgeLayout.getProperty(LayoutOptions.SELF_LOOP_INSIDE) != false;
            boolean bl = connectsToChild = kedge.getTarget().getParent() == kgraph;
            if (!isToBeLaidOut || !connectsToChild && !isInsideSelfLoop) continue;
            this.transformEdge(kedge, lgraph);
        }
    }

    private void importHierarchicalGraph(KNode kgraph, LGraph lgraph) {
        KShapeLayout knodeLayout;
        KNode knode;
        LinkedList knodeQueue = Lists.newLinkedList();
        knodeQueue.addAll(kgraph.getChildren());
        while (!knodeQueue.isEmpty()) {
            boolean hasHierarchyHandlingEnabled;
            boolean isNodeToBeLaidOut;
            knode = (KNode)knodeQueue.poll();
            knodeLayout = (KShapeLayout)knode.getData(KShapeLayout.class);
            boolean bl = isNodeToBeLaidOut = (Boolean)knodeLayout.getProperty(LayoutOptions.NO_LAYOUT) == false;
            if (!isNodeToBeLaidOut) continue;
            LGraph parentLGraph = lgraph;
            LNode parentLNode = (LNode)this.nodeAndPortMap.get(knode.getParent());
            if (parentLNode != null) {
                parentLGraph = (LGraph)parentLNode.getProperty(InternalProperties.NESTED_LGRAPH);
            }
            LNode lnode = this.transformNode(knode, parentLGraph);
            boolean hasChildren = !knode.getChildren().isEmpty();
            boolean hasInsideSelfLoops = this.hasInsideSelfLoops(knode);
            boolean bl2 = hasHierarchyHandlingEnabled = knodeLayout.getProperty(LayoutOptions.HIERARCHY_HANDLING) == HierarchyHandling.INCLUDE_CHILDREN;
            if (!hasHierarchyHandlingEnabled || !hasChildren && !hasInsideSelfLoops) continue;
            LGraph nestedGraph = this.createLGraph(knode);
            lnode.setProperty(InternalProperties.NESTED_LGRAPH, nestedGraph);
            nestedGraph.setProperty(InternalProperties.PARENT_LNODE, (Object)lnode);
            knodeQueue.addAll(knode.getChildren());
        }
        knodeQueue.add(kgraph);
        while (!knodeQueue.isEmpty()) {
            boolean isNodeToBeLaidOut;
            knode = (KNode)knodeQueue.poll();
            knodeLayout = (KShapeLayout)knode.getData(KShapeLayout.class);
            boolean enableInsideSelfLoops = (Boolean)knodeLayout.getProperty(LayoutOptions.SELF_LOOP_INSIDE);
            boolean bl = isNodeToBeLaidOut = (Boolean)knodeLayout.getProperty(LayoutOptions.NO_LAYOUT) == false;
            if (!isNodeToBeLaidOut) continue;
            for (KEdge kedge : knode.getOutgoingEdges()) {
                boolean isEdgeToBeLaidOut;
                KEdgeLayout kedgeLayout = (KEdgeLayout)kedge.getData(KEdgeLayout.class);
                boolean bl3 = isEdgeToBeLaidOut = (Boolean)kedgeLayout.getProperty(LayoutOptions.NO_LAYOUT) == false;
                if (!isEdgeToBeLaidOut) continue;
                boolean isInsideSelfLoop = enableInsideSelfLoops && kedge.getSource() == kedge.getTarget() && (Boolean)kedgeLayout.getProperty(LayoutOptions.SELF_LOOP_INSIDE) != false;
                KNode parentKGraph = knode.getParent();
                if (KimlUtil.isDescendant((KNode)kedge.getTarget(), (KNode)knode) || isInsideSelfLoop) {
                    parentKGraph = knode;
                }
                LGraph parentLGraph = lgraph;
                LNode parentLNode = (LNode)this.nodeAndPortMap.get(parentKGraph);
                if (parentLNode != null) {
                    parentLGraph = (LGraph)parentLNode.getProperty(InternalProperties.NESTED_LGRAPH);
                }
                this.transformEdge(kedge, parentLGraph);
            }
            knodeQueue.addAll(knode.getChildren());
        }
    }

    private boolean hasInsideSelfLoops(KNode knode) {
        KShapeLayout nodeLayout = (KShapeLayout)knode.getData(KShapeLayout.class);
        if (((Boolean)nodeLayout.getProperty(LayoutOptions.SELF_LOOP_INSIDE)).booleanValue()) {
            for (KEdge edge : knode.getOutgoingEdges()) {
                KEdgeLayout edgeLayout;
                if (edge.getTarget() != knode || !((Boolean)(edgeLayout = (KEdgeLayout)edge.getData(KEdgeLayout.class)).getProperty(LayoutOptions.SELF_LOOP_INSIDE)).booleanValue()) continue;
                return true;
            }
        }
        return false;
    }

    private LGraph createLGraph(KNode kgraph) {
        LGraph lgraph = new LGraph();
        KShapeLayout parentLayout = (KShapeLayout)kgraph.getData(KShapeLayout.class);
        lgraph.copyProperties((IPropertyHolder)parentLayout);
        if (lgraph.getProperty(LayoutOptions.DIRECTION) == Direction.UNDEFINED) {
            lgraph.setProperty(LayoutOptions.DIRECTION, LGraphUtil.getDirection(lgraph));
        }
        if (lgraph.getProperty(LabelManagementOptions.LABEL_MANAGER) == null) {
            KGraphElement root = (KGraphElement)EcoreUtil.getRootContainer((EObject)kgraph);
            KLayoutData layoutData = (KLayoutData)root.getData(KLayoutData.class);
            lgraph.setProperty(LabelManagementOptions.LABEL_MANAGER, (ILabelManager)layoutData.getProperty(LabelManagementOptions.LABEL_MANAGER));
        }
        lgraph.setProperty(InternalProperties.ORIGIN, kgraph);
        lgraph.setProperty(InternalProperties.GRAPH_PROPERTIES, EnumSet.noneOf(GraphProperties.class));
        double labelSpacing = ((Float)lgraph.getProperty(LayoutOptions.LABEL_SPACING)).doubleValue();
        Spacing.Insets insets = LabelSpaceCalculation.calculateRequiredNodeLabelSpace((GraphAdapters.NodeAdapter)KGraphAdapters.adaptSingleNode((KNode)kgraph), (double)labelSpacing);
        LInsets linsets = lgraph.getInsets();
        linsets.left = insets.left;
        linsets.right = insets.right;
        linsets.top = insets.top;
        linsets.bottom = insets.bottom;
        return lgraph;
    }

    private void checkExternalPorts(KNode kgraph, Set<GraphProperties> graphProperties) {
        KShapeLayout shapeLayout = (KShapeLayout)kgraph.getData(KShapeLayout.class);
        boolean enableSelfLoops = (Boolean)shapeLayout.getProperty(LayoutOptions.SELF_LOOP_INSIDE);
        PortLabelPlacement portLabelPlacement = (PortLabelPlacement)shapeLayout.getProperty(LayoutOptions.PORT_LABEL_PLACEMENT);
        boolean hasExternalPorts = false;
        boolean hasHyperedges = false;
        Iterator portIterator = kgraph.getPorts().iterator();
        while (!(!portIterator.hasNext() || hasExternalPorts && hasHyperedges)) {
            KPort kport = (KPort)portIterator.next();
            int externalPortEdges = 0;
            for (KEdge kedge : kport.getEdges()) {
                boolean connectsToChild;
                boolean isInsideSelfLoop = enableSelfLoops && kedge.getSource() == kedge.getTarget() && (Boolean)((KEdgeLayout)kedge.getData(KEdgeLayout.class)).getProperty(LayoutOptions.SELF_LOOP_INSIDE) != false;
                boolean bl = connectsToChild = kgraph == kedge.getSource().getParent() || kgraph == kedge.getTarget().getParent();
                if ((isInsideSelfLoop || connectsToChild) && ++externalPortEdges > 1) break;
            }
            if (externalPortEdges > 0) {
                hasExternalPorts = true;
            } else if (portLabelPlacement == PortLabelPlacement.INSIDE && kport.getLabels().size() > 0) {
                hasExternalPorts = true;
            }
            if (externalPortEdges <= 1) continue;
            hasHyperedges = true;
        }
        if (hasExternalPorts) {
            graphProperties.add(GraphProperties.EXTERNAL_PORTS);
        }
        if (hasHyperedges) {
            graphProperties.add(GraphProperties.HYPEREDGES);
        }
    }

    private void transformExternalPort(KNode kgraph, LGraph lgraph, KPort kport) {
        Float portOffset;
        KShapeLayout kgraphLayout = (KShapeLayout)kgraph.getData(KShapeLayout.class);
        KShapeLayout kportLayout = (KShapeLayout)kport.getData(KShapeLayout.class);
        KVector kportPosition = new KVector((double)kportLayout.getXpos() + (double)kportLayout.getWidth() / 2.0, (double)kportLayout.getYpos() + (double)kportLayout.getHeight() / 2.0);
        int netFlow = this.calculateNetFlow(kport);
        PortSide portSide = (PortSide)kportLayout.getProperty(LayoutOptions.PORT_SIDE);
        PortConstraints portConstraints = (PortConstraints)kgraphLayout.getProperty(LayoutOptions.PORT_CONSTRAINTS);
        Direction layoutDirection = (Direction)lgraph.getProperty(LayoutOptions.DIRECTION);
        if (portSide == PortSide.UNDEFINED) {
            portSide = KimlUtil.calcPortSide((KPort)kport, (Direction)layoutDirection);
            kportLayout.setProperty(LayoutOptions.PORT_SIDE, (Object)portSide);
        }
        if ((portOffset = (Float)kportLayout.getProperty(LayoutOptions.OFFSET)) == null) {
            portOffset = kportLayout.getXpos() == 0.0f && kportLayout.getYpos() == 0.0f ? Float.valueOf(0.0f) : Float.valueOf(KimlUtil.calcPortOffset((KPort)kport, (PortSide)portSide));
            kportLayout.setProperty(LayoutOptions.OFFSET, (Object)portOffset);
        }
        KVector graphSize = new KVector((double)kgraphLayout.getWidth(), (double)kgraphLayout.getHeight());
        LNode dummy = LGraphUtil.createExternalPortDummy((IPropertyHolder)kportLayout, portConstraints, portSide, netFlow, graphSize, kportPosition, new KVector((double)kportLayout.getWidth(), (double)kportLayout.getHeight()), layoutDirection, lgraph);
        dummy.setProperty(InternalProperties.ORIGIN, kport);
        if (kgraphLayout.getProperty(LayoutOptions.PORT_LABEL_PLACEMENT) == PortLabelPlacement.INSIDE) {
            LPort dummyPort = dummy.getPorts().get(0);
            dummy.setProperty(LayoutOptions.PORT_LABEL_PLACEMENT, PortLabelPlacement.OUTSIDE);
            for (KLabel klabel : kport.getLabels()) {
                KShapeLayout labelLayout = (KShapeLayout)klabel.getData(KShapeLayout.class);
                if (((Boolean)labelLayout.getProperty(LayoutOptions.NO_LAYOUT)).booleanValue()) continue;
                dummyPort.getLabels().add(this.transformLabel(klabel));
            }
        }
        lgraph.getLayerlessNodes().add(dummy);
        this.nodeAndPortMap.put((KGraphElement)kport, dummy);
    }

    private int calculateNetFlow(KPort kport) {
        KNode kgraph = kport.getNode();
        boolean insideSelfLoopsEnabled = (Boolean)((KLayoutData)kgraph.getData(KLayoutData.class)).getProperty(LayoutOptions.SELF_LOOP_INSIDE);
        int outputPortVote = 0;
        int inputPortVote = 0;
        for (KEdge edge : kport.getEdges()) {
            boolean isInsideSelfLoop;
            boolean isSelfLoop = edge.getSource() == edge.getTarget();
            boolean bl = isInsideSelfLoop = isSelfLoop && insideSelfLoopsEnabled && (Boolean)((KEdgeLayout)edge.getData(KEdgeLayout.class)).getProperty(LayoutOptions.SELF_LOOP_INSIDE) != false;
            if (edge.getSourcePort() == kport) {
                if (isSelfLoop && isInsideSelfLoop) {
                    ++inputPortVote;
                    continue;
                }
                if (isSelfLoop && !isInsideSelfLoop) {
                    ++outputPortVote;
                    continue;
                }
                if (edge.getTarget().getParent() == kgraph || edge.getTarget() == kgraph) {
                    ++inputPortVote;
                    continue;
                }
                ++outputPortVote;
                continue;
            }
            if (isSelfLoop && isInsideSelfLoop) {
                ++outputPortVote;
                continue;
            }
            if (isSelfLoop && isInsideSelfLoop) {
                ++inputPortVote;
                continue;
            }
            if (edge.getSource().getParent() == kgraph || edge.getSource() == kgraph) {
                ++outputPortVote;
                continue;
            }
            ++inputPortVote;
        }
        return outputPortVote - inputPortVote;
    }

    private LNode transformNode(KNode knode, LGraph lgraph) {
        KShapeLayout nodeLayout = (KShapeLayout)knode.getData(KShapeLayout.class);
        LNode lnode = new LNode(lgraph);
        lnode.copyProperties((IPropertyHolder)nodeLayout);
        lnode.setProperty(InternalProperties.ORIGIN, knode);
        lnode.getSize().x = nodeLayout.getWidth();
        lnode.getSize().y = nodeLayout.getHeight();
        lnode.getPosition().x = nodeLayout.getXpos();
        lnode.getPosition().y = nodeLayout.getYpos();
        lgraph.getLayerlessNodes().add(lnode);
        this.nodeAndPortMap.put((KGraphElement)knode, lnode);
        if (!knode.getChildren().isEmpty()) {
            lnode.setProperty(InternalProperties.COMPOUND_NODE, true);
        }
        Set graphProperties = (Set)lgraph.getProperty(InternalProperties.GRAPH_PROPERTIES);
        PortConstraints portConstraints = (PortConstraints)lnode.getProperty(LayoutOptions.PORT_CONSTRAINTS);
        if (portConstraints == PortConstraints.UNDEFINED) {
            lnode.setProperty(LayoutOptions.PORT_CONSTRAINTS, PortConstraints.FREE);
        } else if (portConstraints != PortConstraints.FREE) {
            graphProperties.add(GraphProperties.NON_FREE_PORTS);
        }
        Direction direction = (Direction)lgraph.getProperty(LayoutOptions.DIRECTION);
        for (KPort kport : knode.getPorts()) {
            KShapeLayout kportLayout = (KShapeLayout)kport.getData(KShapeLayout.class);
            if (((Boolean)kportLayout.getProperty(LayoutOptions.NO_LAYOUT)).booleanValue()) continue;
            this.transformPort(kport, lnode, graphProperties, direction, portConstraints);
        }
        for (KLabel klabel : knode.getLabels()) {
            KShapeLayout labelLayout = (KShapeLayout)klabel.getData(KShapeLayout.class);
            if (((Boolean)labelLayout.getProperty(LayoutOptions.NO_LAYOUT)).booleanValue()) continue;
            lnode.getLabels().add(this.transformLabel(klabel));
        }
        if (((Boolean)lnode.getProperty(LayoutOptions.COMMENT_BOX)).booleanValue()) {
            graphProperties.add(GraphProperties.COMMENTS);
        }
        if (((Boolean)lnode.getProperty(LayoutOptions.HYPERNODE)).booleanValue()) {
            graphProperties.add(GraphProperties.HYPERNODES);
            graphProperties.add(GraphProperties.HYPEREDGES);
            lnode.setProperty(LayoutOptions.PORT_CONSTRAINTS, PortConstraints.FREE);
        }
        return lnode;
    }

    private LPort transformPort(KPort kport, LNode parentLNode, Set<GraphProperties> graphProperties, Direction layoutDirection, PortConstraints portConstraints) {
        KShapeLayout kportLayout = (KShapeLayout)kport.getData(KShapeLayout.class);
        LPort lport = new LPort();
        lport.copyProperties((IPropertyHolder)kportLayout);
        lport.setSide((PortSide)kportLayout.getProperty(LayoutOptions.PORT_SIDE));
        lport.setProperty(InternalProperties.ORIGIN, kport);
        lport.setNode(parentLNode);
        KVector portSize = lport.getSize();
        portSize.x = kportLayout.getWidth();
        portSize.y = kportLayout.getHeight();
        KVector portPos = lport.getPosition();
        portPos.x = kportLayout.getXpos();
        portPos.y = kportLayout.getYpos();
        this.nodeAndPortMap.put((KGraphElement)kport, lport);
        for (KEdge edge : kport.getEdges()) {
            if (edge.getSource() == kport.getNode()) {
                if (!KimlUtil.isDescendant((KNode)edge.getTarget(), (KNode)kport.getNode())) continue;
                lport.setProperty(InternalProperties.INSIDE_CONNECTIONS, true);
                break;
            }
            if (!KimlUtil.isDescendant((KNode)edge.getSource(), (KNode)kport.getNode())) continue;
            lport.setProperty(InternalProperties.INSIDE_CONNECTIONS, true);
            break;
        }
        LGraphUtil.initializePort(lport, portConstraints, layoutDirection, (KVector)kportLayout.getProperty(LayoutOptions.PORT_ANCHOR));
        for (KLabel klabel : kport.getLabels()) {
            KShapeLayout labelLayout = (KShapeLayout)klabel.getData(KShapeLayout.class);
            if (((Boolean)labelLayout.getProperty(LayoutOptions.NO_LAYOUT)).booleanValue()) continue;
            lport.getLabels().add(this.transformLabel(klabel));
        }
        if (kport.getEdges().size() > 1) {
            graphProperties.add(GraphProperties.HYPEREDGES);
        }
        switch (layoutDirection) {
            case RIGHT: 
            case LEFT: {
                if (lport.getSide() != PortSide.NORTH && lport.getSide() != PortSide.SOUTH) break;
                graphProperties.add(GraphProperties.NORTH_SOUTH_PORTS);
                break;
            }
            case DOWN: 
            case UP: {
                if (lport.getSide() != PortSide.EAST && lport.getSide() != PortSide.WEST) break;
                graphProperties.add(GraphProperties.NORTH_SOUTH_PORTS);
            }
        }
        return lport;
    }

    private LEdge transformEdge(KEdge kedge, LGraph lgraph) {
        boolean bendPointsRequired;
        PortType portType;
        LNode sourceLNode = (LNode)this.nodeAndPortMap.get(kedge.getSource());
        LNode targetLNode = (LNode)this.nodeAndPortMap.get(kedge.getTarget());
        LPort sourceLPort = null;
        LPort targetLPort = null;
        if (kedge.getSourcePort() != null) {
            assert (kedge.getSource() == kedge.getSourcePort().getNode());
            LGraphElement sourceElem = this.nodeAndPortMap.get(kedge.getSourcePort());
            if (sourceElem instanceof LPort) {
                sourceLPort = (LPort)sourceElem;
            } else if (sourceElem instanceof LNode) {
                sourceLNode = (LNode)sourceElem;
                sourceLPort = sourceLNode.getPorts().get(0);
            }
        }
        if (kedge.getTargetPort() != null) {
            assert (kedge.getTarget() == kedge.getTargetPort().getNode());
            LGraphElement targetElem = this.nodeAndPortMap.get(kedge.getTargetPort());
            if (targetElem instanceof LPort) {
                targetLPort = (LPort)targetElem;
            } else if (targetElem instanceof LNode) {
                targetLNode = (LNode)targetElem;
                targetLPort = targetLNode.getPorts().get(0);
            }
        }
        if (sourceLNode == null || targetLNode == null) {
            return null;
        }
        KEdgeLayout kedgeLayout = (KEdgeLayout)kedge.getData(KEdgeLayout.class);
        LEdge ledge = new LEdge();
        ledge.copyProperties((IPropertyHolder)kedgeLayout);
        ledge.setProperty(InternalProperties.ORIGIN, kedge);
        ledge.setProperty(LayoutOptions.JUNCTION_POINTS, null);
        Set graphProperties = (Set)lgraph.getProperty(InternalProperties.GRAPH_PROPERTIES);
        if (sourceLNode == targetLNode) {
            graphProperties.add(GraphProperties.SELF_LOOPS);
        }
        if (sourceLPort == null) {
            portType = PortType.OUTPUT;
            KVector sourcePoint = null;
            if (((PortConstraints)sourceLNode.getProperty(LayoutOptions.PORT_CONSTRAINTS)).isSideFixed()) {
                sourcePoint = kedgeLayout.getSourcePoint().createVector();
                if (KimlUtil.isDescendant((KNode)kedge.getTarget(), (KNode)kedge.getSource())) {
                    portType = PortType.INPUT;
                    sourcePoint.add(sourceLNode.getPosition());
                }
            }
            sourceLPort = LGraphUtil.createPort(sourceLNode, sourcePoint, portType, lgraph);
        }
        if (targetLPort == null) {
            portType = PortType.INPUT;
            Iterator targetPoint = null;
            if (((PortConstraints)targetLNode.getProperty(LayoutOptions.PORT_CONSTRAINTS)).isSideFixed()) {
                targetPoint = kedgeLayout.getTargetPoint().createVector();
                if (kedge.getSource().getParent() != kedge.getTarget().getParent()) {
                    KNode referenceNode = kedge.getSource();
                    if (!KimlUtil.isDescendant((KNode)kedge.getTarget(), (KNode)kedge.getSource())) {
                        referenceNode = referenceNode.getParent();
                        if (KimlUtil.isDescendant((KNode)kedge.getSource(), (KNode)kedge.getTarget())) {
                            portType = PortType.OUTPUT;
                        }
                    }
                    KimlUtil.toAbsolute((KVector)targetPoint, (KNode)referenceNode);
                    KimlUtil.toRelative((KVector)targetPoint, (KNode)kedge.getTarget().getParent());
                }
            }
            targetLPort = LGraphUtil.createPort(targetLNode, (KVector)targetPoint, portType, targetLNode.getGraph());
        }
        ledge.setSource(sourceLPort);
        ledge.setTarget(targetLPort);
        for (KLabel klabel : kedge.getLabels()) {
            KShapeLayout labelLayout = (KShapeLayout)klabel.getData(KShapeLayout.class);
            if (((Boolean)labelLayout.getProperty(LayoutOptions.NO_LAYOUT)).booleanValue()) continue;
            LLabel llabel = this.transformLabel(klabel);
            ledge.getLabels().add(llabel);
            switch ((EdgeLabelPlacement)llabel.getProperty(LayoutOptions.EDGE_LABEL_PLACEMENT)) {
                case HEAD: 
                case TAIL: {
                    graphProperties.add(GraphProperties.END_LABELS);
                    break;
                }
                case UNDEFINED: 
                case CENTER: {
                    graphProperties.add(GraphProperties.CENTER_LABELS);
                    llabel.setProperty(LayoutOptions.EDGE_LABEL_PLACEMENT, EdgeLabelPlacement.CENTER);
                }
            }
        }
        boolean bl = bendPointsRequired = lgraph.getProperty(Properties.CROSS_MIN) == CrossingMinimizationStrategy.INTERACTIVE || lgraph.getProperty(Properties.NODE_PLACER) == NodePlacementStrategy.INTERACTIVE;
        if (!kedgeLayout.getBendPoints().isEmpty() && bendPointsRequired) {
            KVectorChain bendpoints = new KVectorChain();
            for (KPoint point : kedgeLayout.getBendPoints()) {
                bendpoints.add((Object)point.createVector());
            }
            ledge.setProperty(InternalProperties.ORIGINAL_BENDPOINTS, bendpoints);
        }
        return ledge;
    }

    private LLabel transformLabel(KLabel klabel) {
        KShapeLayout klabelLayout = (KShapeLayout)klabel.getData(KShapeLayout.class);
        LLabel newLabel = new LLabel(klabel.getText());
        newLabel.copyProperties((IPropertyHolder)klabelLayout);
        newLabel.setProperty(InternalProperties.ORIGIN, klabel);
        newLabel.getSize().x = klabelLayout.getWidth();
        newLabel.getSize().y = klabelLayout.getHeight();
        newLabel.getPosition().x = klabelLayout.getXpos();
        newLabel.getPosition().y = klabelLayout.getYpos();
        return newLabel;
    }
}

