/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.graph.transform;

import com.google.common.collect.Lists;
import de.cau.cs.kieler.core.kgraph.KEdge;
import de.cau.cs.kieler.core.kgraph.KLabel;
import de.cau.cs.kieler.core.kgraph.KNode;
import de.cau.cs.kieler.core.kgraph.KPort;
import de.cau.cs.kieler.core.math.KVector;
import de.cau.cs.kieler.core.math.KVectorChain;
import de.cau.cs.kieler.kiml.klayoutdata.KEdgeLayout;
import de.cau.cs.kieler.kiml.klayoutdata.KInsets;
import de.cau.cs.kieler.kiml.klayoutdata.KShapeLayout;
import de.cau.cs.kieler.kiml.options.EdgeRouting;
import de.cau.cs.kieler.kiml.options.LayoutOptions;
import de.cau.cs.kieler.kiml.options.PortConstraints;
import de.cau.cs.kieler.kiml.options.PortLabelPlacement;
import de.cau.cs.kieler.kiml.options.SizeConstraint;
import de.cau.cs.kieler.kiml.options.SizeOptions;
import de.cau.cs.kieler.kiml.util.KimlUtil;
import de.cau.cs.kieler.klay.layered.graph.LEdge;
import de.cau.cs.kieler.klay.layered.graph.LGraph;
import de.cau.cs.kieler.klay.layered.graph.LGraphUtil;
import de.cau.cs.kieler.klay.layered.graph.LInsets;
import de.cau.cs.kieler.klay.layered.graph.LLabel;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.graph.LPort;
import de.cau.cs.kieler.klay.layered.properties.GraphProperties;
import de.cau.cs.kieler.klay.layered.properties.InternalProperties;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Set;

class KGraphLayoutTransferrer {
    KGraphLayoutTransferrer() {
    }

    public void applyLayout(LGraph lgraph) {
        Object graphOrigin = lgraph.getProperty(InternalProperties.ORIGIN);
        if (!(graphOrigin instanceof KNode)) {
            return;
        }
        KNode parentKNode = (KNode)graphOrigin;
        LNode parentLNode = (LNode)((Object)lgraph.getProperty(InternalProperties.PARENT_LNODE));
        KVector offset = new KVector(lgraph.getOffset());
        KShapeLayout parentLayout = (KShapeLayout)parentKNode.getData(KShapeLayout.class);
        LInsets lInsets = lgraph.getInsets();
        KInsets kInsets = parentLayout.getInsets();
        EnumSet sizeOptions = (EnumSet)parentLayout.getProperty(LayoutOptions.SIZE_OPTIONS);
        KVector additionalInsets = new KVector();
        if (sizeOptions.contains(SizeOptions.APPLY_ADDITIONAL_INSETS)) {
            additionalInsets.x = lInsets.left - (double)kInsets.getLeft();
            additionalInsets.y = lInsets.top - (double)kInsets.getTop();
            offset.x += additionalInsets.x;
            offset.y += additionalInsets.y;
        }
        if (sizeOptions.contains(SizeOptions.COMPUTE_INSETS)) {
            kInsets.setBottom((float)lInsets.bottom);
            kInsets.setTop((float)lInsets.top);
            kInsets.setLeft((float)lInsets.left);
            kInsets.setRight((float)lInsets.right);
        }
        ArrayList edgeList = Lists.newArrayList();
        for (LNode lnode : lgraph.getLayerlessNodes()) {
            Object origin = lnode.getProperty(InternalProperties.ORIGIN);
            if (origin instanceof KNode) {
                this.applyNodeLayout(lnode, offset);
            } else if (origin instanceof KPort && parentLNode == null) {
                KPort kport = (KPort)origin;
                KShapeLayout portLayout = (KShapeLayout)kport.getData(KShapeLayout.class);
                KVector portPosition = LGraphUtil.getExternalPortPosition(lgraph, lnode, portLayout.getWidth(), portLayout.getHeight());
                portLayout.applyVector(portPosition);
            }
            for (LPort port : lnode.getPorts()) {
                port.getOutgoingEdges().stream().filter(edge -> !LGraphUtil.isDescendant(edge.getTarget().getNode(), lnode)).forEach(edge -> {
                    boolean bl = edgeList.add(edge);
                });
            }
        }
        if (parentLNode != null) {
            for (LPort port : parentLNode.getPorts()) {
                port.getOutgoingEdges().stream().filter(edge -> LGraphUtil.isDescendant(edge.getTarget().getNode(), parentLNode)).forEach(edge -> {
                    boolean bl = edgeList.add(edge);
                });
            }
        }
        EdgeRouting routing = (EdgeRouting)parentLayout.getProperty(InternalProperties.EDGE_ROUTING);
        for (LEdge ledge : edgeList) {
            this.applyEdgeLayout(ledge, routing, offset, additionalInsets);
        }
        this.applyParentNodeLayout(lgraph);
        for (LNode lnode : lgraph.getLayerlessNodes()) {
            LGraph nestedGraph = (LGraph)lnode.getProperty(InternalProperties.NESTED_LGRAPH);
            if (nestedGraph == null) continue;
            this.applyLayout(nestedGraph);
        }
    }

    private void applyNodeLayout(LNode lnode, KVector offset) {
        KNode knode = (KNode)lnode.getProperty(InternalProperties.ORIGIN);
        KShapeLayout nodeLayout = (KShapeLayout)knode.getData(KShapeLayout.class);
        nodeLayout.setXpos((float)(lnode.getPosition().x + offset.x));
        nodeLayout.setYpos((float)(lnode.getPosition().y + offset.y));
        if (!((EnumSet)nodeLayout.getProperty(LayoutOptions.SIZE_CONSTRAINT)).isEmpty() || lnode.getProperty(InternalProperties.NESTED_LGRAPH) != null) {
            nodeLayout.setWidth((float)lnode.getSize().x);
            nodeLayout.setHeight((float)lnode.getSize().y);
        }
        for (LPort lport : lnode.getPorts()) {
            Object origin = lport.getProperty(InternalProperties.ORIGIN);
            if (!(origin instanceof KPort)) continue;
            KPort kport = (KPort)origin;
            KShapeLayout portLayout = (KShapeLayout)kport.getData(KShapeLayout.class);
            portLayout.applyVector(lport.getPosition());
            portLayout.setProperty(LayoutOptions.PORT_SIDE, (Object)lport.getSide());
        }
        boolean nodeHasLabelPlacement = !((EnumSet)lnode.getProperty(LayoutOptions.NODE_LABEL_PLACEMENT)).isEmpty();
        for (LLabel llabel : lnode.getLabels()) {
            if (!nodeHasLabelPlacement && ((EnumSet)llabel.getProperty(LayoutOptions.NODE_LABEL_PLACEMENT)).isEmpty()) continue;
            KLabel klabel = (KLabel)llabel.getProperty(InternalProperties.ORIGIN);
            KShapeLayout klabelLayout = (KShapeLayout)klabel.getData(KShapeLayout.class);
            klabelLayout.applyVector(llabel.getPosition());
        }
        if (lnode.getProperty(LayoutOptions.PORT_LABEL_PLACEMENT) != PortLabelPlacement.FIXED) {
            for (LPort lport : lnode.getPorts()) {
                for (LLabel label : lport.getLabels()) {
                    KLabel klabel = (KLabel)label.getProperty(InternalProperties.ORIGIN);
                    KShapeLayout klabelLayout = (KShapeLayout)klabel.getData(KShapeLayout.class);
                    klabelLayout.setWidth((float)label.getSize().x);
                    klabelLayout.setHeight((float)label.getSize().y);
                    klabelLayout.applyVector(label.getPosition());
                }
            }
        }
    }

    private void applyEdgeLayout(LEdge ledge, EdgeRouting routing, KVector offset, KVector additionalInsets) {
        KVector sourcePoint;
        KEdge kedge = (KEdge)ledge.getProperty(InternalProperties.ORIGIN);
        if (kedge == null) {
            return;
        }
        if (ledge.isSelfLoop() && routing != EdgeRouting.ORTHOGONAL && routing != EdgeRouting.SPLINES) {
            return;
        }
        KEdgeLayout edgeLayout = (KEdgeLayout)kedge.getData(KEdgeLayout.class);
        KVectorChain bendPoints = ledge.getBendPoints();
        KVector edgeOffset = offset;
        if (LGraphUtil.isDescendant(ledge.getTarget().getNode(), ledge.getSource().getNode())) {
            LPort sourcePort = ledge.getSource();
            sourcePoint = KVector.sum((KVector[])new KVector[]{sourcePort.getPosition(), sourcePort.getAnchor()});
            LInsets sourceInsets = sourcePort.getNode().getInsets();
            sourcePoint.add(-sourceInsets.left, -sourceInsets.top);
            sourcePoint.sub(offset);
            sourcePoint.add(additionalInsets);
        } else {
            sourcePoint = ledge.getSource().getAbsoluteAnchor();
        }
        bendPoints.addFirst((Object)sourcePoint);
        KVector targetPoint = ledge.getTarget().getAbsoluteAnchor();
        if (ledge.getProperty(InternalProperties.TARGET_OFFSET) != null) {
            targetPoint.add((KVector)ledge.getProperty(InternalProperties.TARGET_OFFSET));
        }
        bendPoints.addLast((Object)targetPoint);
        bendPoints.offset(edgeOffset);
        edgeLayout.applyVectorChain(bendPoints);
        for (LLabel label : ledge.getLabels()) {
            KLabel klabel = (KLabel)label.getProperty(InternalProperties.ORIGIN);
            KShapeLayout klabelLayout = (KShapeLayout)klabel.getData(KShapeLayout.class);
            klabelLayout.setWidth((float)label.getSize().x);
            klabelLayout.setHeight((float)label.getSize().y);
            klabelLayout.applyVector(label.getPosition().add(edgeOffset));
        }
        KVectorChain junctionPoints = (KVectorChain)ledge.getProperty(LayoutOptions.JUNCTION_POINTS);
        if (junctionPoints != null) {
            junctionPoints.offset(edgeOffset);
            edgeLayout.setProperty(LayoutOptions.JUNCTION_POINTS, (Object)junctionPoints);
        } else {
            edgeLayout.setProperty(LayoutOptions.JUNCTION_POINTS, null);
        }
        if (routing == EdgeRouting.SPLINES) {
            edgeLayout.setProperty(InternalProperties.EDGE_ROUTING, (Object)EdgeRouting.SPLINES);
        } else {
            edgeLayout.setProperty(InternalProperties.EDGE_ROUTING, null);
        }
    }

    private void applyParentNodeLayout(LGraph lgraph) {
        KNode knode = (KNode)lgraph.getProperty(InternalProperties.ORIGIN);
        KShapeLayout knodeLayout = (KShapeLayout)knode.getData(KShapeLayout.class);
        KVector actualGraphSize = lgraph.getActualSize();
        knodeLayout.setProperty(LayoutOptions.SIZE_CONSTRAINT, (Object)SizeConstraint.fixed());
        if (lgraph.getProperty(InternalProperties.PARENT_LNODE) == null) {
            Set graphProps = (Set)lgraph.getProperty(InternalProperties.GRAPH_PROPERTIES);
            if (graphProps.contains((Object)GraphProperties.EXTERNAL_PORTS)) {
                knodeLayout.setProperty(LayoutOptions.PORT_CONSTRAINTS, (Object)PortConstraints.FIXED_POS);
                KimlUtil.resizeNode((KNode)knode, (float)((float)actualGraphSize.x), (float)((float)actualGraphSize.y), (boolean)false, (boolean)true);
            } else {
                KimlUtil.resizeNode((KNode)knode, (float)((float)actualGraphSize.x), (float)((float)actualGraphSize.y), (boolean)true, (boolean)true);
            }
        }
    }
}

