/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.intermediate;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import de.cau.cs.kieler.core.alg.IKielerProgressMonitor;
import de.cau.cs.kieler.kiml.options.PortSide;
import de.cau.cs.kieler.klay.layered.ILayoutProcessor;
import de.cau.cs.kieler.klay.layered.graph.LEdge;
import de.cau.cs.kieler.klay.layered.graph.LGraph;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.graph.Layer;
import de.cau.cs.kieler.klay.layered.properties.InternalProperties;
import de.cau.cs.kieler.klay.layered.properties.LayerConstraint;
import de.cau.cs.kieler.klay.layered.properties.Properties;
import java.util.LinkedList;

public class BigNodesIntermediateProcessor
implements ILayoutProcessor {
    private LGraph layeredGraph;

    @Override
    public void process(LGraph theLayeredGraph, IKielerProgressMonitor monitor) {
        monitor.begin("Big nodes intermediate-processing", 1.0f);
        this.layeredGraph = theLayeredGraph;
        for (Layer layer : this.layeredGraph) {
            LinkedList nodes = Lists.newLinkedList(layer.getNodes());
            Iterable bigNodes = Iterables.filter((Iterable)nodes, (Predicate)new Predicate<LNode>(){

                public boolean apply(LNode node) {
                    return BigNodesIntermediateProcessor.this.isInitialBigNode(node);
                }
            });
            for (LNode node : bigNodes) {
                if (node.getProperty(Properties.LAYER_CONSTRAINT) == LayerConstraint.LAST || node.getProperty(Properties.LAYER_CONSTRAINT) == LayerConstraint.LAST_SEPARATE) {
                    LNode last = this.condenseBigNodesChain(node, false);
                    last.setProperty(Properties.LAYER_CONSTRAINT, (Object)((LayerConstraint)((Object)node.getProperty(Properties.LAYER_CONSTRAINT))));
                    node.setProperty(Properties.LAYER_CONSTRAINT, (Object)LayerConstraint.NONE);
                    continue;
                }
                this.condenseBigNodesChain(node, true);
            }
        }
        monitor.done();
    }

    private LNode condenseBigNodesChain(LNode start, boolean left) {
        LinkedList outs = Lists.newLinkedList(start.getOutgoingEdges());
        for (LEdge edge : outs) {
            LNode target = edge.getTarget().getNode();
            if (this.isInitialBigNode(target) || target.getType() != LNode.NodeType.BIG_NODE || ((Boolean)edge.getProperty(InternalProperties.REVERSED)).booleanValue() || edge.getTarget().getSide() != PortSide.WEST) continue;
            int gap = target.getLayer().getIndex() - start.getLayer().getIndex();
            if (gap > 1) {
                int newIndex = 0;
                newIndex = left ? start.getLayer().getIndex() + 1 : target.getLayer().getIndex() - 1;
                assert (newIndex >= 0);
                assert (newIndex < this.layeredGraph.getLayers().size());
                Layer newLayer = this.layeredGraph.getLayers().get(newIndex);
                target.setLayer(newLayer);
            }
            this.condenseBigNodesChain(target, left);
        }
        return start;
    }

    private boolean isInitialBigNode(LNode node) {
        return (Boolean)node.getProperty(InternalProperties.BIG_NODE_INITIAL) != false && node.getProperty(InternalProperties.ORIGIN) != null;
    }
}

