/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.intermediate;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import de.cau.cs.kieler.core.alg.IKielerProgressMonitor;
import de.cau.cs.kieler.kiml.options.PortSide;
import de.cau.cs.kieler.klay.layered.ILayoutProcessor;
import de.cau.cs.kieler.klay.layered.graph.LEdge;
import de.cau.cs.kieler.klay.layered.graph.LGraph;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.graph.LPort;
import de.cau.cs.kieler.klay.layered.graph.Layer;
import de.cau.cs.kieler.klay.layered.properties.InternalProperties;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class BigNodesPostProcessor
implements ILayoutProcessor {
    private LGraph layeredGraph;

    @Override
    public void process(LGraph theLayeredGraph, IKielerProgressMonitor monitor) {
        monitor.begin("Big nodes post-processing", 1.0f);
        this.layeredGraph = theLayeredGraph;
        for (Layer layer : this.layeredGraph) {
            Iterable bigNodes = Iterables.filter(layer.getNodes(), (Predicate)new Predicate<LNode>(){

                public boolean apply(LNode node) {
                    return BigNodesPostProcessor.this.isInitialBigNode(node);
                }
            });
            for (LNode node : bigNodes) {
                Float originalSize = (Float)node.getProperty(InternalProperties.BIG_NODE_ORIGINAL_SIZE);
                LNode lastDummy = this.removeBigNodeChain(node);
                ArrayList toMove = Lists.newArrayList();
                for (LPort p : lastDummy.getPorts(PortSide.EAST)) {
                    toMove.add(p);
                    double offset = p.getPosition().x - lastDummy.getSize().x;
                    p.getPosition().x = (double)originalSize.floatValue() + offset;
                }
                node.getSize().x = originalSize.doubleValue();
                for (LPort p : toMove) {
                    p.setNode(node);
                }
                if (this.layeredGraph.getSize().x < node.getPosition().x + node.getSize().x) {
                    this.layeredGraph.getSize().x = node.getPosition().x + node.getSize().x;
                }
                List labels = (List)node.getProperty(InternalProperties.BIGNODES_ORIG_LABELS);
                node.getLabels().addAll(labels);
                Function f = (Function)node.getProperty(InternalProperties.BIGNODES_POST_PROCESS);
                if (f == null) continue;
                f.apply(null);
            }
        }
        monitor.done();
    }

    private LNode removeBigNodeChain(LNode start) {
        LinkedList outs = Lists.newLinkedList(start.getOutgoingEdges());
        Iterator iterator = outs.iterator();
        if (iterator.hasNext()) {
            LEdge edge = (LEdge)((Object)iterator.next());
            LNode target = edge.getTarget().getNode();
            if (target.getType() == LNode.NodeType.BIG_NODE && !this.isInitialBigNode(target)) {
                target.getLayer().getNodes().remove((Object)target);
                edge.getSource().setNode(null);
                edge.getTarget().setNode(null);
                return this.removeBigNodeChain(target);
            }
            return start;
        }
        return start;
    }

    private boolean isInitialBigNode(LNode node) {
        return (Boolean)node.getProperty(InternalProperties.BIG_NODE_INITIAL) != false && node.getProperty(InternalProperties.ORIGIN) != null;
    }
}

