/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.intermediate;

import de.cau.cs.kieler.core.alg.IKielerProgressMonitor;
import de.cau.cs.kieler.kiml.options.LayoutOptions;
import de.cau.cs.kieler.kiml.options.PortConstraints;
import de.cau.cs.kieler.kiml.options.PortSide;
import de.cau.cs.kieler.klay.layered.ILayoutProcessor;
import de.cau.cs.kieler.klay.layered.graph.LEdge;
import de.cau.cs.kieler.klay.layered.graph.LGraph;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.graph.LPort;
import de.cau.cs.kieler.klay.layered.properties.EdgeConstraint;
import de.cau.cs.kieler.klay.layered.properties.InternalProperties;
import de.cau.cs.kieler.klay.layered.properties.LayerConstraint;
import de.cau.cs.kieler.klay.layered.properties.PortType;
import de.cau.cs.kieler.klay.layered.properties.Properties;

public final class EdgeAndLayerConstraintEdgeReverser
implements ILayoutProcessor {
    @Override
    public void process(LGraph layeredGraph, IKielerProgressMonitor monitor) {
        monitor.begin("Edge and layer constraint edge reversal", 1.0f);
        for (LNode node : layeredGraph.getLayerlessNodes()) {
            LayerConstraint layerConstraint = (LayerConstraint)((Object)node.getProperty(Properties.LAYER_CONSTRAINT));
            EdgeConstraint edgeConstraint = null;
            switch (layerConstraint) {
                case FIRST: 
                case FIRST_SEPARATE: {
                    edgeConstraint = EdgeConstraint.OUTGOING_ONLY;
                    break;
                }
                case LAST: 
                case LAST_SEPARATE: {
                    edgeConstraint = EdgeConstraint.INCOMING_ONLY;
                }
            }
            if (edgeConstraint != null) {
                node.setProperty(InternalProperties.EDGE_CONSTRAINT, (Object)EdgeConstraint.OUTGOING_ONLY);
                if (edgeConstraint == EdgeConstraint.INCOMING_ONLY) {
                    this.reverseEdges(layeredGraph, node, layerConstraint, PortType.OUTPUT);
                    continue;
                }
                if (edgeConstraint != EdgeConstraint.OUTGOING_ONLY) continue;
                this.reverseEdges(layeredGraph, node, layerConstraint, PortType.INPUT);
                continue;
            }
            if (!((PortConstraints)node.getProperty(LayoutOptions.PORT_CONSTRAINTS)).isSideFixed() || node.getPorts().isEmpty()) continue;
            boolean allPortsReversed = true;
            block5: for (LPort port : node.getPorts()) {
                LayerConstraint lc;
                if (!(port.getSide() == PortSide.EAST && port.getNetFlow() > 0 || port.getSide() == PortSide.WEST && port.getNetFlow() < 0)) {
                    allPortsReversed = false;
                    break;
                }
                if (port.getSide() == PortSide.WEST) {
                    for (LEdge e : port.getOutgoingEdges()) {
                        lc = (LayerConstraint)((Object)e.getTarget().getNode().getProperty(Properties.LAYER_CONSTRAINT));
                        if (lc != LayerConstraint.LAST && lc != LayerConstraint.LAST_SEPARATE) continue;
                        allPortsReversed = false;
                        break;
                    }
                }
                if (port.getSide() != PortSide.EAST) continue;
                for (LEdge e : port.getIncomingEdges()) {
                    lc = (LayerConstraint)((Object)e.getSource().getNode().getProperty(Properties.LAYER_CONSTRAINT));
                    if (lc != LayerConstraint.FIRST && lc != LayerConstraint.FIRST_SEPARATE) continue;
                    allPortsReversed = false;
                    continue block5;
                }
            }
            if (!allPortsReversed) continue;
            this.reverseEdges(layeredGraph, node, layerConstraint, PortType.UNDEFINED);
        }
        monitor.done();
    }

    private void reverseEdges(LGraph layeredGraph, LNode node, LayerConstraint nodeLayerConstraint, PortType type) {
        LPort[] ports;
        LPort[] lPortArray = ports = node.getPorts().toArray(new LPort[node.getPorts().size()]);
        int n = ports.length;
        int n2 = 0;
        while (n2 < n) {
            LEdge edge;
            int n3;
            int n4;
            LEdge[] lEdgeArray;
            LPort port = lPortArray[n2];
            if (type != PortType.INPUT) {
                LEdge[] outgoing;
                lEdgeArray = outgoing = port.getOutgoingEdges().toArray(new LEdge[port.getOutgoingEdges().size()]);
                n4 = outgoing.length;
                n3 = 0;
                while (n3 < n4) {
                    edge = lEdgeArray[n3];
                    LayerConstraint targetLayerConstraint = (LayerConstraint)((Object)edge.getTarget().getNode().getProperty(Properties.LAYER_CONSTRAINT));
                    if (!(((Boolean)edge.getProperty(InternalProperties.REVERSED)).booleanValue() || nodeLayerConstraint == LayerConstraint.LAST && targetLayerConstraint == LayerConstraint.LAST_SEPARATE)) {
                        edge.reverse(layeredGraph, true);
                    }
                    ++n3;
                }
            }
            if (type != PortType.OUTPUT) {
                LEdge[] incoming = port.getIncomingEdges().toArray(new LEdge[port.getIncomingEdges().size()]);
                lEdgeArray = incoming;
                n4 = incoming.length;
                n3 = 0;
                while (n3 < n4) {
                    edge = lEdgeArray[n3];
                    LayerConstraint sourceLayerConstraint = (LayerConstraint)((Object)edge.getSource().getNode().getProperty(Properties.LAYER_CONSTRAINT));
                    if (!(((Boolean)edge.getProperty(InternalProperties.REVERSED)).booleanValue() || nodeLayerConstraint == LayerConstraint.FIRST && sourceLayerConstraint == LayerConstraint.FIRST_SEPARATE)) {
                        edge.reverse(layeredGraph, true);
                    }
                    ++n3;
                }
            }
            ++n2;
        }
    }
}

