/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.intermediate;

import com.google.common.collect.Lists;
import de.cau.cs.kieler.core.alg.IKielerProgressMonitor;
import de.cau.cs.kieler.core.math.KVector;
import de.cau.cs.kieler.core.math.KVectorChain;
import de.cau.cs.kieler.kiml.options.Alignment;
import de.cau.cs.kieler.kiml.options.LayoutOptions;
import de.cau.cs.kieler.kiml.options.NodeLabelPlacement;
import de.cau.cs.kieler.kiml.options.PortSide;
import de.cau.cs.kieler.klay.layered.ILayoutProcessor;
import de.cau.cs.kieler.klay.layered.graph.LEdge;
import de.cau.cs.kieler.klay.layered.graph.LGraph;
import de.cau.cs.kieler.klay.layered.graph.LLabel;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.graph.LPort;
import de.cau.cs.kieler.klay.layered.graph.Layer;
import de.cau.cs.kieler.klay.layered.properties.EdgeLabelSideSelection;
import de.cau.cs.kieler.klay.layered.properties.InLayerConstraint;
import de.cau.cs.kieler.klay.layered.properties.InternalProperties;
import de.cau.cs.kieler.klay.layered.properties.LayerConstraint;
import de.cau.cs.kieler.klay.layered.properties.Properties;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;

public final class GraphTransformer
implements ILayoutProcessor {
    private final Mode mode;

    public GraphTransformer(Mode themode) {
        this.mode = themode;
    }

    @Override
    public void process(LGraph layeredGraph, IKielerProgressMonitor monitor) {
        monitor.begin("Graph transformation (" + (Object)((Object)this.mode) + ")", 1.0f);
        ArrayList nodes = Lists.newArrayList(layeredGraph.getLayerlessNodes());
        for (Layer layer : layeredGraph.getLayers()) {
            nodes.addAll(layer.getNodes());
        }
        switch (this.mode) {
            case MIRROR_X: {
                this.mirrorX(nodes, layeredGraph);
                break;
            }
            case TRANSPOSE: {
                this.transpose(nodes);
                this.transposeEdgeLabelPlacement(layeredGraph);
                this.transpose(layeredGraph.getOffset());
                this.transpose(layeredGraph.getSize());
                break;
            }
            case MIRROR_AND_TRANSPOSE: {
                this.mirrorX(nodes, layeredGraph);
                this.mirrorY(nodes, layeredGraph);
                this.transpose(nodes);
                this.transposeEdgeLabelPlacement(layeredGraph);
                this.transpose(layeredGraph.getOffset());
                this.transpose(layeredGraph.getSize());
            }
        }
        monitor.done();
    }

    private void mirrorX(List<LNode> nodes, LGraph graph) {
        double offset = 0.0;
        if (graph.getSize().x == 0.0) {
            for (LNode node : nodes) {
                offset = Math.max(offset, node.getPosition().x + node.getSize().x + node.getMargin().right);
            }
        } else {
            offset = graph.getSize().x - graph.getOffset().x;
        }
        offset -= graph.getOffset().x;
        for (LNode node : nodes) {
            this.mirrorX(node.getPosition(), offset - node.getSize().x);
            this.mirrorNodeLabelPlacementX(node);
            switch ((Alignment)node.getProperty(LayoutOptions.ALIGNMENT)) {
                case LEFT: {
                    node.setProperty(LayoutOptions.ALIGNMENT, Alignment.RIGHT);
                    break;
                }
                case RIGHT: {
                    node.setProperty(LayoutOptions.ALIGNMENT, Alignment.LEFT);
                }
            }
            KVector nodeSize = node.getSize();
            for (LPort port : node.getPorts()) {
                this.mirrorX(port.getPosition(), nodeSize.x - port.getSize().x);
                this.mirrorX(port.getAnchor(), port.getSize().x);
                this.mirrorPortSideX(port);
                this.reverseIndex(port);
                for (LEdge edge : port.getOutgoingEdges()) {
                    for (KVector bendPoint : edge.getBendPoints()) {
                        this.mirrorX(bendPoint, offset);
                    }
                    KVectorChain junctionPoints = (KVectorChain)edge.getProperty(LayoutOptions.JUNCTION_POINTS);
                    if (junctionPoints != null) {
                        for (KVector jp : junctionPoints) {
                            this.mirrorX(jp, offset);
                        }
                    }
                    for (LLabel label : edge.getLabels()) {
                        this.mirrorX(label.getPosition(), offset - label.getSize().x);
                    }
                }
                for (LLabel label : port.getLabels()) {
                    this.mirrorX(label.getPosition(), -label.getSize().x);
                }
            }
            if (node.getType() == LNode.NodeType.EXTERNAL_PORT) {
                this.mirrorExternalPortSideX(node);
                this.mirrorLayerConstraintX(node);
            }
            for (LLabel label : node.getLabels()) {
                this.mirrorX(label.getPosition(), nodeSize.x - label.getSize().x);
            }
        }
    }

    private void mirrorX(KVector v, double offset) {
        v.x = offset - v.x;
    }

    private void mirrorNodeLabelPlacementX(LNode node) {
        Set oldPlacement = (Set)node.getProperty(LayoutOptions.NODE_LABEL_PLACEMENT);
        if (oldPlacement.isEmpty()) {
            return;
        }
        if (oldPlacement.contains(NodeLabelPlacement.H_LEFT)) {
            oldPlacement.remove(NodeLabelPlacement.H_LEFT);
            oldPlacement.add(NodeLabelPlacement.H_RIGHT);
        } else if (oldPlacement.contains(NodeLabelPlacement.H_RIGHT)) {
            oldPlacement.remove(NodeLabelPlacement.H_RIGHT);
            oldPlacement.add(NodeLabelPlacement.H_LEFT);
        }
    }

    private void mirrorPortSideX(LPort port) {
        port.setSide(this.getMirroredPortSideX(port.getSide()));
    }

    private void mirrorExternalPortSideX(LNode node) {
        node.setProperty(InternalProperties.EXT_PORT_SIDE, this.getMirroredPortSideX((PortSide)node.getProperty(InternalProperties.EXT_PORT_SIDE)));
    }

    private PortSide getMirroredPortSideX(PortSide side) {
        switch (side) {
            case EAST: {
                return PortSide.WEST;
            }
            case WEST: {
                return PortSide.EAST;
            }
        }
        return side;
    }

    private void mirrorLayerConstraintX(LNode node) {
        switch ((LayerConstraint)((Object)node.getProperty(Properties.LAYER_CONSTRAINT))) {
            case FIRST: {
                node.setProperty(Properties.LAYER_CONSTRAINT, (Object)LayerConstraint.LAST);
                break;
            }
            case FIRST_SEPARATE: {
                node.setProperty(Properties.LAYER_CONSTRAINT, (Object)LayerConstraint.LAST_SEPARATE);
                break;
            }
            case LAST: {
                node.setProperty(Properties.LAYER_CONSTRAINT, (Object)LayerConstraint.FIRST);
                break;
            }
            case LAST_SEPARATE: {
                node.setProperty(Properties.LAYER_CONSTRAINT, (Object)LayerConstraint.FIRST_SEPARATE);
            }
        }
    }

    private void mirrorY(List<LNode> nodes, LGraph graph) {
        double offset = 0.0;
        if (graph.getSize().y == 0.0) {
            for (LNode node : nodes) {
                offset = Math.max(offset, node.getPosition().y + node.getSize().y + node.getMargin().bottom);
            }
        } else {
            offset = graph.getSize().y - graph.getOffset().y;
        }
        offset -= graph.getOffset().y;
        for (LNode node : nodes) {
            this.mirrorY(node.getPosition(), offset - node.getSize().y);
            this.mirrorNodeLabelPlacementY(node);
            switch ((Alignment)node.getProperty(LayoutOptions.ALIGNMENT)) {
                case TOP: {
                    node.setProperty(LayoutOptions.ALIGNMENT, Alignment.BOTTOM);
                    break;
                }
                case BOTTOM: {
                    node.setProperty(LayoutOptions.ALIGNMENT, Alignment.TOP);
                }
            }
            KVector nodeSize = node.getSize();
            for (LPort port : node.getPorts()) {
                this.mirrorY(port.getPosition(), nodeSize.y - port.getSize().y);
                this.mirrorY(port.getAnchor(), port.getSize().y);
                this.mirrorPortSideY(port);
                this.reverseIndex(port);
                for (LEdge edge : port.getOutgoingEdges()) {
                    for (KVector bendPoint : edge.getBendPoints()) {
                        this.mirrorY(bendPoint, offset);
                    }
                    KVectorChain junctionPoints = (KVectorChain)edge.getProperty(LayoutOptions.JUNCTION_POINTS);
                    if (junctionPoints != null) {
                        for (KVector jp : junctionPoints) {
                            this.mirrorY(jp, offset);
                        }
                    }
                    for (LLabel label : edge.getLabels()) {
                        this.mirrorY(label.getPosition(), offset - label.getSize().y);
                    }
                }
                for (LLabel label : port.getLabels()) {
                    this.mirrorY(label.getPosition(), -label.getSize().y);
                }
            }
            if (node.getType() == LNode.NodeType.EXTERNAL_PORT) {
                this.mirrorExternalPortSideY(node);
                this.mirrorInLayerConstraintY(node);
            }
            for (LLabel label : node.getLabels()) {
                this.mirrorY(label.getPosition(), nodeSize.y - label.getSize().y);
            }
        }
    }

    private void mirrorY(KVector v, double offset) {
        v.y = offset - v.y;
    }

    private void mirrorNodeLabelPlacementY(LNode node) {
        Set oldPlacement = (Set)node.getProperty(LayoutOptions.NODE_LABEL_PLACEMENT);
        if (oldPlacement.isEmpty()) {
            return;
        }
        if (oldPlacement.contains(NodeLabelPlacement.V_TOP)) {
            oldPlacement.remove(NodeLabelPlacement.V_TOP);
            oldPlacement.add(NodeLabelPlacement.V_BOTTOM);
        } else if (oldPlacement.contains(NodeLabelPlacement.V_BOTTOM)) {
            oldPlacement.remove(NodeLabelPlacement.V_BOTTOM);
            oldPlacement.add(NodeLabelPlacement.V_TOP);
        }
    }

    private void mirrorPortSideY(LPort port) {
        port.setSide(this.getMirroredPortSideY(port.getSide()));
    }

    private void mirrorExternalPortSideY(LNode node) {
        node.setProperty(InternalProperties.EXT_PORT_SIDE, this.getMirroredPortSideY((PortSide)node.getProperty(InternalProperties.EXT_PORT_SIDE)));
    }

    private PortSide getMirroredPortSideY(PortSide side) {
        switch (side) {
            case NORTH: {
                return PortSide.SOUTH;
            }
            case SOUTH: {
                return PortSide.NORTH;
            }
        }
        return side;
    }

    private void mirrorInLayerConstraintY(LNode node) {
        switch ((InLayerConstraint)((Object)node.getProperty(InternalProperties.IN_LAYER_CONSTRAINT))) {
            case TOP: {
                node.setProperty(InternalProperties.IN_LAYER_CONSTRAINT, (Object)InLayerConstraint.BOTTOM);
                break;
            }
            case BOTTOM: {
                node.setProperty(InternalProperties.IN_LAYER_CONSTRAINT, (Object)InLayerConstraint.TOP);
            }
        }
    }

    private void transpose(List<LNode> nodes) {
        for (LNode node : nodes) {
            this.transpose(node.getPosition());
            this.transpose(node.getSize());
            this.transposeNodeLabelPlacement(node);
            this.transposeProperties(node);
            for (LPort port : node.getPorts()) {
                this.transpose(port.getPosition());
                this.transpose(port.getAnchor());
                this.transpose(port.getSize());
                this.transposePortSide(port);
                this.reverseIndex(port);
                for (LEdge edge : port.getOutgoingEdges()) {
                    for (KVector bendPoint : edge.getBendPoints()) {
                        this.transpose(bendPoint);
                    }
                    KVectorChain junctionPoints = (KVectorChain)edge.getProperty(LayoutOptions.JUNCTION_POINTS);
                    if (junctionPoints != null) {
                        for (KVector jp : junctionPoints) {
                            this.transpose(jp);
                        }
                    }
                    for (LLabel label : edge.getLabels()) {
                        this.transpose(label.getPosition());
                        this.transpose(label.getSize());
                    }
                }
                for (LLabel label : port.getLabels()) {
                    this.transpose(label.getPosition());
                    this.transpose(label.getSize());
                }
            }
            if (node.getType() == LNode.NodeType.EXTERNAL_PORT) {
                this.transposeExternalPortSide(node);
                this.transposeLayerConstraint(node);
            }
            for (LLabel label : node.getLabels()) {
                this.transpose(label.getSize());
                this.transpose(label.getPosition());
            }
        }
    }

    private void transpose(KVector v) {
        double temp = v.x;
        v.x = v.y;
        v.y = temp;
    }

    private void transposeNodeLabelPlacement(LNode node) {
        Set oldPlacement = (Set)node.getProperty(LayoutOptions.NODE_LABEL_PLACEMENT);
        if (oldPlacement.isEmpty()) {
            return;
        }
        EnumSet<NodeLabelPlacement> newPlacement = EnumSet.noneOf(NodeLabelPlacement.class);
        if (oldPlacement.contains(NodeLabelPlacement.INSIDE)) {
            newPlacement.add(NodeLabelPlacement.INSIDE);
        } else {
            newPlacement.add(NodeLabelPlacement.OUTSIDE);
        }
        if (!oldPlacement.contains(NodeLabelPlacement.H_PRIORITY)) {
            newPlacement.add(NodeLabelPlacement.H_PRIORITY);
        }
        if (oldPlacement.contains(NodeLabelPlacement.H_LEFT)) {
            newPlacement.add(NodeLabelPlacement.V_TOP);
        } else if (oldPlacement.contains(NodeLabelPlacement.H_CENTER)) {
            newPlacement.add(NodeLabelPlacement.V_CENTER);
        } else if (oldPlacement.contains(NodeLabelPlacement.H_RIGHT)) {
            newPlacement.add(NodeLabelPlacement.V_BOTTOM);
        }
        if (oldPlacement.contains(NodeLabelPlacement.V_TOP)) {
            newPlacement.add(NodeLabelPlacement.H_LEFT);
        } else if (oldPlacement.contains(NodeLabelPlacement.V_CENTER)) {
            newPlacement.add(NodeLabelPlacement.H_CENTER);
        } else if (oldPlacement.contains(NodeLabelPlacement.V_BOTTOM)) {
            newPlacement.add(NodeLabelPlacement.H_RIGHT);
        }
        node.setProperty(LayoutOptions.NODE_LABEL_PLACEMENT, newPlacement);
    }

    private void transposeEdgeLabelPlacement(LGraph graph) {
        EdgeLabelSideSelection oldSide = (EdgeLabelSideSelection)((Object)graph.getProperty(Properties.EDGE_LABEL_SIDE_SELECTION));
        if (oldSide != null) {
            graph.setProperty(Properties.EDGE_LABEL_SIDE_SELECTION, (Object)oldSide.transpose());
        }
    }

    private void transposePortSide(LPort p) {
        p.setSide(this.transposePortSide(p.getSide()));
    }

    private PortSide transposePortSide(PortSide side) {
        switch (side) {
            case NORTH: {
                return PortSide.WEST;
            }
            case WEST: {
                return PortSide.NORTH;
            }
            case SOUTH: {
                return PortSide.EAST;
            }
            case EAST: {
                return PortSide.SOUTH;
            }
        }
        return PortSide.UNDEFINED;
    }

    private void transposeExternalPortSide(LNode node) {
        node.setProperty(InternalProperties.EXT_PORT_SIDE, this.transposePortSide((PortSide)node.getProperty(InternalProperties.EXT_PORT_SIDE)));
    }

    private void transposeLayerConstraint(LNode node) {
        LayerConstraint layerConstraint = (LayerConstraint)((Object)node.getProperty(Properties.LAYER_CONSTRAINT));
        InLayerConstraint inLayerConstraint = (InLayerConstraint)((Object)node.getProperty(InternalProperties.IN_LAYER_CONSTRAINT));
        if (layerConstraint == LayerConstraint.FIRST_SEPARATE) {
            node.setProperty(Properties.LAYER_CONSTRAINT, (Object)LayerConstraint.NONE);
            node.setProperty(InternalProperties.IN_LAYER_CONSTRAINT, (Object)InLayerConstraint.TOP);
        } else if (layerConstraint == LayerConstraint.LAST_SEPARATE) {
            node.setProperty(Properties.LAYER_CONSTRAINT, (Object)LayerConstraint.NONE);
            node.setProperty(InternalProperties.IN_LAYER_CONSTRAINT, (Object)InLayerConstraint.BOTTOM);
        } else if (inLayerConstraint == InLayerConstraint.TOP) {
            node.setProperty(Properties.LAYER_CONSTRAINT, (Object)LayerConstraint.FIRST_SEPARATE);
            node.setProperty(InternalProperties.IN_LAYER_CONSTRAINT, (Object)InLayerConstraint.NONE);
        } else if (inLayerConstraint == InLayerConstraint.BOTTOM) {
            node.setProperty(Properties.LAYER_CONSTRAINT, (Object)LayerConstraint.LAST_SEPARATE);
            node.setProperty(InternalProperties.IN_LAYER_CONSTRAINT, (Object)InLayerConstraint.NONE);
        }
    }

    private void transposeProperties(LNode node) {
        float minHeight = ((Float)node.getProperty(LayoutOptions.MIN_HEIGHT)).floatValue();
        float minWidth = ((Float)node.getProperty(LayoutOptions.MIN_WIDTH)).floatValue();
        node.setProperty(LayoutOptions.MIN_WIDTH, Float.valueOf(minHeight));
        node.setProperty(LayoutOptions.MIN_HEIGHT, Float.valueOf(minWidth));
        switch ((Alignment)node.getProperty(LayoutOptions.ALIGNMENT)) {
            case LEFT: {
                node.setProperty(LayoutOptions.ALIGNMENT, Alignment.TOP);
                break;
            }
            case RIGHT: {
                node.setProperty(LayoutOptions.ALIGNMENT, Alignment.BOTTOM);
                break;
            }
            case TOP: {
                node.setProperty(LayoutOptions.ALIGNMENT, Alignment.LEFT);
                break;
            }
            case BOTTOM: {
                node.setProperty(LayoutOptions.ALIGNMENT, Alignment.RIGHT);
            }
        }
    }

    private void reverseIndex(LPort port) {
        Integer index = (Integer)port.getProperty(LayoutOptions.PORT_INDEX);
        if (index != null) {
            port.setProperty(LayoutOptions.PORT_INDEX, -index.intValue());
        }
    }

    public static enum Mode {
        MIRROR_X,
        TRANSPOSE,
        MIRROR_AND_TRANSPOSE;

    }
}

