/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.intermediate;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import de.cau.cs.kieler.core.alg.IKielerProgressMonitor;
import de.cau.cs.kieler.core.properties.IPropertyHolder;
import de.cau.cs.kieler.kiml.options.Alignment;
import de.cau.cs.kieler.kiml.options.LayoutOptions;
import de.cau.cs.kieler.kiml.options.PortConstraints;
import de.cau.cs.kieler.kiml.options.PortSide;
import de.cau.cs.kieler.klay.layered.ILayoutProcessor;
import de.cau.cs.kieler.klay.layered.graph.LEdge;
import de.cau.cs.kieler.klay.layered.graph.LGraph;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.graph.LPort;
import de.cau.cs.kieler.klay.layered.graph.Layer;
import de.cau.cs.kieler.klay.layered.properties.InternalProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public final class HierarchicalPortConstraintProcessor
implements ILayoutProcessor {
    private static final int DUMMY_INPUT_PORT = 0;
    private static final int DUMMY_OUTPUT_PORT = 1;

    @Override
    public void process(LGraph layeredGraph, IKielerProgressMonitor monitor) {
        monitor.begin("Hierarchical port constraint processing", 1.0f);
        this.processEasternAndWesternPortDummies(layeredGraph);
        this.processNorthernAndSouthernPortDummies(layeredGraph);
        monitor.done();
    }

    private void processEasternAndWesternPortDummies(LGraph layeredGraph) {
        if (!((PortConstraints)layeredGraph.getProperty(LayoutOptions.PORT_CONSTRAINTS)).isOrderFixed()) {
            return;
        }
        List<Layer> layers = layeredGraph.getLayers();
        this.processEasternAndWesternPortDummies(layers.get(0));
        this.processEasternAndWesternPortDummies(layers.get(layers.size() - 1));
    }

    private void processEasternAndWesternPortDummies(Layer layer) {
        LNode[] nodes = layer.getNodes().toArray(new LNode[layer.getNodes().size()]);
        Arrays.sort(nodes, new NodeComparator());
        LNode lastHierarchicalDummy = null;
        LNode[] lNodeArray = nodes;
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            LNode node = lNodeArray[n2];
            if (node.getType() != LNode.NodeType.EXTERNAL_PORT) break;
            PortSide externalPortSide = (PortSide)node.getProperty(InternalProperties.EXT_PORT_SIDE);
            if (externalPortSide == PortSide.WEST || externalPortSide == PortSide.EAST) {
                if (lastHierarchicalDummy != null) {
                    ((List)lastHierarchicalDummy.getProperty(InternalProperties.IN_LAYER_SUCCESSOR_CONSTRAINTS)).add(node);
                }
                lastHierarchicalDummy = node;
            }
            ++n2;
        }
    }

    private void processNorthernAndSouthernPortDummies(LGraph layeredGraph) {
        PortConstraints portConstraints = (PortConstraints)layeredGraph.getProperty(LayoutOptions.PORT_CONSTRAINTS);
        if (!portConstraints.isSideFixed()) {
            return;
        }
        List<Layer> layers = layeredGraph.getLayers();
        int layerCount = layers.size();
        ArrayList extPortToDummyNodeMap = Lists.newArrayListWithExpectedSize((int)(layerCount + 2));
        ArrayList newDummyNodes = Lists.newArrayListWithExpectedSize((int)(layerCount + 2));
        extPortToDummyNodeMap.add(new HashMap());
        extPortToDummyNodeMap.add(new HashMap());
        newDummyNodes.add(new ArrayList());
        newDummyNodes.add(new ArrayList());
        HashSet originalExternalPortDummies = Sets.newHashSet();
        int currLayerIdx = 0;
        while (currLayerIdx < layerCount) {
            Layer currentLayer = layers.get(currLayerIdx);
            Map prevExtPortToDummyNodesMap = (Map)extPortToDummyNodeMap.get(currLayerIdx);
            HashMap nextExtPortToDummyNodesMap = Maps.newHashMap();
            extPortToDummyNodeMap.add(nextExtPortToDummyNodesMap);
            List prevNewDummyNodes = (List)newDummyNodes.get(currLayerIdx);
            ArrayList nextNewDummyNodes = Lists.newArrayList();
            newDummyNodes.add(nextNewDummyNodes);
            for (LNode currentNode : currentLayer) {
                for (LEdge edge : currentNode.getIncomingEdges()) {
                    LNode sourceNode = edge.getSource().getNode();
                    if (!this.isNorthernSouthernDummy(sourceNode)) continue;
                    originalExternalPortDummies.add(sourceNode);
                    LNode prevLayerDummy = (LNode)((Object)prevExtPortToDummyNodesMap.get(sourceNode.getProperty(InternalProperties.ORIGIN)));
                    if (prevLayerDummy == null) {
                        prevLayerDummy = this.createDummy(layeredGraph, sourceNode);
                        prevExtPortToDummyNodesMap.put(sourceNode.getProperty(InternalProperties.ORIGIN), prevLayerDummy);
                        prevNewDummyNodes.add(prevLayerDummy);
                    }
                    edge.setSource(prevLayerDummy.getPorts().get(1));
                }
                for (LEdge edge : currentNode.getOutgoingEdges()) {
                    LNode targetNode = edge.getTarget().getNode();
                    if (!this.isNorthernSouthernDummy(targetNode)) continue;
                    originalExternalPortDummies.add(targetNode);
                    LNode nextLayerDummy = (LNode)((Object)nextExtPortToDummyNodesMap.get(targetNode.getProperty(InternalProperties.ORIGIN)));
                    if (nextLayerDummy == null) {
                        nextLayerDummy = this.createDummy(layeredGraph, targetNode);
                        nextExtPortToDummyNodesMap.put(targetNode.getProperty(InternalProperties.ORIGIN), nextLayerDummy);
                        nextNewDummyNodes.add(nextLayerDummy);
                    }
                    edge.setTarget(nextLayerDummy.getPorts().get(0));
                }
            }
            ++currLayerIdx;
        }
        int i = 0;
        while (i < newDummyNodes.size()) {
            List nodeList = (List)newDummyNodes.get(i);
            if (!nodeList.isEmpty()) {
                Layer layer = null;
                if (i == 0) {
                    layer = new Layer(layeredGraph);
                    layers.add(0, layer);
                } else if (i == extPortToDummyNodeMap.size() - 1) {
                    layer = new Layer(layeredGraph);
                    layers.add(layer);
                } else {
                    layer = layers.get(i - 1);
                }
                for (LNode dummy : nodeList) {
                    dummy.setLayer(layer);
                }
            }
            ++i;
        }
        for (LNode originalDummy : originalExternalPortDummies) {
            originalDummy.setLayer(null);
        }
    }

    private boolean isNorthernSouthernDummy(LNode node) {
        LNode.NodeType nodeType = node.getType();
        if (nodeType == LNode.NodeType.EXTERNAL_PORT) {
            PortSide portSide = (PortSide)node.getProperty(InternalProperties.EXT_PORT_SIDE);
            return portSide == PortSide.NORTH || portSide == PortSide.SOUTH;
        }
        return false;
    }

    private LNode createDummy(LGraph layeredGraph, LNode originalDummy) {
        LNode newDummy = new LNode(layeredGraph);
        newDummy.copyProperties((IPropertyHolder)originalDummy);
        newDummy.setProperty(InternalProperties.EXT_PORT_REPLACED_DUMMY, (Object)originalDummy);
        newDummy.setProperty(LayoutOptions.PORT_CONSTRAINTS, PortConstraints.FIXED_POS);
        newDummy.setProperty(LayoutOptions.ALIGNMENT, Alignment.CENTER);
        newDummy.setType(LNode.NodeType.EXTERNAL_PORT);
        LPort inputPort = new LPort();
        inputPort.setNode(newDummy);
        inputPort.setSide(PortSide.WEST);
        LPort outputPort = new LPort();
        outputPort.setNode(newDummy);
        outputPort.setSide(PortSide.EAST);
        return newDummy;
    }

    private static class NodeComparator
    implements Comparator<LNode> {
        private NodeComparator() {
        }

        @Override
        public int compare(LNode node1, LNode node2) {
            LNode.NodeType nodeType1 = node1.getType();
            double nodePos1 = (Double)node1.getProperty(InternalProperties.PORT_RATIO_OR_POSITION);
            LNode.NodeType nodeType2 = node2.getType();
            double nodePos2 = (Double)node2.getProperty(InternalProperties.PORT_RATIO_OR_POSITION);
            if (nodeType2 != LNode.NodeType.EXTERNAL_PORT) {
                return -1;
            }
            if (nodeType1 != LNode.NodeType.EXTERNAL_PORT) {
                return 1;
            }
            if (nodePos1 == nodePos2) {
                return 0;
            }
            return nodePos1 < nodePos2 ? -1 : 1;
        }
    }
}

