/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.intermediate;

import com.google.common.collect.Lists;
import de.cau.cs.kieler.core.alg.IKielerProgressMonitor;
import de.cau.cs.kieler.core.properties.IProperty;
import de.cau.cs.kieler.kiml.options.Alignment;
import de.cau.cs.kieler.kiml.options.LayoutOptions;
import de.cau.cs.kieler.kiml.options.PortSide;
import de.cau.cs.kieler.klay.layered.ILayoutProcessor;
import de.cau.cs.kieler.klay.layered.graph.LGraph;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.graph.LPort;
import de.cau.cs.kieler.klay.layered.graph.Layer;
import de.cau.cs.kieler.klay.layered.properties.InternalProperties;
import de.cau.cs.kieler.klay.layered.properties.Properties;
import java.util.ArrayList;
import java.util.List;

public final class HierarchicalPortDummySizeProcessor
implements ILayoutProcessor {
    @Override
    public void process(LGraph layeredGraph, IKielerProgressMonitor monitor) {
        monitor.begin("Hierarchical port dummy size processing", 1.0f);
        ArrayList northernDummies = Lists.newArrayList();
        ArrayList southernDummies = Lists.newArrayList();
        double normalSpacing = ((Float)layeredGraph.getProperty(InternalProperties.SPACING)).doubleValue();
        double smallSpacing = normalSpacing * (double)((Float)layeredGraph.getProperty((IProperty)Properties.EDGE_SPACING_FACTOR)).floatValue();
        double delta = smallSpacing * 2.0;
        for (Layer layer : layeredGraph) {
            northernDummies.clear();
            southernDummies.clear();
            for (LNode node : layer) {
                if (node.getType() != LNode.NodeType.EXTERNAL_PORT) continue;
                PortSide side = (PortSide)node.getProperty(InternalProperties.EXT_PORT_SIDE);
                if (side == PortSide.NORTH) {
                    northernDummies.add(node);
                    continue;
                }
                if (side != PortSide.SOUTH) continue;
                southernDummies.add(node);
            }
            this.setWidths(northernDummies, true, delta);
            this.setWidths(southernDummies, false, delta);
        }
        monitor.done();
    }

    private void setWidths(List<LNode> nodes, boolean topDown, double delta) {
        double currentWidth = 0.0;
        double step = delta;
        if (!topDown) {
            currentWidth = delta * (double)(nodes.size() - 1);
            step *= -1.0;
        }
        for (LNode node : nodes) {
            node.setProperty(LayoutOptions.ALIGNMENT, Alignment.CENTER);
            node.getSize().x = currentWidth;
            for (LPort port : node.getPorts(PortSide.EAST)) {
                port.getPosition().x = currentWidth;
            }
            currentWidth += step;
        }
    }
}

