/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.intermediate;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import de.cau.cs.kieler.core.alg.IKielerProgressMonitor;
import de.cau.cs.kieler.core.math.KVector;
import de.cau.cs.kieler.core.math.KVectorChain;
import de.cau.cs.kieler.core.properties.IProperty;
import de.cau.cs.kieler.kiml.options.LayoutOptions;
import de.cau.cs.kieler.kiml.options.PortConstraints;
import de.cau.cs.kieler.kiml.options.PortSide;
import de.cau.cs.kieler.klay.layered.ILayoutProcessor;
import de.cau.cs.kieler.klay.layered.graph.LEdge;
import de.cau.cs.kieler.klay.layered.graph.LGraph;
import de.cau.cs.kieler.klay.layered.graph.LInsets;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.graph.LPort;
import de.cau.cs.kieler.klay.layered.graph.Layer;
import de.cau.cs.kieler.klay.layered.p5edges.OrthogonalRoutingGenerator;
import de.cau.cs.kieler.klay.layered.properties.InternalProperties;
import de.cau.cs.kieler.klay.layered.properties.Properties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public final class HierarchicalPortOrthogonalEdgeRouter
implements ILayoutProcessor {
    private double northernExtPortEdgeRoutingHeight;

    @Override
    public void process(LGraph layeredGraph, IKielerProgressMonitor monitor) {
        monitor.begin("Orthogonally routing hierarchical port edges", 1.0f);
        this.northernExtPortEdgeRoutingHeight = 0.0;
        Set<LNode> northSouthDummies = this.restoreNorthSouthDummies(layeredGraph);
        this.setNorthSouthDummyCoordinates(layeredGraph, northSouthDummies);
        this.routeEdges(layeredGraph, northSouthDummies);
        this.removeTemporaryNorthSouthDummies(layeredGraph);
        this.fixCoordinates(layeredGraph);
        this.correctSlantedEdgeSegments(layeredGraph);
        monitor.done();
    }

    private Set<LNode> restoreNorthSouthDummies(LGraph layeredGraph) {
        LinkedHashSet restoredDummies = Sets.newLinkedHashSet();
        Layer lastLayer = null;
        for (Layer layer : layeredGraph) {
            for (LNode node : layer) {
                LNode replacedDummy;
                if (node.getType() != LNode.NodeType.EXTERNAL_PORT || (replacedDummy = (LNode)((Object)node.getProperty(InternalProperties.EXT_PORT_REPLACED_DUMMY))) == null) continue;
                assert (replacedDummy.getType() == LNode.NodeType.EXTERNAL_PORT);
                this.restoreDummy(replacedDummy, restoredDummies);
                this.connectNodeToDummy(layeredGraph, node, replacedDummy);
            }
            lastLayer = layer;
        }
        for (LNode dummy : restoredDummies) {
            dummy.setLayer(lastLayer);
        }
        return restoredDummies;
    }

    private void restoreDummy(LNode dummy, Set<LNode> restoredDummies) {
        if (restoredDummies.contains((Object)dummy)) {
            return;
        }
        PortSide portSide = (PortSide)dummy.getProperty(InternalProperties.EXT_PORT_SIDE);
        LPort dummyPort = dummy.getPorts().get(0);
        if (portSide == PortSide.NORTH) {
            dummyPort.setSide(PortSide.SOUTH);
        } else if (portSide == PortSide.SOUTH) {
            dummyPort.setSide(PortSide.NORTH);
        }
        restoredDummies.add(dummy);
    }

    private void connectNodeToDummy(LGraph layeredGraph, LNode node, LNode dummy) {
        LPort outPort = new LPort();
        outPort.setNode(node);
        PortSide extPortSide = (PortSide)node.getProperty(InternalProperties.EXT_PORT_SIDE);
        outPort.setSide(extPortSide);
        LPort inPort = dummy.getPorts().get(0);
        LEdge edge = new LEdge();
        edge.setSource(outPort);
        edge.setTarget(inPort);
    }

    private void setNorthSouthDummyCoordinates(LGraph layeredGraph, Set<LNode> northSouthDummies) {
        PortConstraints constraints = (PortConstraints)layeredGraph.getProperty(LayoutOptions.PORT_CONSTRAINTS);
        KVector graphSize = layeredGraph.getSize();
        LInsets graphInsets = layeredGraph.getInsets();
        float borderSpacing = ((Float)layeredGraph.getProperty(InternalProperties.BORDER_SPACING)).floatValue();
        double graphWidth = graphSize.x + graphInsets.left + graphInsets.right + (double)(2.0f * borderSpacing);
        double northY = 0.0 - graphInsets.top - (double)borderSpacing - layeredGraph.getOffset().y;
        double southY = graphSize.y + graphInsets.top + graphInsets.bottom + (double)(2.0f * borderSpacing) - layeredGraph.getOffset().y;
        ArrayList northernDummies = Lists.newArrayList();
        ArrayList southernDummies = Lists.newArrayList();
        for (LNode dummy : northSouthDummies) {
            switch (constraints) {
                case FREE: 
                case FIXED_SIDE: 
                case FIXED_ORDER: {
                    this.calculateNorthSouthDummyPositions(dummy);
                    break;
                }
                case FIXED_RATIO: {
                    this.applyNorthSouthDummyRatio(dummy, graphWidth);
                    dummy.borderToContentAreaCoordinates(true, false);
                    break;
                }
                case FIXED_POS: {
                    this.applyNorthSouthDummyPosition(dummy);
                    dummy.borderToContentAreaCoordinates(true, false);
                    graphSize.x = Math.max(graphSize.x, dummy.getPosition().x + dummy.getSize().x / 2.0);
                }
            }
            switch ((PortSide)dummy.getProperty(InternalProperties.EXT_PORT_SIDE)) {
                case NORTH: {
                    dummy.getPosition().y = northY;
                    northernDummies.add(dummy);
                    break;
                }
                case SOUTH: {
                    dummy.getPosition().y = southY;
                    southernDummies.add(dummy);
                }
            }
        }
        switch (constraints) {
            case FREE: 
            case FIXED_SIDE: {
                this.ensureUniquePositions(northernDummies, layeredGraph);
                this.ensureUniquePositions(southernDummies, layeredGraph);
                break;
            }
            case FIXED_ORDER: {
                this.restoreProperOrder(northernDummies, layeredGraph);
                this.restoreProperOrder(southernDummies, layeredGraph);
            }
        }
    }

    private void calculateNorthSouthDummyPositions(LNode dummy) {
        LPort dummyInPort = dummy.getPorts().get(0);
        double posSum = 0.0;
        for (LPort connectedPort : dummyInPort.getConnectedPorts()) {
            posSum += connectedPort.getNode().getPosition().x + connectedPort.getPosition().x + connectedPort.getAnchor().x;
        }
        KVector anchor = (KVector)dummy.getProperty(LayoutOptions.PORT_ANCHOR);
        double offset = anchor == null ? 0.0 : anchor.x;
        dummy.getPosition().x = posSum / (double)dummyInPort.getDegree() - offset;
    }

    private void applyNorthSouthDummyRatio(LNode dummy, double width) {
        KVector anchor = (KVector)dummy.getProperty(LayoutOptions.PORT_ANCHOR);
        double offset = anchor == null ? 0.0 : anchor.x;
        dummy.getPosition().x = width * (Double)dummy.getProperty(InternalProperties.PORT_RATIO_OR_POSITION) - offset;
    }

    private void applyNorthSouthDummyPosition(LNode dummy) {
        KVector anchor = (KVector)dummy.getProperty(LayoutOptions.PORT_ANCHOR);
        double offset = anchor == null ? 0.0 : anchor.x;
        dummy.getPosition().x = (Double)dummy.getProperty(InternalProperties.PORT_RATIO_OR_POSITION) - offset;
    }

    private void ensureUniquePositions(List<LNode> dummies, LGraph graph) {
        if (dummies.isEmpty()) {
            return;
        }
        LNode[] dummyArray = dummies.toArray(new LNode[dummies.size()]);
        Arrays.sort(dummyArray, new Comparator<LNode>(){

            @Override
            public int compare(LNode a, LNode b) {
                return Double.compare(a.getPosition().x, b.getPosition().x);
            }
        });
        this.assignAscendingCoordinates(dummyArray, graph);
    }

    private void restoreProperOrder(List<LNode> dummies, LGraph graph) {
        if (dummies.isEmpty()) {
            return;
        }
        LNode[] dummyArray = dummies.toArray(new LNode[dummies.size()]);
        Arrays.sort(dummyArray, new Comparator<LNode>(){

            @Override
            public int compare(LNode a, LNode b) {
                return Double.compare((Double)a.getProperty(InternalProperties.PORT_RATIO_OR_POSITION), (Double)b.getProperty(InternalProperties.PORT_RATIO_OR_POSITION));
            }
        });
        this.assignAscendingCoordinates(dummyArray, graph);
    }

    private void assignAscendingCoordinates(LNode[] dummies, LGraph graph) {
        float edgeSpacing = ((Float)graph.getProperty(InternalProperties.SPACING)).floatValue() * ((Float)graph.getProperty((IProperty)Properties.EDGE_SPACING_FACTOR)).floatValue();
        double lastCoordinate = dummies[0].getPosition().x + dummies[0].getSize().x;
        int index = 1;
        while (index < dummies.length) {
            KVector currentPosition = dummies[index].getPosition();
            KVector currentSize = dummies[index].getSize();
            if (currentPosition.x <= lastCoordinate + (double)edgeSpacing) {
                currentPosition.x = lastCoordinate + (double)edgeSpacing;
            }
            lastCoordinate = currentPosition.x + currentSize.x;
            ++index;
        }
    }

    private void routeEdges(LGraph layeredGraph, Iterable<LNode> northSouthDummies) {
        int slots;
        OrthogonalRoutingGenerator routingGenerator;
        int slots2;
        LinkedHashSet northernSourceLayer = Sets.newLinkedHashSet();
        LinkedHashSet northernTargetLayer = Sets.newLinkedHashSet();
        LinkedHashSet southernSourceLayer = Sets.newLinkedHashSet();
        LinkedHashSet southernTargetLayer = Sets.newLinkedHashSet();
        double nodeSpacing = ((Float)layeredGraph.getProperty(InternalProperties.SPACING)).doubleValue();
        double edgeSpacing = nodeSpacing * (double)((Float)layeredGraph.getProperty((IProperty)Properties.EDGE_SPACING_FACTOR)).floatValue();
        boolean debug = (Boolean)layeredGraph.getProperty(LayoutOptions.DEBUG_MODE);
        for (LNode hierarchicalPortDummy : northSouthDummies) {
            PortSide portSide = (PortSide)hierarchicalPortDummy.getProperty(InternalProperties.EXT_PORT_SIDE);
            if (portSide == PortSide.NORTH) {
                northernTargetLayer.add(hierarchicalPortDummy);
                for (LEdge edge : hierarchicalPortDummy.getIncomingEdges()) {
                    northernSourceLayer.add(edge.getSource().getNode());
                }
                continue;
            }
            if (portSide != PortSide.SOUTH) continue;
            southernTargetLayer.add(hierarchicalPortDummy);
            for (LEdge edge : hierarchicalPortDummy.getIncomingEdges()) {
                southernSourceLayer.add(edge.getSource().getNode());
            }
        }
        if (!northernSourceLayer.isEmpty() && (slots2 = (routingGenerator = new OrthogonalRoutingGenerator(OrthogonalRoutingGenerator.RoutingDirection.SOUTH_TO_NORTH, edgeSpacing, debug ? "extnorth" : null)).routeEdges(layeredGraph, northernSourceLayer, 0, northernTargetLayer, -nodeSpacing - layeredGraph.getOffset().y)) > 0) {
            this.northernExtPortEdgeRoutingHeight = nodeSpacing + (double)(slots2 - 1) * edgeSpacing;
            layeredGraph.getOffset().y += this.northernExtPortEdgeRoutingHeight;
            layeredGraph.getSize().y += this.northernExtPortEdgeRoutingHeight;
        }
        if (!southernSourceLayer.isEmpty() && (slots = (routingGenerator = new OrthogonalRoutingGenerator(OrthogonalRoutingGenerator.RoutingDirection.NORTH_TO_SOUTH, edgeSpacing, debug ? "extsouth" : null)).routeEdges(layeredGraph, southernSourceLayer, 0, southernTargetLayer, layeredGraph.getSize().y + nodeSpacing - layeredGraph.getOffset().y)) > 0) {
            layeredGraph.getSize().y += nodeSpacing + (double)(slots - 1) * edgeSpacing;
        }
    }

    private void removeTemporaryNorthSouthDummies(LGraph layeredGraph) {
        ArrayList nodesToRemove = Lists.newArrayList();
        for (Layer layer : layeredGraph) {
            for (LNode node : layer) {
                LEdge edge;
                int n;
                int n2;
                LEdge[] lEdgeArray;
                if (node.getType() != LNode.NodeType.EXTERNAL_PORT || node.getProperty(InternalProperties.EXT_PORT_REPLACED_DUMMY) == null) continue;
                LPort nodeInPort = null;
                LPort nodeOutPort = null;
                LPort nodeOriginPort = null;
                for (LPort port : node.getPorts()) {
                    switch (port.getSide()) {
                        case WEST: {
                            nodeInPort = port;
                            break;
                        }
                        case EAST: {
                            nodeOutPort = port;
                            break;
                        }
                        default: {
                            nodeOriginPort = port;
                        }
                    }
                }
                if (nodeOriginPort == null) continue;
                LEdge nodeToOriginEdge = nodeOriginPort.getOutgoingEdges().get(0);
                KVectorChain incomingEdgeBendPoints = new KVectorChain((Collection)nodeToOriginEdge.getBendPoints());
                KVector firstBendPoint = new KVector(nodeOriginPort.getPosition());
                firstBendPoint.add(node.getPosition());
                incomingEdgeBendPoints.add(0, (Object)firstBendPoint);
                KVectorChain outgoingEdgeBendPoints = KVectorChain.reverse((KVectorChain)nodeToOriginEdge.getBendPoints());
                KVector lastBendPoint = new KVector(nodeOriginPort.getPosition());
                lastBendPoint.add(node.getPosition());
                outgoingEdgeBendPoints.add((Object)lastBendPoint);
                LNode replacedDummy = (LNode)((Object)node.getProperty(InternalProperties.EXT_PORT_REPLACED_DUMMY));
                LPort replacedDummyPort = replacedDummy.getPorts().get(0);
                LEdge[] edges = null;
                if (nodeInPort != null) {
                    lEdgeArray = edges = nodeInPort.getIncomingEdges().toArray(new LEdge[0]);
                    n2 = edges.length;
                    n = 0;
                    while (n < n2) {
                        edge = lEdgeArray[n];
                        edge.setTarget(replacedDummyPort);
                        edge.getBendPoints().addAllAsCopies(edge.getBendPoints().size(), (Iterable)incomingEdgeBendPoints);
                        ++n;
                    }
                }
                if (nodeOutPort != null) {
                    lEdgeArray = edges = nodeOutPort.getOutgoingEdges().toArray(new LEdge[nodeOutPort.getOutgoingEdges().size()]);
                    n2 = edges.length;
                    n = 0;
                    while (n < n2) {
                        edge = lEdgeArray[n];
                        edge.setSource(replacedDummyPort);
                        edge.getBendPoints().addAllAsCopies(0, (Iterable)outgoingEdgeBendPoints);
                        ++n;
                    }
                }
                nodeToOriginEdge.setSource(null);
                nodeToOriginEdge.setTarget(null);
                nodesToRemove.add(node);
            }
        }
        for (LNode node : nodesToRemove) {
            node.setLayer(null);
        }
    }

    private void fixCoordinates(LGraph layeredGraph) {
        PortConstraints constraints = (PortConstraints)layeredGraph.getProperty(LayoutOptions.PORT_CONSTRAINTS);
        List<Layer> layers = layeredGraph.getLayers();
        this.fixCoordinates(layers.get(0), constraints, layeredGraph);
        this.fixCoordinates(layers.get(layers.size() - 1), constraints, layeredGraph);
    }

    private void fixCoordinates(Layer layer, PortConstraints constraints, LGraph graph) {
        PortSide extPortSide;
        LInsets insets = graph.getInsets();
        float borderSpacing = ((Float)graph.getProperty(InternalProperties.BORDER_SPACING)).floatValue();
        KVector offset = graph.getOffset();
        KVector graphActualSize = graph.getActualSize();
        double newActualGraphHeight = graphActualSize.y;
        for (LNode node : layer) {
            if (node.getType() != LNode.NodeType.EXTERNAL_PORT) continue;
            extPortSide = (PortSide)node.getProperty(InternalProperties.EXT_PORT_SIDE);
            KVector extPortSize = (KVector)node.getProperty(InternalProperties.EXT_PORT_SIZE);
            KVector nodePosition = node.getPosition();
            switch (extPortSide) {
                case EAST: {
                    nodePosition.x = graph.getSize().x + (double)borderSpacing + insets.right - offset.x;
                    break;
                }
                case WEST: {
                    nodePosition.x = -offset.x - (double)borderSpacing - insets.left;
                }
            }
            double requiredActualGraphHeight = 0.0;
            switch (extPortSide) {
                case EAST: 
                case WEST: {
                    if (constraints == PortConstraints.FIXED_RATIO) {
                        double ratio = (Double)node.getProperty(InternalProperties.PORT_RATIO_OR_POSITION);
                        nodePosition.y = graphActualSize.y * ratio - ((KVector)node.getProperty((IProperty)LayoutOptions.PORT_ANCHOR)).y;
                        requiredActualGraphHeight = nodePosition.y + extPortSize.y;
                        node.borderToContentAreaCoordinates(false, true);
                        break;
                    }
                    if (constraints != PortConstraints.FIXED_POS) break;
                    nodePosition.y = (Double)node.getProperty(InternalProperties.PORT_RATIO_OR_POSITION) - ((KVector)node.getProperty((IProperty)LayoutOptions.PORT_ANCHOR)).y;
                    requiredActualGraphHeight = nodePosition.y + extPortSize.y;
                    node.borderToContentAreaCoordinates(false, true);
                }
            }
            newActualGraphHeight = Math.max(newActualGraphHeight, requiredActualGraphHeight);
        }
        graph.getSize().y += newActualGraphHeight - graphActualSize.y;
        for (LNode node : layer) {
            if (node.getType() != LNode.NodeType.EXTERNAL_PORT) continue;
            extPortSide = (PortSide)node.getProperty(InternalProperties.EXT_PORT_SIDE);
            KVector nodePosition = node.getPosition();
            switch (extPortSide) {
                case NORTH: {
                    nodePosition.y = -offset.y - (double)borderSpacing - insets.top;
                    break;
                }
                case SOUTH: {
                    nodePosition.y = graph.getSize().y + (double)borderSpacing + insets.bottom - offset.y;
                }
            }
        }
    }

    private void correctSlantedEdgeSegments(LGraph layeredGraph) {
        List<Layer> layers = layeredGraph.getLayers();
        this.correctSlantedEdgeSegments(layers.get(0));
        this.correctSlantedEdgeSegments(layers.get(layers.size() - 1));
    }

    private void correctSlantedEdgeSegments(Layer layer) {
        for (LNode node : layer) {
            PortSide extPortSide;
            if (node.getType() != LNode.NodeType.EXTERNAL_PORT || (extPortSide = (PortSide)node.getProperty(InternalProperties.EXT_PORT_SIDE)) != PortSide.EAST && extPortSide != PortSide.WEST) continue;
            for (LEdge edge : node.getConnectedEdges()) {
                LPort targetPort;
                KVectorChain bendPoints = edge.getBendPoints();
                if (bendPoints.isEmpty()) continue;
                LPort sourcePort = edge.getSource();
                if (sourcePort.getNode() == node) {
                    KVector firstBendPoint = (KVector)bendPoints.getFirst();
                    firstBendPoint.y = sourcePort.getAbsoluteAnchor().y;
                }
                if ((targetPort = edge.getTarget()).getNode() != node) continue;
                KVector lastBendPoint = (KVector)bendPoints.getLast();
                lastBendPoint.y = targetPort.getAbsoluteAnchor().y;
            }
        }
    }
}

