/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.intermediate;

import de.cau.cs.kieler.core.alg.IKielerProgressMonitor;
import de.cau.cs.kieler.core.math.KVector;
import de.cau.cs.kieler.core.properties.IProperty;
import de.cau.cs.kieler.kiml.options.LayoutOptions;
import de.cau.cs.kieler.kiml.options.PortConstraints;
import de.cau.cs.kieler.kiml.options.PortSide;
import de.cau.cs.kieler.klay.layered.ILayoutProcessor;
import de.cau.cs.kieler.klay.layered.graph.LGraph;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.graph.Layer;
import de.cau.cs.kieler.klay.layered.properties.InternalProperties;
import java.util.List;

public final class HierarchicalPortPositionProcessor
implements ILayoutProcessor {
    @Override
    public void process(LGraph layeredGraph, IKielerProgressMonitor monitor) {
        monitor.begin("Hierarchical port position processing", 1.0f);
        List<Layer> layers = layeredGraph.getLayers();
        if (layers.size() > 0) {
            this.fixCoordinates(layers.get(0), layeredGraph);
        }
        if (layers.size() > 1) {
            this.fixCoordinates(layers.get(layers.size() - 1), layeredGraph);
        }
        monitor.done();
    }

    private void fixCoordinates(Layer layer, LGraph layeredGraph) {
        PortConstraints portConstraints = (PortConstraints)layeredGraph.getProperty(LayoutOptions.PORT_CONSTRAINTS);
        if (!portConstraints.isRatioFixed() && !portConstraints.isPosFixed()) {
            return;
        }
        double graphHeight = layeredGraph.getActualSize().y;
        for (LNode node : layer) {
            PortSide extPortSide;
            if (node.getType() != LNode.NodeType.EXTERNAL_PORT || (extPortSide = (PortSide)node.getProperty(InternalProperties.EXT_PORT_SIDE)) != PortSide.EAST && extPortSide != PortSide.WEST) continue;
            double finalYCoordinate = (Double)node.getProperty(InternalProperties.PORT_RATIO_OR_POSITION);
            if (portConstraints == PortConstraints.FIXED_RATIO) {
                finalYCoordinate *= graphHeight;
            }
            node.getPosition().y = finalYCoordinate - ((KVector)node.getProperty((IProperty)LayoutOptions.PORT_ANCHOR)).y;
            node.borderToContentAreaCoordinates(false, true);
        }
    }
}

