/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.intermediate;

import de.cau.cs.kieler.core.alg.IKielerProgressMonitor;
import de.cau.cs.kieler.kiml.options.PortSide;
import de.cau.cs.kieler.klay.layered.ILayoutProcessor;
import de.cau.cs.kieler.klay.layered.graph.LGraph;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.graph.LPort;
import de.cau.cs.kieler.klay.layered.graph.Layer;
import de.cau.cs.kieler.klay.layered.properties.InternalProperties;
import java.util.List;
import java.util.ListIterator;

public final class HyperedgeDummyMerger
implements ILayoutProcessor {
    @Override
    public void process(LGraph layeredGraph, IKielerProgressMonitor monitor) {
        monitor.begin("Hyperedge merging", 1.0f);
        ListIterator<Layer> layerIter = layeredGraph.getLayers().listIterator();
        while (layerIter.hasNext()) {
            Layer layer = layerIter.next();
            List<LNode> nodes = layer.getNodes();
            if (nodes.isEmpty()) continue;
            LNode currNode = null;
            LNode.NodeType currNodeType = null;
            LNode lastNode = null;
            LNode.NodeType lastNodeType = null;
            int nodeIndex = 0;
            while (nodeIndex < nodes.size()) {
                currNode = nodes.get(nodeIndex);
                currNodeType = currNode.getType();
                if (currNodeType == LNode.NodeType.LONG_EDGE && lastNodeType == LNode.NodeType.LONG_EDGE && lastNode != null) {
                    boolean lastNodePropertiesSet;
                    LPort currNodeSource = (LPort)((Object)currNode.getProperty(InternalProperties.LONG_EDGE_SOURCE));
                    LPort lastNodeSource = (LPort)((Object)lastNode.getProperty(InternalProperties.LONG_EDGE_SOURCE));
                    LPort currNodeTarget = (LPort)((Object)currNode.getProperty(InternalProperties.LONG_EDGE_TARGET));
                    LPort lastNodeTarget = (LPort)((Object)lastNode.getProperty(InternalProperties.LONG_EDGE_TARGET));
                    boolean currNodePropertiesSet = currNodeSource != null || currNodeTarget != null;
                    boolean bl = lastNodePropertiesSet = lastNodeSource != null || lastNodeTarget != null;
                    if (currNodePropertiesSet && lastNodePropertiesSet && (currNodeSource == lastNodeSource || currNodeTarget == lastNodeTarget)) {
                        this.mergeNodes(currNode, lastNode, currNodeSource == lastNodeSource, currNodeTarget == lastNodeTarget);
                        nodes.remove(nodeIndex);
                        --nodeIndex;
                        currNode = lastNode;
                        currNodeType = lastNodeType;
                    }
                }
                lastNode = currNode;
                lastNodeType = currNodeType;
                ++nodeIndex;
            }
        }
        monitor.done();
    }

    private void mergeNodes(LNode mergeSource, LNode mergeTarget, boolean keepSourcePort, boolean keepTargetPort) {
        LPort mergeTargetInputPort = mergeTarget.getPorts(PortSide.WEST).iterator().next();
        LPort mergeTargetOutputPort = mergeTarget.getPorts(PortSide.EAST).iterator().next();
        for (LPort port : mergeSource.getPorts()) {
            while (!port.getIncomingEdges().isEmpty()) {
                port.getIncomingEdges().get(0).setTarget(mergeTargetInputPort);
            }
            while (!port.getOutgoingEdges().isEmpty()) {
                port.getOutgoingEdges().get(0).setSource(mergeTargetOutputPort);
            }
        }
        if (!keepSourcePort) {
            mergeTarget.setProperty(InternalProperties.LONG_EDGE_SOURCE, null);
        }
        if (!keepTargetPort) {
            mergeTarget.setProperty(InternalProperties.LONG_EDGE_TARGET, null);
        }
    }
}

