/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.intermediate;

import com.google.common.collect.Lists;
import de.cau.cs.kieler.core.alg.IKielerProgressMonitor;
import de.cau.cs.kieler.klay.layered.ILayoutProcessor;
import de.cau.cs.kieler.klay.layered.graph.LGraph;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.graph.Layer;
import de.cau.cs.kieler.klay.layered.properties.InLayerConstraint;
import de.cau.cs.kieler.klay.layered.properties.InternalProperties;
import java.util.ArrayList;

public final class InLayerConstraintProcessor
implements ILayoutProcessor {
    @Override
    public void process(LGraph layeredGraph, IKielerProgressMonitor monitor) {
        monitor.begin("Layer constraint edge reversal", 1.0f);
        for (Layer layer : layeredGraph) {
            int topInsertionIndex = -1;
            ArrayList bottomConstrainedNodes = Lists.newArrayList();
            LNode[] nodes = layer.getNodes().toArray(new LNode[layer.getNodes().size()]);
            int i = 0;
            while (i < nodes.length) {
                InLayerConstraint constraint = (InLayerConstraint)((Object)nodes[i].getProperty(InternalProperties.IN_LAYER_CONSTRAINT));
                if (topInsertionIndex == -1) {
                    if (constraint != InLayerConstraint.TOP) {
                        topInsertionIndex = i;
                    }
                } else if (constraint == InLayerConstraint.TOP) {
                    nodes[i].setLayer(null);
                    nodes[i].setLayer(topInsertionIndex++, layer);
                }
                if (constraint == InLayerConstraint.BOTTOM) {
                    bottomConstrainedNodes.add(nodes[i]);
                }
                ++i;
            }
            for (LNode node : bottomConstrainedNodes) {
                node.setLayer(null);
                node.setLayer(layer);
            }
        }
        monitor.done();
    }
}

