/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.intermediate;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import de.cau.cs.kieler.core.alg.IKielerProgressMonitor;
import de.cau.cs.kieler.kiml.options.LayoutOptions;
import de.cau.cs.kieler.kiml.util.nodespacing.Spacing;
import de.cau.cs.kieler.klay.layered.ILayoutProcessor;
import de.cau.cs.kieler.klay.layered.graph.LEdge;
import de.cau.cs.kieler.klay.layered.graph.LGraph;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.graph.LPort;
import de.cau.cs.kieler.klay.layered.properties.GraphProperties;
import de.cau.cs.kieler.klay.layered.properties.InLayerConstraint;
import de.cau.cs.kieler.klay.layered.properties.InternalProperties;
import de.cau.cs.kieler.klay.layered.properties.LayerConstraint;
import de.cau.cs.kieler.klay.layered.properties.Properties;
import java.util.Iterator;
import java.util.Set;

public class InteractiveExternalPortPositioner
implements ILayoutProcessor {
    private static final int ARBITRARY_SPACING = 10;
    private double minX = Double.POSITIVE_INFINITY;
    private double maxX = Double.NEGATIVE_INFINITY;
    private double minY = Double.POSITIVE_INFINITY;
    private double maxY = Double.NEGATIVE_INFINITY;

    @Override
    public void process(LGraph layeredGraph, IKielerProgressMonitor progressMonitor) {
        if (!((Set)layeredGraph.getProperty(InternalProperties.GRAPH_PROPERTIES)).contains((Object)GraphProperties.EXTERNAL_PORTS)) {
            return;
        }
        for (LNode node : layeredGraph.getLayerlessNodes()) {
            if (node.getType() != LNode.NodeType.NORMAL) continue;
            Spacing.Margins margins = (Spacing.Margins)node.getProperty(LayoutOptions.MARGINS);
            this.minX = Math.min(this.minX, node.getPosition().x - margins.left);
            this.maxX = Math.max(this.maxX, node.getPosition().x + node.getSize().x + margins.right);
            this.minY = Math.min(this.minY, node.getPosition().y - margins.top);
            this.maxY = Math.max(this.maxY, node.getPosition().y + node.getSize().y + margins.bottom);
        }
        block4: for (LNode node : layeredGraph.getLayerlessNodes()) {
            if (node.getType() == LNode.NodeType.NORMAL) continue;
            switch (node.getType()) {
                case EXTERNAL_PORT: {
                    LayerConstraint lc = (LayerConstraint)((Object)node.getProperty(Properties.LAYER_CONSTRAINT));
                    if (lc == LayerConstraint.FIRST_SEPARATE) {
                        node.getPosition().x = this.minX - 10.0;
                        this.findYCoordinate(node, (Function<LEdge, LNode>)((Function)e -> e.getTarget().getNode())).transform(d -> {
                            lNode.getPosition().y = d;
                            return lNode.getPosition().y;
                        });
                        break;
                    }
                    if (lc == LayerConstraint.LAST_SEPARATE) {
                        node.getPosition().x = this.maxX + 10.0;
                        this.findYCoordinate(node, (Function<LEdge, LNode>)((Function)e -> e.getSource().getNode())).transform(d -> {
                            lNode.getPosition().y = d;
                            return lNode.getPosition().y;
                        });
                        break;
                    }
                    InLayerConstraint ilc = (InLayerConstraint)((Object)node.getProperty(InternalProperties.IN_LAYER_CONSTRAINT));
                    if (ilc == InLayerConstraint.TOP) {
                        this.findNorthSouthPortXCoordinate(node).transform(x -> {
                            lNode.getPosition().x = x + 10.0;
                            return lNode.getPosition().x;
                        });
                        node.getPosition().y = this.minY - 10.0;
                        break;
                    }
                    if (ilc != InLayerConstraint.BOTTOM) continue block4;
                    this.findNorthSouthPortXCoordinate(node).transform(x -> {
                        lNode.getPosition().x = x + 10.0;
                        return lNode.getPosition().x;
                    });
                    node.getPosition().y = this.maxY + 10.0;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("The node type " + (Object)((Object)node.getType()) + " is not supported by the " + this.getClass());
                }
            }
        }
    }

    private Optional<Double> findYCoordinate(LNode dummy, Function<LEdge, LNode> funGetOtherNode) {
        Iterator<LEdge> iterator = dummy.getConnectedEdges().iterator();
        if (iterator.hasNext()) {
            LEdge e = iterator.next();
            LNode other = (LNode)((Object)funGetOtherNode.apply((Object)e));
            return Optional.of((Object)(other.getPosition().y + other.getSize().y / 2.0));
        }
        return Optional.absent();
    }

    private Optional<Double> findNorthSouthPortXCoordinate(LNode dummy) {
        assert (dummy.getPorts().size() == 1);
        LPort port = dummy.getPorts().get(0);
        if (!port.getOutgoingEdges().isEmpty() && !port.getIncomingEdges().isEmpty()) {
            throw new IllegalStateException("Interactive layout does not support NORTH/SOUTH ports with incoming _and_ outgoing edges.");
        }
        if (!port.getOutgoingEdges().isEmpty()) {
            double min = Double.POSITIVE_INFINITY;
            for (LEdge e : port.getOutgoingEdges()) {
                LNode n = e.getTarget().getNode();
                Spacing.Margins margins = (Spacing.Margins)n.getProperty(LayoutOptions.MARGINS);
                min = Math.min(min, n.getPosition().x - margins.left);
            }
            return Optional.of((Object)min);
        }
        if (!port.getIncomingEdges().isEmpty()) {
            double max = Double.NEGATIVE_INFINITY;
            for (LEdge e : port.getIncomingEdges()) {
                LNode n = e.getSource().getNode();
                Spacing.Margins margins = (Spacing.Margins)n.getProperty(LayoutOptions.MARGINS);
                max = Math.max(max, n.getPosition().x + n.getSize().x + margins.right);
            }
            return Optional.of((Object)max);
        }
        return Optional.absent();
    }
}

