/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.intermediate;

import com.google.common.collect.Lists;
import de.cau.cs.kieler.core.alg.IKielerProgressMonitor;
import de.cau.cs.kieler.core.properties.IPropertyHolder;
import de.cau.cs.kieler.kiml.options.EdgeLabelPlacement;
import de.cau.cs.kieler.kiml.options.LayoutOptions;
import de.cau.cs.kieler.kiml.options.PortConstraints;
import de.cau.cs.kieler.kiml.options.PortSide;
import de.cau.cs.kieler.klay.layered.ILayoutProcessor;
import de.cau.cs.kieler.klay.layered.graph.LEdge;
import de.cau.cs.kieler.klay.layered.graph.LGraph;
import de.cau.cs.kieler.klay.layered.graph.LLabel;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.graph.LPort;
import de.cau.cs.kieler.klay.layered.graph.Layer;
import de.cau.cs.kieler.klay.layered.properties.InternalProperties;
import de.cau.cs.kieler.klay.layered.properties.PortType;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

public final class InvertedPortProcessor
implements ILayoutProcessor {
    @Override
    public void process(LGraph layeredGraph, IKielerProgressMonitor monitor) {
        monitor.begin("Inverted port preprocessing", 1.0f);
        List<Layer> layers = layeredGraph.getLayers();
        ListIterator<Layer> layerIterator = layers.listIterator();
        Layer currentLayer = null;
        ArrayList unassignedNodes = Lists.newArrayList();
        while (layerIterator.hasNext()) {
            Layer previousLayer = currentLayer;
            currentLayer = layerIterator.next();
            for (LNode node : unassignedNodes) {
                node.setLayer(previousLayer);
            }
            unassignedNodes.clear();
            for (LNode node : currentLayer) {
                LEdge edge;
                int n;
                int n2;
                LEdge[] lEdgeArray;
                LEdge[] edgeArray;
                List<LEdge> edges;
                if (node.getType() != LNode.NodeType.NORMAL || !((PortConstraints)node.getProperty(LayoutOptions.PORT_CONSTRAINTS)).isSideFixed()) continue;
                for (LPort port : node.getPorts(PortType.INPUT, PortSide.EAST)) {
                    edges = port.getIncomingEdges();
                    lEdgeArray = edgeArray = edges.toArray(new LEdge[edges.size()]);
                    n2 = edgeArray.length;
                    n = 0;
                    while (n < n2) {
                        edge = lEdgeArray[n];
                        this.createEastPortSideDummies(layeredGraph, port, edge, unassignedNodes);
                        ++n;
                    }
                }
                for (LPort port : node.getPorts(PortType.OUTPUT, PortSide.WEST)) {
                    edges = port.getOutgoingEdges();
                    lEdgeArray = edgeArray = edges.toArray(new LEdge[edges.size()]);
                    n2 = edgeArray.length;
                    n = 0;
                    while (n < n2) {
                        edge = lEdgeArray[n];
                        this.createWestPortSideDummies(layeredGraph, port, edge, unassignedNodes);
                        ++n;
                    }
                }
            }
        }
        for (LNode node : unassignedNodes) {
            node.setLayer(currentLayer);
        }
        monitor.done();
    }

    private void createEastPortSideDummies(LGraph layeredGraph, LPort eastwardPort, LEdge edge, List<LNode> layerNodeList) {
        if (edge.getSource().getNode() == eastwardPort.getNode()) {
            return;
        }
        LNode dummy = new LNode(layeredGraph);
        dummy.setType(LNode.NodeType.LONG_EDGE);
        dummy.setProperty(InternalProperties.ORIGIN, (Object)edge);
        dummy.setProperty(LayoutOptions.PORT_CONSTRAINTS, PortConstraints.FIXED_POS);
        layerNodeList.add(dummy);
        LPort dummyInput = new LPort();
        dummyInput.setNode(dummy);
        dummyInput.setSide(PortSide.WEST);
        LPort dummyOutput = new LPort();
        dummyOutput.setNode(dummy);
        dummyOutput.setSide(PortSide.EAST);
        edge.setTarget(dummyInput);
        LEdge dummyEdge = new LEdge();
        dummyEdge.copyProperties((IPropertyHolder)edge);
        dummyEdge.setProperty(LayoutOptions.JUNCTION_POINTS, null);
        dummyEdge.setSource(dummyOutput);
        dummyEdge.setTarget(eastwardPort);
        this.setLongEdgeSourceAndTarget(dummy, dummyInput, dummyOutput, eastwardPort);
        ListIterator<LLabel> labelIterator = edge.getLabels().listIterator();
        while (labelIterator.hasNext()) {
            LLabel label = labelIterator.next();
            EdgeLabelPlacement labelPlacement = (EdgeLabelPlacement)label.getProperty(LayoutOptions.EDGE_LABEL_PLACEMENT);
            if (labelPlacement != EdgeLabelPlacement.HEAD) continue;
            labelIterator.remove();
            dummyEdge.getLabels().add(label);
        }
    }

    private void createWestPortSideDummies(LGraph layeredGraph, LPort westwardPort, LEdge edge, List<LNode> layerNodeList) {
        if (edge.getTarget().getNode() == westwardPort.getNode()) {
            return;
        }
        LNode dummy = new LNode(layeredGraph);
        dummy.setType(LNode.NodeType.LONG_EDGE);
        dummy.setProperty(InternalProperties.ORIGIN, (Object)edge);
        dummy.setProperty(LayoutOptions.PORT_CONSTRAINTS, PortConstraints.FIXED_POS);
        layerNodeList.add(dummy);
        LPort dummyInput = new LPort();
        dummyInput.setNode(dummy);
        dummyInput.setSide(PortSide.WEST);
        LPort dummyOutput = new LPort();
        dummyOutput.setNode(dummy);
        dummyOutput.setSide(PortSide.EAST);
        LPort originalTarget = edge.getTarget();
        edge.setTarget(dummyInput);
        LEdge dummyEdge = new LEdge();
        dummyEdge.copyProperties((IPropertyHolder)edge);
        dummyEdge.setProperty(LayoutOptions.JUNCTION_POINTS, null);
        dummyEdge.setSource(dummyOutput);
        dummyEdge.setTarget(originalTarget);
        this.setLongEdgeSourceAndTarget(dummy, dummyInput, dummyOutput, westwardPort);
    }

    private void setLongEdgeSourceAndTarget(LNode longEdgeDummy, LPort dummyInputPort, LPort dummyOutputPort, LPort oddPort) {
        LPort sourcePort = dummyInputPort.getIncomingEdges().get(0).getSource();
        LNode sourceNode = sourcePort.getNode();
        LNode.NodeType sourceNodeType = sourceNode.getType();
        LPort targetPort = dummyOutputPort.getOutgoingEdges().get(0).getTarget();
        LNode targetNode = targetPort.getNode();
        LNode.NodeType targetNodeType = targetNode.getType();
        if (sourceNodeType == LNode.NodeType.LONG_EDGE) {
            longEdgeDummy.setProperty(InternalProperties.LONG_EDGE_SOURCE, (Object)((LPort)((Object)sourceNode.getProperty(InternalProperties.LONG_EDGE_SOURCE))));
        } else {
            longEdgeDummy.setProperty(InternalProperties.LONG_EDGE_SOURCE, (Object)sourcePort);
        }
        if (targetNodeType == LNode.NodeType.LONG_EDGE) {
            longEdgeDummy.setProperty(InternalProperties.LONG_EDGE_TARGET, (Object)((LPort)((Object)targetNode.getProperty(InternalProperties.LONG_EDGE_TARGET))));
        } else {
            longEdgeDummy.setProperty(InternalProperties.LONG_EDGE_TARGET, (Object)targetPort);
        }
    }
}

