/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.intermediate;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import de.cau.cs.kieler.core.alg.IKielerProgressMonitor;
import de.cau.cs.kieler.core.math.KVector;
import de.cau.cs.kieler.kiml.options.Direction;
import de.cau.cs.kieler.kiml.options.EdgeLabelPlacement;
import de.cau.cs.kieler.kiml.options.LayoutOptions;
import de.cau.cs.kieler.kiml.options.PortConstraints;
import de.cau.cs.kieler.klay.layered.ILayoutProcessor;
import de.cau.cs.kieler.klay.layered.graph.LEdge;
import de.cau.cs.kieler.klay.layered.graph.LGraph;
import de.cau.cs.kieler.klay.layered.graph.LLabel;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.graph.LPort;
import de.cau.cs.kieler.klay.layered.intermediate.LongEdgeSplitter;
import de.cau.cs.kieler.klay.layered.properties.InternalProperties;
import java.util.ArrayList;
import java.util.ListIterator;

public final class LabelDummyInserter
implements ILayoutProcessor {
    private static final Predicate<LLabel> CENTER_LABEL = new Predicate<LLabel>(){

        public boolean apply(LLabel label) {
            return label.getProperty(LayoutOptions.EDGE_LABEL_PLACEMENT) == EdgeLabelPlacement.CENTER;
        }
    };

    @Override
    public void process(LGraph layeredGraph, IKielerProgressMonitor monitor) {
        monitor.begin("Label dummy insertions", 1.0f);
        ArrayList newDummyNodes = Lists.newArrayList();
        double labelSpacing = ((Float)layeredGraph.getProperty(LayoutOptions.LABEL_SPACING)).doubleValue();
        Direction layoutDirection = (Direction)layeredGraph.getProperty(LayoutOptions.DIRECTION);
        for (LNode node : layeredGraph.getLayerlessNodes()) {
            for (LPort port : node.getPorts()) {
                for (LEdge edge : port.getOutgoingEdges()) {
                    if (edge.getSource().getNode() == edge.getTarget().getNode() || !Iterables.any(edge.getLabels(), CENTER_LABEL)) continue;
                    ArrayList representedLabels = Lists.newArrayListWithCapacity((int)edge.getLabels().size());
                    LNode dummyNode = new LNode(layeredGraph);
                    dummyNode.setType(LNode.NodeType.LABEL);
                    dummyNode.setProperty(InternalProperties.ORIGIN, (Object)edge);
                    dummyNode.setProperty(InternalProperties.REPRESENTED_LABELS, representedLabels);
                    dummyNode.setProperty(LayoutOptions.PORT_CONSTRAINTS, PortConstraints.FIXED_POS);
                    dummyNode.setProperty(InternalProperties.LONG_EDGE_SOURCE, (Object)edge.getSource());
                    dummyNode.setProperty(InternalProperties.LONG_EDGE_TARGET, (Object)edge.getTarget());
                    newDummyNodes.add(dummyNode);
                    LongEdgeSplitter.splitEdge(edge, dummyNode);
                    float thickness = ((Float)edge.getProperty(LayoutOptions.THICKNESS)).floatValue();
                    if (thickness < 0.0f) {
                        thickness = 0.0f;
                        edge.setProperty(LayoutOptions.THICKNESS, Float.valueOf(thickness));
                    }
                    double portPos = Math.floor(thickness / 2.0f);
                    for (LPort dummyPort : dummyNode.getPorts()) {
                        dummyPort.getPosition().y = portPos;
                    }
                    KVector dummySize = dummyNode.getSize();
                    ListIterator<LLabel> iterator = edge.getLabels().listIterator();
                    while (iterator.hasNext()) {
                        LLabel label = iterator.next();
                        if (label.getProperty(LayoutOptions.EDGE_LABEL_PLACEMENT) != EdgeLabelPlacement.CENTER) continue;
                        if (layoutDirection.isVertical()) {
                            dummySize.x += label.getSize().x + labelSpacing;
                            dummySize.y = Math.max(dummySize.y, label.getSize().y);
                        } else {
                            dummySize.x = Math.max(dummySize.x, label.getSize().x);
                            dummySize.y += label.getSize().y + labelSpacing;
                        }
                        representedLabels.add(label);
                        iterator.remove();
                    }
                    if (layoutDirection.isVertical()) {
                        dummySize.x -= labelSpacing;
                        dummySize.y += labelSpacing + (double)thickness;
                        continue;
                    }
                    dummySize.y += labelSpacing + (double)thickness;
                }
            }
        }
        layeredGraph.getLayerlessNodes().addAll(newDummyNodes);
        monitor.done();
    }
}

