/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.intermediate;

import de.cau.cs.kieler.core.alg.IKielerProgressMonitor;
import de.cau.cs.kieler.core.math.KVector;
import de.cau.cs.kieler.kiml.options.Direction;
import de.cau.cs.kieler.kiml.options.LayoutOptions;
import de.cau.cs.kieler.kiml.util.nodespacing.LabelSide;
import de.cau.cs.kieler.klay.layered.ILayoutProcessor;
import de.cau.cs.kieler.klay.layered.graph.LEdge;
import de.cau.cs.kieler.klay.layered.graph.LGraph;
import de.cau.cs.kieler.klay.layered.graph.LLabel;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.graph.Layer;
import de.cau.cs.kieler.klay.layered.intermediate.LongEdgeJoiner;
import de.cau.cs.kieler.klay.layered.properties.InternalProperties;
import java.util.List;
import java.util.ListIterator;

public final class LabelDummyRemover
implements ILayoutProcessor {
    @Override
    public void process(LGraph layeredGraph, IKielerProgressMonitor monitor) {
        monitor.begin("Label dummy removal", 1.0f);
        double labelSpacing = ((Float)layeredGraph.getProperty(LayoutOptions.LABEL_SPACING)).doubleValue();
        Direction layoutDirection = (Direction)layeredGraph.getProperty(LayoutOptions.DIRECTION);
        for (Layer layer : layeredGraph.getLayers()) {
            ListIterator<LNode> nodeIterator = layer.getNodes().listIterator();
            while (nodeIterator.hasNext()) {
                LNode node = nodeIterator.next();
                if (node.getType() != LNode.NodeType.LABEL) continue;
                LEdge originEdge = (LEdge)((Object)node.getProperty(InternalProperties.ORIGIN));
                double thickness = ((Float)originEdge.getProperty(LayoutOptions.THICKNESS)).doubleValue();
                KVector currLabelPos = new KVector(node.getPosition());
                if (node.getProperty(InternalProperties.LABEL_SIDE) == LabelSide.BELOW) {
                    currLabelPos.y += thickness + labelSpacing;
                }
                KVector labelSpace = new KVector(node.getSize().x, node.getSize().y - thickness - labelSpacing);
                List representedLabels = (List)node.getProperty(InternalProperties.REPRESENTED_LABELS);
                if (layoutDirection.isVertical()) {
                    this.placeLabelsForVerticalLayout(representedLabels, currLabelPos, labelSpacing, labelSpace, node.getProperty(InternalProperties.LABEL_SIDE) != LabelSide.ABOVE);
                } else {
                    this.placeLabelsForHorizontalLayout(representedLabels, currLabelPos, labelSpacing, labelSpace);
                }
                originEdge.getLabels().addAll(representedLabels);
                LongEdgeJoiner.joinAt(node, false);
                nodeIterator.remove();
            }
        }
        monitor.done();
    }

    private void placeLabelsForHorizontalLayout(List<LLabel> labels, KVector labelPos, double labelSpacing, KVector labelSpace) {
        for (LLabel label : labels) {
            label.getPosition().x = labelPos.x + (labelSpace.x - label.getSize().x) / 2.0;
            label.getPosition().y = labelPos.y;
            labelPos.y += label.getSize().y + labelSpacing;
        }
    }

    private void placeLabelsForVerticalLayout(List<LLabel> labels, KVector labelPos, double labelSpacing, KVector labelSpace, boolean leftAligned) {
        for (LLabel label : labels) {
            label.getPosition().x = labelPos.x;
            label.getPosition().y = leftAligned ? labelPos.y : labelPos.y + labelSpace.y - label.getSize().y;
            labelPos.x += label.getSize().x + labelSpacing;
        }
    }
}

