/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.intermediate;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import de.cau.cs.kieler.core.alg.IKielerProgressMonitor;
import de.cau.cs.kieler.core.properties.IProperty;
import de.cau.cs.kieler.core.util.Pair;
import de.cau.cs.kieler.klay.layered.ILayoutProcessor;
import de.cau.cs.kieler.klay.layered.graph.LEdge;
import de.cau.cs.kieler.klay.layered.graph.LGraph;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.graph.LPort;
import de.cau.cs.kieler.klay.layered.graph.Layer;
import de.cau.cs.kieler.klay.layered.properties.InternalProperties;
import de.cau.cs.kieler.klay.layered.properties.PortType;
import java.util.ArrayList;

public final class LabelDummySwitcher
implements ILayoutProcessor {
    @Override
    public void process(LGraph layeredGraph, IKielerProgressMonitor monitor) {
        monitor.begin("Label dummy switching", 1.0f);
        ArrayList labelDummies = Lists.newArrayList();
        ArrayList nodesToSwap = Lists.newArrayList();
        ArrayList leftLongEdgeDummies = Lists.newArrayList();
        ArrayList rightLongEdgeDummies = Lists.newArrayList();
        for (Layer layer : layeredGraph) {
            for (LNode node : layer.getNodes()) {
                int pos;
                int rightSize;
                if (node.getType() != LNode.NodeType.LABEL) continue;
                labelDummies.add(node);
                leftLongEdgeDummies.clear();
                rightLongEdgeDummies.clear();
                LNode source = node;
                do {
                    if ((source = source.getIncomingEdges().iterator().next().getSource().getNode()).getType() != LNode.NodeType.LONG_EDGE) continue;
                    leftLongEdgeDummies.add(source);
                } while (source.getType() == LNode.NodeType.LONG_EDGE);
                LNode target = node;
                do {
                    if ((target = target.getOutgoingEdges().iterator().next().getTarget().getNode()).getType() != LNode.NodeType.LONG_EDGE) continue;
                    rightLongEdgeDummies.add(target);
                } while (target.getType() == LNode.NodeType.LONG_EDGE);
                int leftSize = leftLongEdgeDummies.size();
                if (leftSize > (rightSize = rightLongEdgeDummies.size()) + 1) {
                    pos = (leftSize + rightSize) / 2;
                    nodesToSwap.add(new Pair((Object)node, (Object)((LNode)((Object)leftLongEdgeDummies.get(pos)))));
                    continue;
                }
                if (rightSize <= leftSize + 1) continue;
                pos = (rightSize - leftSize) / 2 - 1;
                nodesToSwap.add(new Pair((Object)node, (Object)((LNode)((Object)rightLongEdgeDummies.get(pos)))));
            }
        }
        for (Pair swapPair : nodesToSwap) {
            this.swapNodes((LNode)((Object)swapPair.getFirst()), (LNode)((Object)swapPair.getSecond()));
        }
        for (LNode labelDummy : labelDummies) {
            this.updateLongEdgeSourceTargetInfo(labelDummy);
        }
        monitor.done();
    }

    private void swapNodes(LNode dummy1, LNode dummy2) {
        LEdge edge;
        Layer layer1 = dummy1.getLayer();
        Layer layer2 = dummy2.getLayer();
        LPort inputPort1 = dummy1.getPorts(PortType.INPUT).iterator().next();
        LPort outputPort1 = dummy1.getPorts(PortType.OUTPUT).iterator().next();
        LPort inputPort2 = dummy2.getPorts(PortType.INPUT).iterator().next();
        LPort outputPort2 = dummy2.getPorts(PortType.OUTPUT).iterator().next();
        LEdge[] incomingEdges1 = inputPort1.getIncomingEdges().toArray(new LEdge[1]);
        LEdge[] outgoingEdges1 = outputPort1.getOutgoingEdges().toArray(new LEdge[1]);
        LEdge[] incomingEdges2 = inputPort2.getIncomingEdges().toArray(new LEdge[1]);
        LEdge[] outgoingEdges2 = outputPort2.getOutgoingEdges().toArray(new LEdge[1]);
        dummy1.setLayer(layer2);
        LEdge[] lEdgeArray = incomingEdges2;
        int n = incomingEdges2.length;
        int n2 = 0;
        while (n2 < n) {
            edge = lEdgeArray[n2];
            edge.setTarget(inputPort1);
            ++n2;
        }
        lEdgeArray = outgoingEdges2;
        n = outgoingEdges2.length;
        n2 = 0;
        while (n2 < n) {
            edge = lEdgeArray[n2];
            edge.setSource(outputPort1);
            ++n2;
        }
        dummy2.setLayer(layer1);
        lEdgeArray = incomingEdges1;
        n = incomingEdges1.length;
        n2 = 0;
        while (n2 < n) {
            edge = lEdgeArray[n2];
            edge.setTarget(inputPort2);
            ++n2;
        }
        lEdgeArray = outgoingEdges1;
        n = outgoingEdges1.length;
        n2 = 0;
        while (n2 < n) {
            edge = lEdgeArray[n2];
            edge.setSource(outputPort2);
            ++n2;
        }
    }

    private void updateLongEdgeSourceTargetInfo(LNode labelDummy) {
        this.doUpdateLongEdgeSourceTargetInfo(labelDummy, (Function<LNode, LNode>)((Function)node -> node.getIncomingEdges().iterator().next().getSource().getNode()), InternalProperties.LONG_EDGE_TARGET);
        this.doUpdateLongEdgeSourceTargetInfo(labelDummy, (Function<LNode, LNode>)((Function)node -> node.getOutgoingEdges().iterator().next().getTarget().getNode()), InternalProperties.LONG_EDGE_SOURCE);
    }

    private void doUpdateLongEdgeSourceTargetInfo(LNode labelDummy, Function<LNode, LNode> nextElement, IProperty<LPort> longEdgeProperty) {
        LNode longEdgeDummy = (LNode)((Object)nextElement.apply((Object)labelDummy));
        while (longEdgeDummy.getType() == LNode.NodeType.LONG_EDGE) {
            longEdgeDummy.setProperty(longEdgeProperty, null);
            longEdgeDummy = (LNode)((Object)nextElement.apply((Object)longEdgeDummy));
        }
    }
}

