/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.intermediate;

import de.cau.cs.kieler.core.alg.IKielerProgressMonitor;
import de.cau.cs.kieler.core.math.KVector;
import de.cau.cs.kieler.kiml.labels.ILabelManager;
import de.cau.cs.kieler.kiml.labels.LabelManagementOptions;
import de.cau.cs.kieler.kiml.options.Direction;
import de.cau.cs.kieler.kiml.options.LayoutOptions;
import de.cau.cs.kieler.klay.layered.ILayoutProcessor;
import de.cau.cs.kieler.klay.layered.graph.LEdge;
import de.cau.cs.kieler.klay.layered.graph.LGraph;
import de.cau.cs.kieler.klay.layered.graph.LLabel;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.graph.LPort;
import de.cau.cs.kieler.klay.layered.graph.Layer;
import de.cau.cs.kieler.klay.layered.p5edges.splines.ConnectedSelfLoopComponent;
import de.cau.cs.kieler.klay.layered.properties.InternalProperties;
import java.util.List;
import java.util.Set;

public final class LabelManagementProcessor
implements ILayoutProcessor {
    private static final double MIN_WIDTH_EDGE_LABELS = 60.0;
    private static final double MIN_WIDTH_PORT_LABELS = 20.0;

    @Override
    public void process(LGraph layeredGraph, IKielerProgressMonitor monitor) {
        monitor.begin("Label management", 1.0f);
        ILabelManager labelManager = (ILabelManager)layeredGraph.getProperty(LabelManagementOptions.LABEL_MANAGER);
        if (labelManager != null) {
            double labelSpacing = ((Float)layeredGraph.getProperty(LayoutOptions.LABEL_SPACING)).doubleValue();
            for (Layer layer : layeredGraph) {
                this.manageLabels(layer, labelManager, labelSpacing);
            }
        }
        monitor.done();
    }

    private void manageLabels(Layer layer, ILabelManager labelManager, double labelSpacing) {
        assert (labelManager != null) : "labelManager is null";
        boolean verticalLayout = ((Direction)layer.getGraph().getProperty(LayoutOptions.DIRECTION)).isVertical();
        double maxWidth = Math.max(60.0, this.findMaxNonDummyNodeWidth(layer));
        for (LNode layerNode : layer) {
            switch (layerNode.getType()) {
                case NORMAL: {
                    List<LPort> ports = layerNode.getPorts();
                    for (LPort port : ports) {
                        this.doManageLabels(labelManager, port.getLabels(), 20.0, null, 0.0, verticalLayout);
                    }
                    List components = (List)layerNode.getProperty(InternalProperties.SPLINE_SELFLOOP_COMPONENTS);
                    for (ConnectedSelfLoopComponent component : components) {
                        Set<LEdge> edges = component.getEdges();
                        for (LEdge edge : edges) {
                            this.doManageLabels(labelManager, edge.getLabels(), maxWidth, null, labelSpacing, verticalLayout);
                        }
                    }
                    break;
                }
                case LABEL: {
                    LEdge edge = layerNode.getConnectedEdges().iterator().next();
                    double edgeThickness = ((Float)edge.getProperty(LayoutOptions.THICKNESS)).doubleValue();
                    KVector newDummySize = new KVector(0.0, edgeThickness);
                    Iterable labels = (Iterable)layerNode.getProperty(InternalProperties.REPRESENTED_LABELS);
                    newDummySize = this.doManageLabels(labelManager, labels, maxWidth, newDummySize, labelSpacing, verticalLayout);
                    layerNode.getSize().x = newDummySize.x;
                    layerNode.getSize().y = newDummySize.y;
                }
            }
            for (LEdge edge : layerNode.getOutgoingEdges()) {
                this.doManageLabels(labelManager, edge.getLabels(), 60.0, null, 0.0, verticalLayout);
            }
        }
    }

    private double findMaxNonDummyNodeWidth(Layer layer) {
        if (((Direction)layer.getGraph().getProperty(LayoutOptions.DIRECTION)).isVertical()) {
            return 60.0;
        }
        double maxWidth = 0.0;
        for (LNode node : layer) {
            if (node.getType() != LNode.NodeType.NORMAL) continue;
            maxWidth = Math.max(maxWidth, node.getSize().x);
        }
        return maxWidth;
    }

    private KVector doManageLabels(ILabelManager labelManager, Iterable<LLabel> labels, double targetWidth, KVector newDummySize, double labelSpacing, boolean verticalLayout) {
        for (LLabel label : labels) {
            KVector newSize;
            Object origin = label.getProperty(InternalProperties.ORIGIN);
            if (origin != null && (newSize = labelManager.manageLabelSize(origin, targetWidth)) != null) {
                if (verticalLayout) {
                    label.getSize().x = newSize.y;
                    label.getSize().y = newSize.x;
                } else {
                    label.getSize().x = newSize.x;
                    label.getSize().y = newSize.y;
                }
            }
            if (newDummySize == null) continue;
            newDummySize.x = Math.max(newDummySize.x, label.getSize().x);
            newDummySize.y += label.getSize().y + labelSpacing;
        }
        return newDummySize;
    }
}

