/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.intermediate;

import de.cau.cs.kieler.core.alg.IKielerProgressMonitor;
import de.cau.cs.kieler.core.math.KVector;
import de.cau.cs.kieler.core.math.KVectorChain;
import de.cau.cs.kieler.kiml.options.LayoutOptions;
import de.cau.cs.kieler.kiml.options.PortSide;
import de.cau.cs.kieler.klay.layered.ILayoutProcessor;
import de.cau.cs.kieler.klay.layered.graph.LEdge;
import de.cau.cs.kieler.klay.layered.graph.LGraph;
import de.cau.cs.kieler.klay.layered.graph.LLabel;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.graph.Layer;
import de.cau.cs.kieler.klay.layered.properties.Properties;
import java.util.List;
import java.util.ListIterator;

public final class LongEdgeJoiner
implements ILayoutProcessor {
    @Override
    public void process(LGraph layeredGraph, IKielerProgressMonitor monitor) {
        monitor.begin("Edge joining", 1.0f);
        boolean addUnnecessaryBendpoints = (Boolean)layeredGraph.getProperty(Properties.ADD_UNNECESSARY_BENDPOINTS);
        for (Layer layer : layeredGraph) {
            ListIterator<LNode> nodeIterator = layer.getNodes().listIterator();
            while (nodeIterator.hasNext()) {
                LNode node = nodeIterator.next();
                if (node.getType() != LNode.NodeType.LONG_EDGE) continue;
                LongEdgeJoiner.joinAt(node, addUnnecessaryBendpoints);
                nodeIterator.remove();
            }
        }
        monitor.done();
    }

    public static void joinAt(LNode longEdgeDummy, boolean addUnnecessaryBendpoints) {
        List<LEdge> inputPortEdges = longEdgeDummy.getPorts(PortSide.WEST).iterator().next().getIncomingEdges();
        List<LEdge> outputPortEdges = longEdgeDummy.getPorts(PortSide.EAST).iterator().next().getOutgoingEdges();
        int edgeCount = inputPortEdges.size();
        KVector unnecessaryBendpoint = longEdgeDummy.getPorts().get(0).getAbsoluteAnchor();
        while (edgeCount-- > 0) {
            LEdge survivingEdge = inputPortEdges.get(0);
            LEdge droppedEdge = outputPortEdges.get(0);
            List<LEdge> targetIncomingEdges = droppedEdge.getTarget().getIncomingEdges();
            int droppedEdgeListIndex = targetIncomingEdges.indexOf((Object)droppedEdge);
            survivingEdge.setTargetAndInsertAtIndex(droppedEdge.getTarget(), droppedEdgeListIndex);
            droppedEdge.setSource(null);
            droppedEdge.setTarget(null);
            KVectorChain survivingBendPoints = survivingEdge.getBendPoints();
            if (addUnnecessaryBendpoints) {
                survivingBendPoints.add((Object)new KVector(unnecessaryBendpoint));
            }
            for (KVector bendPoint : droppedEdge.getBendPoints()) {
                survivingBendPoints.add((Object)new KVector(bendPoint));
            }
            List<LLabel> survivingLabels = survivingEdge.getLabels();
            for (LLabel label : droppedEdge.getLabels()) {
                survivingLabels.add(label);
            }
            KVectorChain survivingJunctionPoints = (KVectorChain)survivingEdge.getProperty(LayoutOptions.JUNCTION_POINTS);
            KVectorChain droppedJunctionsPoints = (KVectorChain)droppedEdge.getProperty(LayoutOptions.JUNCTION_POINTS);
            if (droppedJunctionsPoints == null) continue;
            if (survivingJunctionPoints == null) {
                survivingJunctionPoints = new KVectorChain();
                survivingEdge.setProperty(LayoutOptions.JUNCTION_POINTS, survivingJunctionPoints);
            }
            for (KVector jp : droppedJunctionsPoints) {
                survivingJunctionPoints.add((Object)new KVector(jp));
            }
        }
    }
}

