/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.intermediate;

import de.cau.cs.kieler.core.alg.IKielerProgressMonitor;
import de.cau.cs.kieler.core.properties.IPropertyHolder;
import de.cau.cs.kieler.kiml.options.EdgeLabelPlacement;
import de.cau.cs.kieler.kiml.options.LayoutOptions;
import de.cau.cs.kieler.kiml.options.PortConstraints;
import de.cau.cs.kieler.kiml.options.PortSide;
import de.cau.cs.kieler.klay.layered.ILayoutProcessor;
import de.cau.cs.kieler.klay.layered.graph.LEdge;
import de.cau.cs.kieler.klay.layered.graph.LGraph;
import de.cau.cs.kieler.klay.layered.graph.LLabel;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.graph.LPort;
import de.cau.cs.kieler.klay.layered.graph.Layer;
import de.cau.cs.kieler.klay.layered.properties.InternalProperties;
import java.util.ListIterator;

public final class LongEdgeSplitter
implements ILayoutProcessor {
    @Override
    public void process(LGraph layeredGraph, IKielerProgressMonitor monitor) {
        monitor.begin("Edge splitting", 1.0f);
        if (layeredGraph.getLayers().size() <= 2) {
            monitor.done();
            return;
        }
        ListIterator<Layer> layerIter = layeredGraph.getLayers().listIterator();
        Layer nextLayer = layerIter.next();
        while (layerIter.hasNext()) {
            Layer layer = nextLayer;
            nextLayer = layerIter.next();
            for (LNode node : layer) {
                for (LPort port : node.getPorts()) {
                    for (LEdge edge : port.getOutgoingEdges()) {
                        LPort targetPort = edge.getTarget();
                        Layer targetLayer = targetPort.getNode().getLayer();
                        if (targetLayer == layer || targetLayer == nextLayer) continue;
                        assert (layerIter.hasNext());
                        LongEdgeSplitter.splitEdge(edge, this.createDummyNode(layeredGraph, nextLayer, edge));
                    }
                }
            }
        }
        monitor.done();
    }

    private LNode createDummyNode(LGraph layeredGraph, Layer targetLayer, LEdge edgeToSplit) {
        LNode dummyNode = new LNode(layeredGraph);
        dummyNode.setType(LNode.NodeType.LONG_EDGE);
        dummyNode.setProperty(InternalProperties.ORIGIN, (Object)edgeToSplit);
        dummyNode.setProperty(LayoutOptions.PORT_CONSTRAINTS, PortConstraints.FIXED_POS);
        dummyNode.setLayer(targetLayer);
        return dummyNode;
    }

    public static LEdge splitEdge(LEdge edge, LNode dummyNode) {
        LPort oldEdgeTarget = edge.getTarget();
        float thickness = ((Float)edge.getProperty(LayoutOptions.THICKNESS)).floatValue();
        if (thickness < 0.0f) {
            thickness = 0.0f;
            edge.setProperty(LayoutOptions.THICKNESS, Float.valueOf(thickness));
        }
        dummyNode.getSize().y = thickness;
        double portPos = Math.floor(thickness / 2.0f);
        LPort dummyInput = new LPort();
        dummyInput.setSide(PortSide.WEST);
        dummyInput.setNode(dummyNode);
        dummyInput.getPosition().y = portPos;
        LPort dummyOutput = new LPort();
        dummyOutput.setSide(PortSide.EAST);
        dummyOutput.setNode(dummyNode);
        dummyOutput.getPosition().y = portPos;
        edge.setTarget(dummyInput);
        LEdge dummyEdge = new LEdge();
        dummyEdge.copyProperties((IPropertyHolder)edge);
        dummyEdge.setProperty(LayoutOptions.JUNCTION_POINTS, null);
        dummyEdge.setSource(dummyOutput);
        dummyEdge.setTarget(oldEdgeTarget);
        LongEdgeSplitter.setDummyNodeProperties(dummyNode, edge, dummyEdge);
        LongEdgeSplitter.moveHeadLabels(edge, dummyEdge);
        return dummyEdge;
    }

    private static void setDummyNodeProperties(LNode dummyNode, LEdge inEdge, LEdge outEdge) {
        LNode inEdgeSourceNode = inEdge.getSource().getNode();
        if (inEdgeSourceNode.getType() == LNode.NodeType.LONG_EDGE) {
            dummyNode.setProperty(InternalProperties.LONG_EDGE_SOURCE, (Object)((LPort)((Object)inEdgeSourceNode.getProperty(InternalProperties.LONG_EDGE_SOURCE))));
            dummyNode.setProperty(InternalProperties.LONG_EDGE_TARGET, (Object)((LPort)((Object)inEdgeSourceNode.getProperty(InternalProperties.LONG_EDGE_TARGET))));
        } else {
            dummyNode.setProperty(InternalProperties.LONG_EDGE_SOURCE, (Object)inEdge.getSource());
            dummyNode.setProperty(InternalProperties.LONG_EDGE_TARGET, (Object)outEdge.getTarget());
        }
    }

    private static void moveHeadLabels(LEdge oldEdge, LEdge newEdge) {
        ListIterator<LLabel> labelIterator = oldEdge.getLabels().listIterator();
        while (labelIterator.hasNext()) {
            LLabel label = labelIterator.next();
            EdgeLabelPlacement labelPlacement = (EdgeLabelPlacement)label.getProperty(LayoutOptions.EDGE_LABEL_PLACEMENT);
            if (labelPlacement != EdgeLabelPlacement.HEAD) continue;
            labelIterator.remove();
            newEdge.getLabels().add(label);
        }
    }
}

