/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.intermediate;

import de.cau.cs.kieler.core.alg.IKielerProgressMonitor;
import de.cau.cs.kieler.kiml.util.adapters.GraphAdapters;
import de.cau.cs.kieler.kiml.util.nodespacing.KimlNodeDimensionCalculation;
import de.cau.cs.kieler.kiml.util.nodespacing.Spacing;
import de.cau.cs.kieler.klay.layered.ILayoutProcessor;
import de.cau.cs.kieler.klay.layered.graph.LGraph;
import de.cau.cs.kieler.klay.layered.graph.LGraphAdapters;
import de.cau.cs.kieler.klay.layered.graph.LInsets;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.graph.Layer;
import de.cau.cs.kieler.klay.layered.properties.InternalProperties;
import java.util.List;

public final class NodeMarginCalculator
implements ILayoutProcessor {
    @Override
    public void process(LGraph layeredGraph, IKielerProgressMonitor monitor) {
        monitor.begin("Node margin calculation", 1.0f);
        KimlNodeDimensionCalculation.calculateNodeMargins((GraphAdapters.GraphAdapter)LGraphAdapters.adapt(layeredGraph, true));
        double spacing = ((Float)layeredGraph.getProperty(InternalProperties.SPACING)).doubleValue();
        for (Layer layer : layeredGraph) {
            for (LNode node : layer) {
                this.processComments(node, spacing);
                this.processSelfLoops(node);
            }
        }
        monitor.done();
    }

    private void processComments(LNode node, double spacing) {
        double maxCommentWidth;
        LInsets margin = node.getMargin();
        List topBoxes = (List)node.getProperty(InternalProperties.TOP_COMMENTS);
        double topWidth = 0.0;
        if (topBoxes != null) {
            double maxHeight = 0.0;
            for (LNode commentBox : topBoxes) {
                maxHeight = Math.max(maxHeight, commentBox.getSize().y);
                topWidth += commentBox.getSize().x;
            }
            topWidth += spacing / 2.0 * (double)(topBoxes.size() - 1);
            margin.top += maxHeight + spacing;
        }
        List bottomBoxes = (List)node.getProperty(InternalProperties.BOTTOM_COMMENTS);
        double bottomWidth = 0.0;
        if (bottomBoxes != null) {
            double maxHeight = 0.0;
            for (LNode commentBox : bottomBoxes) {
                maxHeight = Math.max(maxHeight, commentBox.getSize().y);
                bottomWidth += commentBox.getSize().x;
            }
            bottomWidth += spacing / 2.0 * (double)(bottomBoxes.size() - 1);
            margin.bottom += maxHeight + spacing;
        }
        if ((maxCommentWidth = Math.max(topWidth, bottomWidth)) > node.getSize().x) {
            double protrusion = (maxCommentWidth - node.getSize().x) / 2.0;
            margin.left = Math.max(margin.left, protrusion);
            margin.right = Math.max(margin.right, protrusion);
        }
    }

    private void processSelfLoops(LNode node) {
        LInsets nodeMargin = node.getMargin();
        Spacing.Margins selfLoopMargin = (Spacing.Margins)node.getProperty(InternalProperties.SPLINE_SELF_LOOP_MARGINS);
        nodeMargin.left = Math.max(nodeMargin.left, selfLoopMargin.left);
        nodeMargin.right = Math.max(nodeMargin.right, selfLoopMargin.right);
        nodeMargin.bottom = Math.max(nodeMargin.bottom, selfLoopMargin.bottom);
        nodeMargin.top = Math.max(nodeMargin.top, selfLoopMargin.top);
    }
}

