/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.intermediate;

import de.cau.cs.kieler.core.alg.IKielerProgressMonitor;
import de.cau.cs.kieler.core.math.KVector;
import de.cau.cs.kieler.core.math.KVectorChain;
import de.cau.cs.kieler.kiml.options.EdgeRouting;
import de.cau.cs.kieler.kiml.options.LayoutOptions;
import de.cau.cs.kieler.kiml.options.PortSide;
import de.cau.cs.kieler.klay.layered.ILayoutProcessor;
import de.cau.cs.kieler.klay.layered.graph.LEdge;
import de.cau.cs.kieler.klay.layered.graph.LGraph;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.graph.LPort;
import de.cau.cs.kieler.klay.layered.graph.Layer;
import de.cau.cs.kieler.klay.layered.properties.InternalProperties;
import java.util.Iterator;

public final class NorthSouthPortPostprocessor
implements ILayoutProcessor {
    @Override
    public void process(LGraph layeredGraph, IKielerProgressMonitor monitor) {
        monitor.begin("Odd port side processing", 1.0f);
        EdgeRouting routing = (EdgeRouting)layeredGraph.getProperty(LayoutOptions.EDGE_ROUTING);
        for (Layer layer : layeredGraph) {
            LNode[] nodeArray;
            LNode[] lNodeArray = nodeArray = layer.getNodes().toArray(new LNode[layer.getNodes().size()]);
            int n = nodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                LNode node = lNodeArray[n2];
                if (node.getType() == LNode.NodeType.NORTH_SOUTH_PORT) {
                    if (routing == EdgeRouting.SPLINES) {
                        for (LPort port : node.getPorts()) {
                            if (!port.getIncomingEdges().isEmpty()) {
                                this.processSplineInputPort(port);
                            }
                            if (port.getOutgoingEdges().isEmpty()) continue;
                            this.processSplineOutputPort(port);
                        }
                    } else if (node.getProperty(InternalProperties.ORIGIN) instanceof LEdge) {
                        this.processSelfLoop(node);
                    } else {
                        boolean sameOriginPort;
                        if (node.getPorts().size() >= 2) {
                            sameOriginPort = true;
                            Iterator<LPort> portIterator = node.getPorts().iterator();
                            LPort currentPort = portIterator.next();
                            LPort previousPort = null;
                            while (portIterator.hasNext()) {
                                previousPort = currentPort;
                                currentPort = portIterator.next();
                                if (previousPort.getProperty(InternalProperties.ORIGIN).equals(currentPort.getProperty(InternalProperties.ORIGIN))) continue;
                                sameOriginPort = false;
                                break;
                            }
                        } else {
                            sameOriginPort = false;
                        }
                        for (LPort port : node.getPorts()) {
                            if (!port.getIncomingEdges().isEmpty()) {
                                this.processInputPort(port, sameOriginPort);
                            }
                            if (port.getOutgoingEdges().isEmpty()) continue;
                            this.processOutputPort(port, sameOriginPort);
                        }
                    }
                    node.setLayer(null);
                }
                ++n2;
            }
        }
        monitor.done();
    }

    private void processInputPort(LPort inputPort, boolean addJunctionPoints) {
        LEdge[] edgeArray;
        LPort originPort = (LPort)((Object)inputPort.getProperty(InternalProperties.ORIGIN));
        double x = originPort.getAbsoluteAnchor().x;
        double y = inputPort.getNode().getPosition().y;
        LEdge[] lEdgeArray = edgeArray = inputPort.getIncomingEdges().toArray(new LEdge[inputPort.getIncomingEdges().size()]);
        int n = edgeArray.length;
        int n2 = 0;
        while (n2 < n) {
            LEdge inEdge = lEdgeArray[n2];
            inEdge.setTarget(originPort);
            inEdge.getBendPoints().addLast(x, y);
            if (addJunctionPoints) {
                KVectorChain junctionPoints = (KVectorChain)inEdge.getProperty(LayoutOptions.JUNCTION_POINTS);
                if (junctionPoints == null) {
                    junctionPoints = new KVectorChain();
                    inEdge.setProperty(LayoutOptions.JUNCTION_POINTS, junctionPoints);
                }
                junctionPoints.add((Object)new KVector(x, y));
            }
            ++n2;
        }
    }

    private void processOutputPort(LPort outputPort, boolean addJunctionPoints) {
        LEdge[] edgeArray;
        LPort originPort = (LPort)((Object)outputPort.getProperty(InternalProperties.ORIGIN));
        double x = originPort.getAbsoluteAnchor().x;
        double y = outputPort.getNode().getPosition().y;
        LEdge[] lEdgeArray = edgeArray = outputPort.getOutgoingEdges().toArray(new LEdge[outputPort.getOutgoingEdges().size()]);
        int n = edgeArray.length;
        int n2 = 0;
        while (n2 < n) {
            LEdge outEdge = lEdgeArray[n2];
            outEdge.setSource(originPort);
            outEdge.getBendPoints().addFirst(x, y);
            if (addJunctionPoints) {
                KVectorChain junctionPoints = (KVectorChain)outEdge.getProperty(LayoutOptions.JUNCTION_POINTS);
                if (junctionPoints == null) {
                    junctionPoints = new KVectorChain();
                    outEdge.setProperty(LayoutOptions.JUNCTION_POINTS, junctionPoints);
                }
                junctionPoints.add((Object)new KVector(x, y));
            }
            ++n2;
        }
    }

    private void processSelfLoop(LNode dummy) {
        LEdge selfLoop = (LEdge)((Object)dummy.getProperty(InternalProperties.ORIGIN));
        LPort inputPort = dummy.getPorts(PortSide.WEST).iterator().next();
        LPort outputPort = dummy.getPorts(PortSide.EAST).iterator().next();
        LPort originInputPort = (LPort)((Object)inputPort.getProperty(InternalProperties.ORIGIN));
        LPort originOutputPort = (LPort)((Object)outputPort.getProperty(InternalProperties.ORIGIN));
        selfLoop.setSource(originOutputPort);
        selfLoop.setTarget(originInputPort);
        KVector bendPoint = new KVector(outputPort.getNode().getPosition());
        bendPoint.x = originOutputPort.getAbsoluteAnchor().x;
        selfLoop.getBendPoints().add((Object)bendPoint);
        bendPoint = new KVector(inputPort.getNode().getPosition());
        bendPoint.x = originInputPort.getAbsoluteAnchor().x;
        selfLoop.getBendPoints().add((Object)bendPoint);
    }

    private void processSplineInputPort(LPort inputPort) {
        LEdge[] edgeArray;
        LPort originPort = (LPort)((Object)inputPort.getProperty(InternalProperties.ORIGIN));
        LEdge[] lEdgeArray = edgeArray = inputPort.getIncomingEdges().toArray(new LEdge[inputPort.getIncomingEdges().size()]);
        int n = edgeArray.length;
        int n2 = 0;
        while (n2 < n) {
            LEdge inEdge = lEdgeArray[n2];
            inEdge.setTarget(originPort);
            ++n2;
        }
    }

    private void processSplineOutputPort(LPort outputPort) {
        LEdge[] edgeArray;
        LPort originPort = (LPort)((Object)outputPort.getProperty(InternalProperties.ORIGIN));
        LEdge[] lEdgeArray = edgeArray = outputPort.getOutgoingEdges().toArray(new LEdge[outputPort.getOutgoingEdges().size()]);
        int n = edgeArray.length;
        int n2 = 0;
        while (n2 < n) {
            LEdge outEdge = lEdgeArray[n2];
            outEdge.setSource(originPort);
            ++n2;
        }
    }
}

