/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.intermediate;

import com.google.common.collect.Lists;
import de.cau.cs.kieler.core.alg.IKielerProgressMonitor;
import de.cau.cs.kieler.kiml.options.LayoutOptions;
import de.cau.cs.kieler.kiml.options.PortSide;
import de.cau.cs.kieler.klay.layered.ILayoutProcessor;
import de.cau.cs.kieler.klay.layered.graph.LEdge;
import de.cau.cs.kieler.klay.layered.graph.LGraph;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.graph.LPort;
import de.cau.cs.kieler.klay.layered.properties.InternalProperties;
import java.util.LinkedList;
import java.util.List;

public class PartitionPreprocessor
implements ILayoutProcessor {
    private static final int PARTITION_CONSTRAINT_EDGE_PRIORITY = 20;
    private List<List<LNode>> partitions;

    @Override
    public void process(LGraph lGraph, IKielerProgressMonitor monitor) {
        monitor.begin("Adding partition constraint edges", 1.0f);
        this.partitions = Lists.newArrayList();
        for (LNode node : lGraph.getLayerlessNodes()) {
            Integer index = (Integer)node.getProperty(LayoutOptions.PARTITION);
            assert (index != null) : "Missing partition property at " + node.toString();
            this.retrievePartition(index).add(node);
        }
        int i = 0;
        while (i < this.partitions.size() - 1) {
            for (LNode node : this.partitions.get(i)) {
                LPort sourcePort = new LPort();
                sourcePort.setNode(node);
                sourcePort.setSide(PortSide.EAST);
                sourcePort.setProperty(InternalProperties.PARTITION_DUMMY, true);
                for (LNode otherNode : this.partitions.get(i + 1)) {
                    LPort targetPort = new LPort();
                    targetPort.setNode(otherNode);
                    targetPort.setSide(PortSide.WEST);
                    targetPort.setProperty(InternalProperties.PARTITION_DUMMY, true);
                    LEdge edge = new LEdge();
                    edge.setProperty(InternalProperties.PARTITION_DUMMY, true);
                    edge.setProperty(LayoutOptions.PRIORITY, 20);
                    edge.setSource(sourcePort);
                    edge.setTarget(targetPort);
                }
            }
            ++i;
        }
        this.partitions = null;
        monitor.done();
    }

    private List<LNode> retrievePartition(int index) {
        while (index >= this.partitions.size()) {
            this.partitions.add(new LinkedList());
        }
        return this.partitions.get(index);
    }
}

