/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.intermediate;

import de.cau.cs.kieler.core.alg.IKielerProgressMonitor;
import de.cau.cs.kieler.kiml.options.PortSide;
import de.cau.cs.kieler.klay.layered.ILayoutProcessor;
import de.cau.cs.kieler.klay.layered.graph.LGraph;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.graph.LPort;
import de.cau.cs.kieler.klay.layered.graph.Layer;
import de.cau.cs.kieler.klay.layered.p3order.AbstractPortDistributor;
import de.cau.cs.kieler.klay.layered.p3order.LayerTotalPortDistributor;
import de.cau.cs.kieler.klay.layered.p3order.NodeRelativePortDistributor;
import de.cau.cs.kieler.klay.layered.properties.InternalProperties;
import java.util.List;
import java.util.Random;

public class PortDistributionProcessor
implements ILayoutProcessor {
    @Override
    public void process(LGraph layeredGraph, IKielerProgressMonitor progressMonitor) {
        progressMonitor.begin("Port distribution", 1.0f);
        LNode[][] graphArray = layeredGraph.toNodeArray();
        int portCount = 0;
        int nodeCount = 0;
        LNode[][] lNodeArray = graphArray;
        int n = graphArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object layer;
            LNode[] lNodeArray2 = layer = lNodeArray[n2];
            int n3 = ((LNode[])layer).length;
            int n4 = 0;
            while (n4 < n3) {
                LNode node = lNodeArray2[n4];
                node.id = nodeCount++;
                for (LPort port : node.getPorts()) {
                    port.id = portCount++;
                }
                ++n4;
            }
            ++n2;
        }
        for (Object layer : layeredGraph) {
            this.switchPortSides((Layer)layer);
        }
        Random random = (Random)layeredGraph.getProperty(InternalProperties.RANDOM);
        AbstractPortDistributor portDistributor = random.nextBoolean() ? new NodeRelativePortDistributor(new float[portCount]) : new LayerTotalPortDistributor(new float[portCount]);
        portDistributor.distributePorts(graphArray);
        progressMonitor.done();
    }

    private void switchPortSides(Layer layer) {
        for (LNode node : layer) {
            if (node.getType() != LNode.NodeType.NORTH_SOUTH_PORT) continue;
            LNode origin = (LNode)((Object)node.getProperty(InternalProperties.IN_LAYER_LAYOUT_UNIT));
            assert (origin.getType() == LNode.NodeType.NORMAL);
            assert (node.getPorts().size() >= 1);
            List<LPort> dummyPorts = node.getPorts();
            LPort dummyPort = dummyPorts.get(0);
            LPort originalPort = (LPort)((Object)dummyPort.getProperty(InternalProperties.ORIGIN));
            if (originalPort.getSide() == PortSide.NORTH && node.id > origin.id) {
                originalPort.setSide(PortSide.SOUTH);
                continue;
            }
            if (originalPort.getSide() != PortSide.SOUTH || origin.id <= node.id) continue;
            originalPort.setSide(PortSide.NORTH);
        }
    }
}

