/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.intermediate;

import de.cau.cs.kieler.core.alg.IKielerProgressMonitor;
import de.cau.cs.kieler.kiml.options.LayoutOptions;
import de.cau.cs.kieler.kiml.options.PortConstraints;
import de.cau.cs.kieler.klay.layered.ILayoutProcessor;
import de.cau.cs.kieler.klay.layered.graph.LGraph;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.graph.LPort;
import de.cau.cs.kieler.klay.layered.graph.Layer;
import java.util.Collections;
import java.util.Comparator;

public final class PortListSorter
implements ILayoutProcessor {
    @Override
    public void process(LGraph layeredGraph, IKielerProgressMonitor monitor) {
        monitor.begin("Port order processing", 1.0f);
        PortComparator portComparator = new PortComparator();
        for (Layer layer : layeredGraph) {
            for (LNode node : layer) {
                if (!((PortConstraints)node.getProperty(LayoutOptions.PORT_CONSTRAINTS)).isOrderFixed()) continue;
                Collections.sort(node.getPorts(), portComparator);
            }
        }
        monitor.done();
    }

    public static class PortComparator
    implements Comparator<LPort> {
        @Override
        public int compare(LPort port1, LPort port2) {
            int ordinalDifference = port1.getSide().ordinal() - port2.getSide().ordinal();
            if (ordinalDifference != 0) {
                return ordinalDifference;
            }
            if (port1.getNode().getProperty(LayoutOptions.PORT_CONSTRAINTS) == PortConstraints.FIXED_ORDER) {
                int indexDifference;
                Integer index1 = (Integer)port1.getProperty(LayoutOptions.PORT_INDEX);
                Integer index2 = (Integer)port2.getProperty(LayoutOptions.PORT_INDEX);
                if (index1 != null && index2 != null && (indexDifference = index1 - index2) != 0) {
                    return indexDifference;
                }
            }
            switch (port1.getSide()) {
                case NORTH: {
                    return Double.compare(port1.getPosition().x, port2.getPosition().x);
                }
                case EAST: {
                    return Double.compare(port1.getPosition().y, port2.getPosition().y);
                }
                case SOUTH: {
                    return Double.compare(port2.getPosition().x, port1.getPosition().x);
                }
                case WEST: {
                    return Double.compare(port2.getPosition().y, port1.getPosition().y);
                }
            }
            throw new IllegalStateException("Port side is undefined");
        }
    }
}

