/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.intermediate;

import de.cau.cs.kieler.core.alg.IKielerProgressMonitor;
import de.cau.cs.kieler.klay.layered.ILayoutProcessor;
import de.cau.cs.kieler.klay.layered.graph.LEdge;
import de.cau.cs.kieler.klay.layered.graph.LGraph;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.graph.LPort;
import de.cau.cs.kieler.klay.layered.graph.Layer;
import de.cau.cs.kieler.klay.layered.properties.InternalProperties;

public final class ReversedEdgeRestorer
implements ILayoutProcessor {
    @Override
    public void process(LGraph layeredGraph, IKielerProgressMonitor monitor) {
        monitor.begin("Restoring reversed edges", 1.0f);
        for (Layer layer : layeredGraph) {
            for (LNode node : layer) {
                for (LPort port : node.getPorts()) {
                    LEdge[] edgeArray;
                    LEdge[] lEdgeArray = edgeArray = port.getOutgoingEdges().toArray(new LEdge[port.getOutgoingEdges().size()]);
                    int n = edgeArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        LEdge edge = lEdgeArray[n2];
                        if (((Boolean)edge.getProperty(InternalProperties.REVERSED)).booleanValue()) {
                            edge.reverse(layeredGraph, false);
                        }
                        ++n2;
                    }
                }
            }
        }
        monitor.done();
    }
}

