/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.intermediate;

import com.google.common.collect.Lists;
import de.cau.cs.kieler.core.alg.IKielerProgressMonitor;
import de.cau.cs.kieler.core.properties.IPropertyHolder;
import de.cau.cs.kieler.kiml.options.Direction;
import de.cau.cs.kieler.kiml.options.LayoutOptions;
import de.cau.cs.kieler.kiml.options.PortConstraints;
import de.cau.cs.kieler.kiml.options.PortSide;
import de.cau.cs.kieler.klay.layered.ILayoutProcessor;
import de.cau.cs.kieler.klay.layered.graph.LEdge;
import de.cau.cs.kieler.klay.layered.graph.LGraph;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.graph.LPort;
import de.cau.cs.kieler.klay.layered.graph.Layer;
import de.cau.cs.kieler.klay.layered.properties.InternalProperties;
import de.cau.cs.kieler.klay.layered.properties.Properties;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

public class SausageFolding
implements ILayoutProcessor {
    private double spacing = 0.0;
    private double inLayerSpacing = 0.0;

    @Override
    public void process(LGraph graph, IKielerProgressMonitor progressMonitor) {
        int nodesPerRow;
        int index;
        progressMonitor.begin("Sausage Folding", 1.0f);
        this.spacing = ((Float)graph.getProperty(InternalProperties.SPACING)).doubleValue();
        this.inLayerSpacing = this.spacing * (double)((Float)graph.getProperty(Properties.OBJ_SPACING_IN_LAYER_FACTOR)).floatValue();
        double maxHeight = this.determineMaximalHeight(graph);
        int longestPath = graph.getLayers().size();
        double maxWidth = this.determineMaximalWidth(graph);
        double sumWidth = (double)longestPath * maxWidth;
        Direction dir = (Direction)graph.getProperty(LayoutOptions.DIRECTION);
        double desiredAR = dir == Direction.LEFT || dir == Direction.RIGHT || dir == Direction.UNDEFINED ? ((Float)graph.getProperty(InternalProperties.ASPECT_RATIO)).doubleValue() : (double)(1.0f / ((Float)graph.getProperty(InternalProperties.ASPECT_RATIO)).floatValue());
        double currentAR = sumWidth / maxHeight;
        if (desiredAR > currentAR) {
            progressMonitor.done();
            return;
        }
        int rows = 0;
        double dist = Double.MAX_VALUE;
        double lastDist = Double.MAX_VALUE;
        do {
            currentAR = sumWidth / (double)(++rows) / (maxHeight * (double)rows);
            lastDist = dist;
            dist = Math.abs(currentAR - desiredAR);
        } while (currentAR > desiredAR);
        if (lastDist < dist) {
            --rows;
        }
        int newIndex = index = (nodesPerRow = longestPath / Math.max(1, rows));
        boolean wannaRevert = true;
        while (index < longestPath) {
            Layer l = graph.getLayers().get(index);
            boolean reversalAllowed = true;
            LNode n1 = null;
            LNode n2 = null;
            block2: for (LNode tgt : l.getNodes()) {
                for (LEdge e : tgt.getIncomingEdges()) {
                    if (n1 != null && n1 != tgt) {
                        reversalAllowed = false;
                        break block2;
                    }
                    n1 = tgt;
                    LNode src = e.getSource().getNode();
                    if (n2 != null && n2 != src) {
                        reversalAllowed = false;
                        break block2;
                    }
                    n2 = src;
                }
            }
            if (wannaRevert && reversalAllowed) {
                newIndex = 0;
                wannaRevert = false;
            }
            if (index != newIndex) {
                Layer newLayer = graph.getLayers().get(newIndex);
                for (LNode n : Lists.newArrayList(l.getNodes())) {
                    n.setLayer(newLayer.getNodes().size(), newLayer);
                    if (newIndex != 0) continue;
                    for (LEdge e : Lists.newArrayList(n.getIncomingEdges())) {
                        e.reverse(graph, true);
                        graph.setProperty(InternalProperties.CYCLIC, true);
                        this.insertDummies(graph, e);
                        ArrayList foo = Lists.newArrayList();
                        this.createWestPortSideDummies(graph, e.getSource(), e, foo);
                        for (LNode no : foo) {
                            no.setLayer(newLayer.getNodes().size() - 1, newLayer);
                        }
                    }
                }
            }
            if (newIndex >= nodesPerRow) {
                wannaRevert = true;
            }
            ++newIndex;
            ++index;
        }
        ListIterator<Layer> it = graph.getLayers().listIterator();
        while (it.hasNext()) {
            Layer l = it.next();
            if (!l.getNodes().isEmpty()) continue;
            it.remove();
        }
        progressMonitor.done();
    }

    private double determineMaximalHeight(LGraph graph) {
        double maxH = 0.0;
        for (Layer l : graph.getLayers()) {
            double lH = 0.0;
            for (LNode n : l.getNodes()) {
                lH += n.getSize().y + n.getMargin().bottom + n.getMargin().top + this.inLayerSpacing;
            }
            maxH = Math.max(maxH, lH -= this.inLayerSpacing);
        }
        return maxH;
    }

    private double determineMaximalWidth(LGraph graph) {
        double maxW = 0.0;
        for (Layer l : graph.getLayers()) {
            for (LNode n : l.getNodes()) {
                double nW = n.getSize().x + n.getMargin().right + n.getMargin().left + this.spacing;
                maxW = Math.max(maxW, nW);
            }
        }
        return maxW;
    }

    private void insertDummies(LGraph layeredGraph, LEdge originalEdge) {
        LEdge edge = originalEdge;
        LPort targetPort = edge.getTarget();
        LNode src = edge.getSource().getNode();
        LNode tgt = edge.getTarget().getNode();
        int srcIndex = src.getLayer().getIndex();
        int tgtIndex = tgt.getLayer().getIndex();
        int i = srcIndex;
        while (i < tgtIndex) {
            LNode dummyNode = new LNode(layeredGraph);
            dummyNode.setType(LNode.NodeType.LONG_EDGE);
            dummyNode.setProperty(InternalProperties.ORIGIN, (Object)edge);
            dummyNode.setProperty(LayoutOptions.PORT_CONSTRAINTS, PortConstraints.FIXED_POS);
            Layer nextLayer = layeredGraph.getLayers().get(i + 1);
            dummyNode.setLayer(nextLayer);
            float thickness = ((Float)edge.getProperty(LayoutOptions.THICKNESS)).floatValue();
            if (thickness < 0.0f) {
                thickness = 0.0f;
                edge.setProperty(LayoutOptions.THICKNESS, Float.valueOf(thickness));
            }
            dummyNode.getSize().y = thickness;
            double portPos = Math.floor(thickness / 2.0f);
            LPort dummyInput = new LPort();
            dummyInput.setSide(PortSide.WEST);
            dummyInput.setNode(dummyNode);
            dummyInput.getPosition().y = portPos;
            LPort dummyOutput = new LPort();
            dummyOutput.setSide(PortSide.EAST);
            dummyOutput.setNode(dummyNode);
            dummyOutput.getPosition().y = portPos;
            edge.setTarget(dummyInput);
            LEdge dummyEdge = new LEdge();
            dummyEdge.copyProperties((IPropertyHolder)edge);
            dummyEdge.setProperty(LayoutOptions.JUNCTION_POINTS, null);
            dummyEdge.setSource(dummyOutput);
            dummyEdge.setTarget(targetPort);
            this.setDummyProperties(dummyNode, edge, dummyEdge);
            edge = dummyEdge;
            ++i;
        }
    }

    private void setDummyProperties(LNode dummy, LEdge inEdge, LEdge outEdge) {
        LNode inEdgeSourceNode = inEdge.getSource().getNode();
        if (inEdgeSourceNode.getType() == LNode.NodeType.LONG_EDGE) {
            dummy.setProperty(InternalProperties.LONG_EDGE_SOURCE, (Object)((LPort)((Object)inEdgeSourceNode.getProperty(InternalProperties.LONG_EDGE_SOURCE))));
            dummy.setProperty(InternalProperties.LONG_EDGE_TARGET, (Object)((LPort)((Object)inEdgeSourceNode.getProperty(InternalProperties.LONG_EDGE_TARGET))));
        } else {
            dummy.setProperty(InternalProperties.LONG_EDGE_SOURCE, (Object)inEdge.getSource());
            dummy.setProperty(InternalProperties.LONG_EDGE_TARGET, (Object)outEdge.getTarget());
        }
    }

    private void createWestPortSideDummies(LGraph layeredGraph, LPort westwardPort, LEdge edge, List<LNode> layerNodeList) {
        if (edge.getTarget().getNode() == westwardPort.getNode()) {
            return;
        }
        LNode dummy = new LNode(layeredGraph);
        dummy.setType(LNode.NodeType.LONG_EDGE);
        dummy.setProperty(InternalProperties.ORIGIN, (Object)edge);
        dummy.setProperty(LayoutOptions.PORT_CONSTRAINTS, PortConstraints.FIXED_POS);
        layerNodeList.add(dummy);
        LPort dummyInput = new LPort();
        dummyInput.setNode(dummy);
        dummyInput.setSide(PortSide.WEST);
        LPort dummyOutput = new LPort();
        dummyOutput.setNode(dummy);
        dummyOutput.setSide(PortSide.EAST);
        LPort originalTarget = edge.getTarget();
        edge.setTarget(dummyInput);
        LEdge dummyEdge = new LEdge();
        dummyEdge.copyProperties((IPropertyHolder)edge);
        dummyEdge.setProperty(LayoutOptions.JUNCTION_POINTS, null);
        dummyEdge.setSource(dummyOutput);
        dummyEdge.setTarget(originalTarget);
        this.setLongEdgeSourceAndTarget(dummy, dummyInput, dummyOutput, westwardPort);
    }

    private void setLongEdgeSourceAndTarget(LNode longEdgeDummy, LPort dummyInputPort, LPort dummyOutputPort, LPort oddPort) {
        LPort sourcePort = dummyInputPort.getIncomingEdges().get(0).getSource();
        LNode sourceNode = sourcePort.getNode();
        LNode.NodeType sourceNodeType = sourceNode.getType();
        LPort targetPort = dummyOutputPort.getOutgoingEdges().get(0).getTarget();
        LNode targetNode = targetPort.getNode();
        LNode.NodeType targetNodeType = targetNode.getType();
        if (sourceNodeType == LNode.NodeType.LONG_EDGE) {
            longEdgeDummy.setProperty(InternalProperties.LONG_EDGE_SOURCE, (Object)((LPort)((Object)sourceNode.getProperty(InternalProperties.LONG_EDGE_SOURCE))));
        } else {
            longEdgeDummy.setProperty(InternalProperties.LONG_EDGE_SOURCE, (Object)sourcePort);
        }
        if (targetNodeType == LNode.NodeType.LONG_EDGE) {
            longEdgeDummy.setProperty(InternalProperties.LONG_EDGE_TARGET, (Object)((LPort)((Object)targetNode.getProperty(InternalProperties.LONG_EDGE_TARGET))));
        } else {
            longEdgeDummy.setProperty(InternalProperties.LONG_EDGE_TARGET, (Object)targetPort);
        }
    }
}

