/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.intermediate;

import com.google.common.collect.Lists;
import de.cau.cs.kieler.core.alg.IKielerProgressMonitor;
import de.cau.cs.kieler.core.properties.IPropertyHolder;
import de.cau.cs.kieler.kiml.options.LayoutOptions;
import de.cau.cs.kieler.kiml.options.PortConstraints;
import de.cau.cs.kieler.kiml.options.PortSide;
import de.cau.cs.kieler.klay.layered.ILayoutProcessor;
import de.cau.cs.kieler.klay.layered.graph.LEdge;
import de.cau.cs.kieler.klay.layered.graph.LGraph;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.graph.LPort;
import de.cau.cs.kieler.klay.layered.graph.Layer;
import de.cau.cs.kieler.klay.layered.properties.InternalProperties;
import java.util.ArrayList;

public final class SelfLoopProcessor
implements ILayoutProcessor {
    @Override
    public void process(LGraph layeredGraph, IKielerProgressMonitor monitor) {
        monitor.begin("Self-loop processing", 1.0f);
        ArrayList createdDummies = Lists.newArrayList();
        for (Layer layer : layeredGraph) {
            createdDummies.clear();
            for (LNode node : layer) {
                for (LPort port : node.getPorts()) {
                    LEdge[] edges;
                    LEdge[] lEdgeArray = edges = port.getOutgoingEdges().toArray(new LEdge[port.getOutgoingEdges().size()]);
                    int n = edges.length;
                    int n2 = 0;
                    while (n2 < n) {
                        LEdge edge = lEdgeArray[n2];
                        if (edge.getSource().getNode() == edge.getTarget().getNode()) {
                            LPort sourcePort = edge.getSource();
                            LPort targetPort = edge.getTarget();
                            PortSide sourcePortSide = sourcePort.getSide();
                            PortSide targetPortSide = targetPort.getSide();
                            if ((sourcePortSide == PortSide.NORTH || sourcePortSide == PortSide.SOUTH) && targetPortSide == PortSide.WEST) {
                                edge.reverse(layeredGraph, false);
                            } else if (sourcePortSide == PortSide.SOUTH && targetPortSide == PortSide.NORTH) {
                                edge.reverse(layeredGraph, false);
                            } else if (sourcePortSide == PortSide.EAST && targetPortSide != PortSide.EAST) {
                                edge.reverse(layeredGraph, false);
                            }
                            if (sourcePortSide == PortSide.EAST && targetPortSide == PortSide.WEST) {
                                createdDummies.add(this.createDummy(layeredGraph, edge, targetPort, sourcePort));
                            } else if (sourcePortSide == PortSide.WEST && targetPortSide == PortSide.EAST) {
                                createdDummies.add(this.createDummy(layeredGraph, edge, sourcePort, targetPort));
                            }
                        }
                        ++n2;
                    }
                }
            }
            for (LNode dummy : createdDummies) {
                dummy.setLayer(layer);
            }
        }
        monitor.done();
    }

    private LNode createDummy(LGraph layeredGraph, LEdge edge, LPort sourcePort, LPort targetPort) {
        LNode dummyNode = new LNode(layeredGraph);
        dummyNode.setType(LNode.NodeType.LONG_EDGE);
        dummyNode.setProperty(InternalProperties.ORIGIN, (Object)edge);
        dummyNode.setProperty(LayoutOptions.PORT_CONSTRAINTS, PortConstraints.FIXED_POS);
        dummyNode.setProperty(InternalProperties.LONG_EDGE_SOURCE, (Object)sourcePort);
        dummyNode.setProperty(InternalProperties.LONG_EDGE_TARGET, (Object)targetPort);
        LPort dummyInput = new LPort();
        dummyInput.setSide(PortSide.WEST);
        dummyInput.setNode(dummyNode);
        LPort dummyOutput = new LPort();
        dummyOutput.setSide(PortSide.EAST);
        dummyOutput.setNode(dummyNode);
        edge.setTarget(dummyInput);
        LEdge dummyEdge = new LEdge();
        dummyEdge.copyProperties((IPropertyHolder)edge);
        dummyEdge.setProperty(LayoutOptions.JUNCTION_POINTS, null);
        dummyEdge.setSource(dummyOutput);
        dummyEdge.setTarget(targetPort);
        return dummyNode;
    }
}

