/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.intermediate;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import de.cau.cs.kieler.core.alg.IKielerProgressMonitor;
import de.cau.cs.kieler.kiml.options.LayoutOptions;
import de.cau.cs.kieler.kiml.options.PortConstraints;
import de.cau.cs.kieler.kiml.options.PortSide;
import de.cau.cs.kieler.klay.layered.ILayoutProcessor;
import de.cau.cs.kieler.klay.layered.graph.LEdge;
import de.cau.cs.kieler.klay.layered.graph.LGraph;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.graph.LPort;
import de.cau.cs.kieler.klay.layered.p5edges.splines.ConnectedSelfLoopComponent;
import de.cau.cs.kieler.klay.layered.properties.InternalProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;

public final class SplineSelfLoopPreProcessor
implements ILayoutProcessor {
    @Override
    public void process(LGraph layeredGraph, IKielerProgressMonitor monitor) {
        monitor.begin("Spline SelfLoop pre-processing.", 1.0f);
        LinkedHashSet loopEdges = Sets.newLinkedHashSet();
        for (LNode node : layeredGraph.getLayerlessNodes()) {
            this.correctPortSideConstraint(node);
            loopEdges.clear();
            for (LEdge edge : node.getOutgoingEdges()) {
                if (!edge.isSelfLoop()) continue;
                loopEdges.add(edge);
            }
            for (LEdge edge : loopEdges) {
                PortSide sourcePortSide = edge.getSource().getSide();
                PortSide targetPortSide = edge.getTarget().getSide();
                if (!(sourcePortSide == PortSide.NORTH && (targetPortSide == PortSide.EAST || targetPortSide == PortSide.SOUTH) || sourcePortSide == PortSide.EAST && targetPortSide == PortSide.SOUTH || sourcePortSide == PortSide.SOUTH && targetPortSide == PortSide.WEST) && (sourcePortSide != PortSide.WEST || targetPortSide != PortSide.NORTH && targetPortSide != PortSide.EAST)) continue;
                edge.reverse(layeredGraph, false);
            }
            List<ConnectedSelfLoopComponent> allComponents = SplineSelfLoopPreProcessor.findAllConnectedComponents(loopEdges, node);
            node.setProperty(InternalProperties.SPLINE_SELFLOOP_COMPONENTS, allComponents);
            if (((PortConstraints)node.getProperty(LayoutOptions.PORT_CONSTRAINTS)).isOrderFixed()) continue;
            HashSet portsToHide = Sets.newHashSet();
            for (ConnectedSelfLoopComponent component : allComponents) {
                portsToHide.addAll(component.getHidablePorts());
                portsToHide.addAll(component.getPortsWithPortSide());
            }
            ListIterator<LPort> itr = node.getPorts().listIterator();
            while (itr.hasNext()) {
                LPort port = (LPort)((Object)itr.next());
                if (!portsToHide.contains((Object)port)) continue;
                itr.remove();
            }
        }
        monitor.done();
    }

    private void correctPortSideConstraint(LNode node) {
        if (!((PortConstraints)node.getProperty(LayoutOptions.PORT_CONSTRAINTS)).isSideFixed()) {
            for (LPort port : node.getPorts()) {
                port.setSide(PortSide.UNDEFINED);
            }
        }
    }

    private static List<ConnectedSelfLoopComponent> findAllConnectedComponents(Set<LEdge> loopEdges, LNode node) {
        ArrayList components = Lists.newArrayList();
        LinkedListMultimap portToEdge = LinkedListMultimap.create();
        for (LEdge edge : loopEdges) {
            portToEdge.put((Object)edge.getSource(), (Object)edge);
            portToEdge.put((Object)edge.getTarget(), (Object)edge);
        }
        while (!portToEdge.isEmpty()) {
            components.add(SplineSelfLoopPreProcessor.findAConnectedComponent((Multimap<LPort, LEdge>)portToEdge, node, ((PortConstraints)node.getProperty(LayoutOptions.PORT_CONSTRAINTS)).isOrderFixed()));
        }
        return components;
    }

    private static ConnectedSelfLoopComponent findAConnectedComponent(Multimap<LPort, LEdge> portsToEdges, LNode node, boolean isFixedOrder) {
        ArrayListMultimap edgeToPort = ArrayListMultimap.create();
        Multimaps.invertFrom(portsToEdges, (Multimap)edgeToPort);
        ConnectedSelfLoopComponent connectedComponent = new ConnectedSelfLoopComponent(node);
        ArrayList portsToProcess = Lists.newArrayList();
        portsToProcess.add((LPort)((Object)portsToEdges.keys().iterator().next()));
        ArrayList portsProcessed = Lists.newArrayList();
        while (!portsToProcess.isEmpty()) {
            LPort currentPort = (LPort)((Object)portsToProcess.iterator().next());
            portsProcessed.add(currentPort);
            Collection allEdgesOnCurrentPort = portsToEdges.removeAll((Object)currentPort);
            for (LEdge currentEdge : allEdgesOnCurrentPort) {
                if (!connectedComponent.tryAddEdge(currentEdge, isFixedOrder)) continue;
                Collection portsOfCurrentEdge = edgeToPort.removeAll((Object)currentEdge);
                for (LPort port : portsOfCurrentEdge) {
                    if (portsProcessed.contains((Object)port)) continue;
                    portsToProcess.add(port);
                }
            }
            portsToProcess.remove((Object)currentPort);
        }
        return connectedComponent;
    }
}

