/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.intermediate.compaction;

import com.google.common.collect.Sets;
import de.cau.cs.kieler.core.math.KVector;
import de.cau.cs.kieler.core.math.KVectorChain;
import de.cau.cs.kieler.core.properties.IProperty;
import de.cau.cs.kieler.kiml.options.Direction;
import de.cau.cs.kieler.kiml.util.nodespacing.Rectangle;
import de.cau.cs.kieler.klay.layered.compaction.oned.CNode;
import de.cau.cs.kieler.klay.layered.compaction.oned.CompareFuzzy;
import de.cau.cs.kieler.klay.layered.graph.LEdge;
import de.cau.cs.kieler.klay.layered.graph.LGraph;
import de.cau.cs.kieler.klay.layered.intermediate.compaction.VerticalSegment;
import de.cau.cs.kieler.klay.layered.properties.InternalProperties;
import de.cau.cs.kieler.klay.layered.properties.Properties;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public final class CLEdge
extends CNode {
    private double horizontalSpacing;
    private double verticalSpacing;
    private KVectorChain bends;
    private KVectorChain juctionPoints;
    public Set<LEdge> originalLEdges = Sets.newHashSet();

    public CLEdge(VerticalSegment vSeg, LGraph layeredGraph) {
        this.horizontalSpacing = ((Float)layeredGraph.getProperty(InternalProperties.SPACING)).floatValue() * ((Float)layeredGraph.getProperty((IProperty)Properties.EDGE_SPACING_FACTOR)).floatValue();
        this.verticalSpacing = this.horizontalSpacing * (double)((Float)layeredGraph.getProperty(Properties.OBJ_SPACING_IN_LAYER_FACTOR)).floatValue();
        this.bends = new KVectorChain();
        this.juctionPoints = new KVectorChain();
        this.hitbox = new Rectangle(vSeg.x1, vSeg.y1, 0.0, vSeg.y2 - vSeg.y1);
        this.parentNode = vSeg.parentNode;
        this.cGroupOffset.x = vSeg.relativePosition;
        this.addSegment(vSeg);
    }

    public void addSegment(VerticalSegment vSeg) {
        this.bends.addAll(new KVector[]{vSeg.bend1, vSeg.bend2});
        this.juctionPoints.addAll((Collection)vSeg.junctionPoints);
        this.spacingIgnore.up |= vSeg.blockTopSpacing;
        this.spacingIgnore.down |= vSeg.blockBottomSpacing;
        double newY1 = Math.min(this.hitbox.y, vSeg.y1);
        double newY2 = Math.max(this.hitbox.y + this.hitbox.height, vSeg.y2);
        this.hitbox.setRect(vSeg.x1, newY1, 0.0, newY2 - newY1);
        this.originalLEdges.add(vSeg.lEdge);
        if (vSeg.lEdge.getSource().getNode() == vSeg.lEdge.getTarget().getNode()) {
            this.lock.set(true, true, true, true);
        }
        HashSet inc = Sets.newHashSet();
        HashSet out = Sets.newHashSet();
        for (LEdge e : this.originalLEdges) {
            inc.add(e.getSource());
            out.add(e.getTarget());
        }
        int difference = inc.size() - out.size();
        if (difference < 0) {
            this.lock.set(true, Direction.LEFT);
            this.lock.set(false, Direction.RIGHT);
        } else if (difference > 0) {
            this.lock.set(false, Direction.LEFT);
            this.lock.set(true, Direction.RIGHT);
        }
    }

    public boolean intersects(VerticalSegment vSeg) {
        return CompareFuzzy.eq(this.hitbox.x, vSeg.x1) && !CompareFuzzy.lt(this.hitbox.y + this.hitbox.height, vSeg.y1) && !CompareFuzzy.lt(vSeg.y2, this.hitbox.y);
    }

    @Override
    public void applyElementPosition() {
        for (KVector b : this.bends) {
            b.x = this.hitbox.x;
        }
        for (KVector j : this.juctionPoints) {
            j.x = this.hitbox.x;
        }
    }

    @Override
    public double getElementPosition() {
        return ((KVector)this.bends.getFirst()).x;
    }

    @Override
    public double getHorizontalSpacing() {
        return this.horizontalSpacing;
    }

    @Override
    public double getVerticalSpacing() {
        return this.verticalSpacing;
    }

    public String toString() {
        return this.originalLEdges.toString();
    }

    @Override
    protected String getDebugSVG() {
        return "<line x1=\"" + this.hitbox.x + "\" y1=\"" + this.hitbox.y + "\" x2=\"" + (this.hitbox.x + this.hitbox.width) + "\" y2=\"" + (this.hitbox.y + this.hitbox.height) + "\" stroke=\"" + (this.reposition ? "blue" : "red") + "\" stroke-width=\"3px\"/>";
    }
}

