/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.intermediate.compaction;

import com.google.common.collect.Iterables;
import de.cau.cs.kieler.kiml.options.Direction;
import de.cau.cs.kieler.kiml.util.nodespacing.Rectangle;
import de.cau.cs.kieler.klay.layered.compaction.oned.CNode;
import de.cau.cs.kieler.klay.layered.graph.LGraph;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.properties.InternalProperties;
import de.cau.cs.kieler.klay.layered.properties.Properties;

public final class CLNode
extends CNode {
    private double horizontalSpacing;
    private double verticalSpacing;
    private LNode lNode;

    public CLNode(LNode lNode, LGraph layeredGraph) {
        this.horizontalSpacing = ((Float)layeredGraph.getProperty(InternalProperties.SPACING)).floatValue();
        this.verticalSpacing = this.horizontalSpacing * (double)((Float)layeredGraph.getProperty(Properties.OBJ_SPACING_IN_LAYER_FACTOR)).floatValue();
        this.lNode = lNode;
        this.hitbox = new Rectangle(lNode.getPosition().x - lNode.getMargin().left, lNode.getPosition().y - lNode.getMargin().top, lNode.getSize().x + lNode.getMargin().left + lNode.getMargin().right, lNode.getSize().y + lNode.getMargin().top + lNode.getMargin().bottom);
        this.cGroupOffset.reset();
        int difference = Iterables.size(lNode.getIncomingEdges()) - Iterables.size(lNode.getOutgoingEdges());
        if (difference < 0) {
            this.lock.set(true, Direction.LEFT);
        } else if (difference > 0) {
            this.lock.set(true, Direction.RIGHT);
        }
        if (lNode.getType() == LNode.NodeType.EXTERNAL_PORT) {
            this.lock.set(false, false, false, false);
        }
    }

    public LNode getlNode() {
        return this.lNode;
    }

    @Override
    public void applyElementPosition() {
        this.lNode.getPosition().x = this.hitbox.x + this.lNode.getMargin().left;
    }

    @Override
    public double getElementPosition() {
        return this.lNode.getPosition().x;
    }

    @Override
    public double getHorizontalSpacing() {
        if (this.lNode.getType() == LNode.NodeType.EXTERNAL_PORT) {
            return 0.0;
        }
        return this.horizontalSpacing;
    }

    @Override
    public double getVerticalSpacing() {
        if (this.lNode.getType() == LNode.NodeType.EXTERNAL_PORT) {
            return 0.0;
        }
        return this.verticalSpacing;
    }

    public String toString() {
        return this.lNode.getProperty(InternalProperties.ORIGIN).toString();
    }
}

