/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.intermediate.compaction;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Sets;
import de.cau.cs.kieler.core.alg.IKielerProgressMonitor;
import de.cau.cs.kieler.core.util.Pair;
import de.cau.cs.kieler.kiml.options.Direction;
import de.cau.cs.kieler.klay.layered.ILayoutProcessor;
import de.cau.cs.kieler.klay.layered.compaction.oned.CNode;
import de.cau.cs.kieler.klay.layered.compaction.oned.ISpacingsHandler;
import de.cau.cs.kieler.klay.layered.compaction.oned.OneDimensionalCompactor;
import de.cau.cs.kieler.klay.layered.compaction.oned.algs.ICompactionAlgorithm;
import de.cau.cs.kieler.klay.layered.compaction.oned.algs.IConstraintCalculationAlgorithm;
import de.cau.cs.kieler.klay.layered.compaction.oned.algs.ScanlineConstraintCalculator;
import de.cau.cs.kieler.klay.layered.graph.LGraph;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.intermediate.compaction.CLEdge;
import de.cau.cs.kieler.klay.layered.intermediate.compaction.CLNode;
import de.cau.cs.kieler.klay.layered.intermediate.compaction.ConstraintCalculationStrategy;
import de.cau.cs.kieler.klay.layered.intermediate.compaction.GraphCompactionStrategy;
import de.cau.cs.kieler.klay.layered.intermediate.compaction.LGraphToCGraphTransformer;
import de.cau.cs.kieler.klay.layered.intermediate.compaction.NetworkSimplexCompaction;
import de.cau.cs.kieler.klay.layered.properties.InternalProperties;
import de.cau.cs.kieler.klay.layered.properties.Properties;
import de.cau.cs.kieler.klay.layered.properties.Spacings;

public class HorizontalGraphCompactor
implements ILayoutProcessor {
    public static final ICompactionAlgorithm NETWORK_SIMPLEX_COMPACTION = new NetworkSimplexCompaction();
    private static final IConstraintCalculationAlgorithm EDGE_AWARE_SCANLINE_CONSTRAINTS = new EdgeAwareScanlineConstraintCalculation();
    private LGraph lGraph;
    private final ISpacingsHandler<CNode> specialSpacingsHandler = new ISpacingsHandler<CNode>(){

        @Override
        public double getHorizontalSpacing(CNode cNode1, CNode cNode2) {
            if (this.isVerticalSegmentsOfSameEdge(cNode1, cNode2)) {
                return 0.0;
            }
            LNode node1 = null;
            if (cNode1 instanceof CLNode) {
                node1 = ((CLNode)cNode1).getlNode();
            }
            LNode node2 = null;
            if (cNode2 instanceof CLNode) {
                node2 = ((CLNode)cNode2).getlNode();
            }
            if (node1 != null && node1.getType() == LNode.NodeType.EXTERNAL_PORT || node2 != null && node2.getType() == LNode.NodeType.EXTERNAL_PORT) {
                return 0.0;
            }
            Spacings spacings = (Spacings)HorizontalGraphCompactor.this.lGraph.getProperty(InternalProperties.SPACINGS);
            return spacings.getHorizontalSpacing(node1 != null ? node1.getType() : LNode.NodeType.LONG_EDGE, node2 != null ? node2.getType() : LNode.NodeType.LONG_EDGE);
        }

        @Override
        public double getVerticalSpacing(CNode cNode1, CNode cNode2) {
            if (this.isVerticalSegmentsOfSameEdge(cNode1, cNode2)) {
                return 1.0;
            }
            return Math.min(cNode1.getVerticalSpacing(), cNode2.getVerticalSpacing());
        }

        private boolean isVerticalSegmentsOfSameEdge(CNode cNode1, CNode cNode2) {
            return cNode1 instanceof CLEdge && cNode2 instanceof CLEdge && !Sets.intersection(((CLEdge)cNode1).originalLEdges, ((CLEdge)cNode2).originalLEdges).isEmpty();
        }
    };

    @Override
    public void process(LGraph layeredGraph, IKielerProgressMonitor progressMonitor) {
        GraphCompactionStrategy strategy = (GraphCompactionStrategy)((Object)layeredGraph.getProperty(Properties.POST_COMPACTION));
        if (strategy == GraphCompactionStrategy.NONE) {
            return;
        }
        progressMonitor.begin("Horizontal Compaction", 1.0f);
        this.lGraph = layeredGraph;
        LGraphToCGraphTransformer transformer = new LGraphToCGraphTransformer();
        OneDimensionalCompactor odc = new OneDimensionalCompactor(transformer.transform(layeredGraph));
        odc.setSpacingsHandler(this.specialSpacingsHandler);
        switch ((ConstraintCalculationStrategy)((Object)layeredGraph.getProperty(Properties.POST_COMPACTION_COSTRAINTS))) {
            case SCANLINE: {
                odc.setConstraintAlgorithm(EDGE_AWARE_SCANLINE_CONSTRAINTS);
                break;
            }
            default: {
                odc.setConstraintAlgorithm(OneDimensionalCompactor.QUADRATIC_CONSTRAINTS);
            }
        }
        switch (strategy) {
            case LEFT: {
                odc.compact();
                break;
            }
            case RIGHT: {
                odc.changeDirection(Direction.RIGHT).compact();
                break;
            }
            case LEFT_RIGHT_CONSTRAINT_LOCKING: {
                odc.compact().changeDirection(Direction.RIGHT).applyLockingStrategy().compact();
                break;
            }
            case LEFT_RIGHT_CONNECTION_LOCKING: {
                odc.compact().changeDirection(Direction.RIGHT).setLockingStrategy((Function<Pair<CNode, Direction>, Boolean>)((Function)pair -> !((CNode)pair.getFirst()).lock.get((Direction)pair.getSecond()))).applyLockingStrategy().compact();
                break;
            }
            case EDGE_LENGTH: {
                odc.setCompactionAlgorithm(NETWORK_SIMPLEX_COMPACTION).compact();
                break;
            }
        }
        odc.finish();
        transformer.applyLayout();
        progressMonitor.done();
    }

    private static final class EdgeAwareScanlineConstraintCalculation
    extends ScanlineConstraintCalculator {
        private final Function<CNode, Double> defaultSpacingFun = n -> this.compactor.direction.isHorizontal() ? n.getVerticalSpacing() : n.getHorizontalSpacing();

        private EdgeAwareScanlineConstraintCalculation() {
        }

        @Override
        public void calculateConstraints(OneDimensionalCompactor theCompactor) {
            this.compactor = theCompactor;
            this.sweep((Predicate<CNode>)((Predicate)n -> n instanceof CLEdge), this.defaultSpacingFun);
            this.sweep((Predicate<CNode>)((Predicate)n -> n instanceof CLNode), this.defaultSpacingFun);
            double minSpacing = Double.POSITIVE_INFINITY;
            for (CNode n2 : this.compactor.cGraph.cNodes) {
                if (n2 instanceof CLNode && ((CLNode)n2).getlNode().getType() == LNode.NodeType.EXTERNAL_PORT) continue;
                minSpacing = Math.min(minSpacing, (Double)this.defaultSpacingFun.apply((Object)n2));
            }
            if (minSpacing == Double.POSITIVE_INFINITY) {
                minSpacing = 0.0;
            }
            double finalMinSpacing = minSpacing;
            this.sweep((Predicate<CNode>)((Predicate)n -> true), (Function<CNode, Double>)((Function)n -> finalMinSpacing));
        }
    }
}

