/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.intermediate.compaction;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import de.cau.cs.kieler.core.math.KVector;
import de.cau.cs.kieler.core.util.Pair;
import de.cau.cs.kieler.kiml.options.Direction;
import de.cau.cs.kieler.kiml.options.LayoutOptions;
import de.cau.cs.kieler.kiml.options.PortSide;
import de.cau.cs.kieler.klay.layered.compaction.oned.CGraph;
import de.cau.cs.kieler.klay.layered.compaction.oned.CGroup;
import de.cau.cs.kieler.klay.layered.compaction.oned.CNode;
import de.cau.cs.kieler.klay.layered.compaction.oned.CompareFuzzy;
import de.cau.cs.kieler.klay.layered.compaction.oned.ICGraphTransformer;
import de.cau.cs.kieler.klay.layered.graph.LEdge;
import de.cau.cs.kieler.klay.layered.graph.LGraph;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.graph.Layer;
import de.cau.cs.kieler.klay.layered.intermediate.compaction.CLEdge;
import de.cau.cs.kieler.klay.layered.intermediate.compaction.CLNode;
import de.cau.cs.kieler.klay.layered.intermediate.compaction.VerticalSegment;
import de.cau.cs.kieler.klay.layered.properties.InternalProperties;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public final class LGraphToCGraphTransformer
implements ICGraphTransformer<LGraph> {
    private CGraph cGraph;
    private LGraph layeredGraph;
    private boolean hasEdges;
    private Map<LNode, Pair<LNode, KVector>> commentOffsets = Maps.newHashMap();

    @Override
    public CGraph transform(LGraph inputGraph) {
        this.layeredGraph = inputGraph;
        this.commentOffsets.clear();
        this.hasEdges = false;
        block0: for (Layer l : this.layeredGraph) {
            for (LNode n : l) {
                if (Iterables.isEmpty(n.getConnectedEdges())) continue;
                this.hasEdges = true;
                break block0;
            }
        }
        EnumSet<Direction> supportedDirections = EnumSet.of(Direction.UNDEFINED, Direction.LEFT, Direction.RIGHT);
        if (!this.hasEdges) {
            supportedDirections.add(Direction.UP);
            supportedDirections.add(Direction.DOWN);
        }
        this.cGraph = new CGraph(supportedDirections);
        this.readNodes();
        return this.cGraph;
    }

    private void readNodes() {
        CNode cNode;
        ArrayList verticalSegments = Lists.newArrayList();
        this.cGraph.cNodes.clear();
        HashMap nodeMap = Maps.newHashMap();
        for (Layer layer : this.layeredGraph) {
            for (LNode node : layer) {
                if (((Boolean)node.getProperty(LayoutOptions.COMMENT_BOX)).booleanValue() && !Iterables.isEmpty(node.getConnectedEdges())) {
                    LEdge e = (LEdge)((Object)Iterables.get(node.getConnectedEdges(), (int)0));
                    LNode other = e.getSource().getNode();
                    if (other == node) {
                        other = e.getTarget().getNode();
                    }
                    Pair p = Pair.of((Object)((Object)other), (Object)node.getPosition().clone().sub(other.getPosition()));
                    this.commentOffsets.put(node, (Pair<LNode, KVector>)p);
                    continue;
                }
                cNode = new CLNode(node, this.layeredGraph);
                this.cGraph.cNodes.add(cNode);
                nodeMap.put(node, cNode);
            }
        }
        for (Layer layer : this.layeredGraph) {
            for (LNode node : layer) {
                cNode = (CNode)nodeMap.get((Object)node);
                for (LEdge edge : node.getOutgoingEdges()) {
                    VerticalSegment vs;
                    Iterator bends = edge.getBendPoints().iterator();
                    boolean first = true;
                    VerticalSegment lastSegment = null;
                    if (!bends.hasNext()) continue;
                    KVector bend1 = (KVector)bends.next();
                    KVector bend2 = null;
                    if (edge.getSource().getSide() == PortSide.NORTH) {
                        vs = new VerticalSegment(bend1, new KVector(bend1.x, cNode.hitbox.y), cNode, edge);
                        vs.blockBottomSpacing = true;
                        verticalSegments.add(vs);
                    }
                    if (edge.getSource().getSide() == PortSide.SOUTH) {
                        vs = new VerticalSegment(bend1, new KVector(bend1.x, cNode.hitbox.y + cNode.hitbox.height), cNode, edge);
                        vs.blockTopSpacing = true;
                        verticalSegments.add(vs);
                    }
                    while (bends.hasNext()) {
                        bend2 = (KVector)bends.next();
                        if (!CompareFuzzy.eq(bend1.y, bend2.y)) {
                            lastSegment = new VerticalSegment(bend1, bend2, null, edge);
                            verticalSegments.add(lastSegment);
                            if (first) {
                                first = false;
                                if (bend2.y < cNode.hitbox.y) {
                                    lastSegment.blockBottomSpacing = true;
                                } else if (bend2.y > cNode.hitbox.y + cNode.hitbox.height) {
                                    lastSegment.blockTopSpacing = true;
                                } else {
                                    lastSegment.blockTopSpacing = true;
                                    lastSegment.blockBottomSpacing = true;
                                }
                            }
                        }
                        if (!bends.hasNext()) continue;
                        bend1 = bend2;
                    }
                    if (lastSegment == null) continue;
                    CNode cTargetNode = (CNode)nodeMap.get((Object)edge.getTarget().getNode());
                    if (bend1.y < cTargetNode.hitbox.y) {
                        lastSegment.blockBottomSpacing = true;
                        continue;
                    }
                    if (bend1.y > cTargetNode.hitbox.y + cTargetNode.hitbox.height) {
                        lastSegment.blockTopSpacing = true;
                        continue;
                    }
                    lastSegment.blockTopSpacing = true;
                    lastSegment.blockBottomSpacing = true;
                }
                for (LEdge edge : node.getIncomingEdges()) {
                    if (edge.getBendPoints().isEmpty()) continue;
                    KVector bend1 = (KVector)edge.getBendPoints().getLast();
                    if (edge.getTarget().getSide() == PortSide.NORTH) {
                        VerticalSegment vs = new VerticalSegment(bend1, new KVector(bend1.x, cNode.hitbox.y), cNode, edge);
                        vs.blockBottomSpacing = true;
                        verticalSegments.add(vs);
                    }
                    if (edge.getTarget().getSide() != PortSide.SOUTH) continue;
                    VerticalSegment vs = new VerticalSegment(bend1, new KVector(bend1.x, cNode.hitbox.y + cNode.hitbox.height), cNode, edge);
                    vs.blockTopSpacing = true;
                    verticalSegments.add(vs);
                }
            }
        }
        if (!verticalSegments.isEmpty()) {
            Collections.sort(verticalSegments);
            VerticalSegment last = (VerticalSegment)verticalSegments.get(0);
            CLEdge c = new CLEdge(last, this.layeredGraph);
            int i = 1;
            while (i < verticalSegments.size()) {
                VerticalSegment verticalSegment = (VerticalSegment)verticalSegments.get(i);
                if (c.intersects(verticalSegment)) {
                    c.addSegment(verticalSegment);
                } else {
                    this.cGraph.cNodes.add(c);
                    c = new CLEdge(verticalSegment, this.layeredGraph);
                }
                last = verticalSegment;
                ++i;
            }
            this.cGraph.cNodes.add(c);
        }
        verticalSegments.clear();
        this.groupCNodes();
    }

    private void groupCNodes() {
        this.cGraph.cGroups.clear();
        for (CNode cNode : this.cGraph.cNodes) {
            cNode.cGroup = null;
        }
        for (CNode cNode : this.cGraph.cNodes) {
            if (cNode.parentNode != null) continue;
            this.cGraph.cGroups.add(new CGroup(cNode));
        }
        for (CNode cNode : this.cGraph.cNodes) {
            if (cNode.parentNode == null) continue;
            cNode.parentNode.cGroup.addCNode(cNode);
        }
    }

    @Override
    public void applyLayout() {
        this.applyNodePositions();
        this.applyCommentPositions();
        KVector topLeft = new KVector(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
        KVector bottomRight = new KVector(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        for (CNode cNode : this.cGraph.cNodes) {
            topLeft.x = Math.min(topLeft.x, cNode.hitbox.x);
            topLeft.y = Math.min(topLeft.y, cNode.hitbox.y);
            bottomRight.x = Math.max(bottomRight.x, cNode.hitbox.x + cNode.hitbox.width);
            bottomRight.y = Math.max(bottomRight.y, cNode.hitbox.y + cNode.hitbox.height);
        }
        this.layeredGraph.getOffset().reset().add(topLeft.clone().negate());
        this.layeredGraph.getSize().reset().add(bottomRight.clone().sub(topLeft));
        this.applyExternalPortPositions(topLeft, bottomRight);
        this.cGraph.cGroups.clear();
        this.cGraph.cNodes.clear();
    }

    private void applyNodePositions() {
        for (CNode cNode : this.cGraph.cNodes) {
            cNode.applyElementPosition();
        }
    }

    private void applyCommentPositions() {
        for (Map.Entry<LNode, Pair<LNode, KVector>> e : this.commentOffsets.entrySet()) {
            LNode comment = e.getKey();
            LNode other = (LNode)((Object)e.getValue().getFirst());
            KVector offset = (KVector)e.getValue().getSecond();
            comment.getPosition().reset().add(other.getPosition().clone().add(offset));
        }
    }

    private void applyExternalPortPositions(KVector topLeft, KVector bottomRight) {
        double borderSpacing = ((Float)this.layeredGraph.getProperty(LayoutOptions.BORDER_SPACING)).doubleValue();
        for (CNode cNode : this.cGraph.cNodes) {
            LNode lNode;
            if (!(cNode instanceof CLNode) || (lNode = ((CLNode)cNode).getlNode()).getType() != LNode.NodeType.EXTERNAL_PORT) continue;
            switch ((PortSide)lNode.getProperty(InternalProperties.EXT_PORT_SIDE)) {
                case WEST: {
                    lNode.getPosition().x = topLeft.x - borderSpacing;
                    break;
                }
                case EAST: {
                    lNode.getPosition().x = bottomRight.x + borderSpacing - (lNode.getSize().x + lNode.getMargin().right);
                    break;
                }
                case NORTH: {
                    lNode.getPosition().y = topLeft.y - borderSpacing;
                    break;
                }
                case SOUTH: {
                    lNode.getPosition().y = bottomRight.y + borderSpacing - (lNode.getSize().y + lNode.getMargin().bottom);
                }
            }
        }
    }
}

