/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.intermediate.compaction;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import de.cau.cs.kieler.core.alg.BasicProgressMonitor;
import de.cau.cs.kieler.core.alg.IKielerProgressMonitor;
import de.cau.cs.kieler.kiml.options.PortSide;
import de.cau.cs.kieler.klay.layered.compaction.oned.CGroup;
import de.cau.cs.kieler.klay.layered.compaction.oned.CNode;
import de.cau.cs.kieler.klay.layered.compaction.oned.OneDimensionalCompactor;
import de.cau.cs.kieler.klay.layered.compaction.oned.algs.ICompactionAlgorithm;
import de.cau.cs.kieler.klay.layered.graph.LEdge;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.graph.LPort;
import de.cau.cs.kieler.klay.layered.intermediate.compaction.CLEdge;
import de.cau.cs.kieler.klay.layered.intermediate.compaction.CLNode;
import de.cau.cs.kieler.klay.layered.networksimplex.NEdge;
import de.cau.cs.kieler.klay.layered.networksimplex.NGraph;
import de.cau.cs.kieler.klay.layered.networksimplex.NNode;
import de.cau.cs.kieler.klay.layered.networksimplex.NetworkSimplex;
import java.util.HashMap;
import java.util.LinkedList;

public class NetworkSimplexCompaction
implements ICompactionAlgorithm {
    private OneDimensionalCompactor compactor;
    private NGraph networkSimplexGraph;
    private NNode[] nNodes;
    private int index;
    private static final int SEPARATION_WEIGHT = 1;
    private static final int EDGE_WEIGHT = 100;

    @Override
    public void compact(OneDimensionalCompactor theCompactor) {
        this.compactor = theCompactor;
        this.networkSimplexGraph = new NGraph();
        this.nNodes = new NNode[this.compactor.cGraph.cGroups.size()];
        this.index = 0;
        for (CGroup cGroup : this.compactor.cGraph.cGroups) {
            NNode nNode;
            cGroup.id = this.index;
            this.nNodes[this.index] = nNode = NNode.of().id(this.index).origin(cGroup).create(this.networkSimplexGraph);
            ++this.index;
        }
        this.addSeparationConstraints();
        this.addEdgeConstraints();
        this.addArtificialSourceNode();
        NetworkSimplex.forGraph(this.networkSimplexGraph).execute((IKielerProgressMonitor)new BasicProgressMonitor());
        for (CNode cNode : this.compactor.cGraph.cNodes) {
            cNode.startPos = (double)this.nNodes[cNode.cGroup.id].layer + cNode.cGroupOffset.x;
            cNode.applyPosition();
        }
    }

    private boolean isVerticalSegmentsOfSameEdge(CNode cNode1, CNode cNode2) {
        return cNode1.parentNode != null && cNode2.parentNode != null && cNode1 instanceof CLEdge && cNode2 instanceof CLEdge && !Sets.intersection(((CLEdge)cNode1).originalLEdges, ((CLEdge)cNode2).originalLEdges).isEmpty();
    }

    private void addSeparationConstraints() {
        for (CNode cNode : this.compactor.cGraph.cNodes) {
            for (CNode incNode : cNode.constraints) {
                if (cNode.cGroup == incNode.cGroup) continue;
                double spacing = this.compactor.direction.isHorizontal() ? this.compactor.spacingsHandler.getHorizontalSpacing(cNode, incNode) : this.compactor.spacingsHandler.getVerticalSpacing(cNode, incNode);
                double delta = cNode.cGroupOffset.x + cNode.hitbox.width + spacing - incNode.cGroupOffset.x;
                delta = Math.ceil(delta);
                delta = Math.max(0.0, delta);
                if (!this.isVerticalSegmentsOfSameEdge(cNode, incNode)) {
                    double weight = 1.0;
                    if (cNode instanceof CLEdge && incNode instanceof CLNode || incNode instanceof CLEdge && cNode instanceof CLNode) {
                        weight = 2.0;
                    }
                    NEdge.of().delta((int)delta).weight(weight).source(this.nNodes[cNode.cGroup.id]).target(this.nNodes[incNode.cGroup.id]).create();
                    continue;
                }
                NNode helper = NNode.of().create(this.networkSimplexGraph);
                int offsetDelta = (int)Math.ceil(incNode.cGroupOffset.x - cNode.cGroupOffset.x);
                NEdge.of().delta(Math.max(0, offsetDelta)).weight(1.0).source(helper).target(this.nNodes[cNode.cGroup.id]).create();
                NEdge.of().delta(Math.max(0, -offsetDelta)).weight(1.0).source(helper).target(this.nNodes[incNode.cGroup.id]).create();
            }
        }
    }

    private void addEdgeConstraints() {
        LNode lNode;
        HashMap lNodeMap = Maps.newHashMap();
        HashMultimap lEdgeMap = HashMultimap.create();
        for (CNode cNode : this.compactor.cGraph.cNodes) {
            if (cNode instanceof CLNode) {
                lNode = ((CLNode)cNode).getlNode();
                lNodeMap.put(lNode, cNode);
                continue;
            }
            if (!(cNode instanceof CLEdge)) continue;
            for (LEdge e : ((CLEdge)cNode).originalLEdges) {
                lEdgeMap.put((Object)e, (Object)cNode);
            }
        }
        for (CNode cNode : this.compactor.cGraph.cNodes) {
            if (!(cNode instanceof CLNode)) continue;
            lNode = ((CLNode)cNode).getlNode();
            for (LEdge lEdge : lNode.getOutgoingEdges()) {
                NNode tgt;
                NNode src;
                if (lEdge.isSelfLoop()) continue;
                LPort srcPort = lEdge.getSource();
                LPort tgtPort = lEdge.getTarget();
                if (PortSide.SIDES_NORTH_SOUTH.contains(lEdge.getSource().getSide()) && PortSide.SIDES_NORTH_SOUTH.contains(lEdge.getTarget().getSide())) continue;
                CNode target = (CNode)lNodeMap.get((Object)lEdge.getTarget().getNode());
                NEdge.of().delta(0).weight(100.0).source(this.nNodes[cNode.cGroup.id]).target(this.nNodes[target.cGroup.id]).create();
                if (srcPort.getSide() == PortSide.WEST && LPort.OUTPUT_PREDICATE.apply((Object)srcPort)) {
                    for (CNode n : lEdgeMap.get((Object)lEdge)) {
                        if (!(n.hitbox.x < cNode.hitbox.x) || (src = this.nNodes[n.cGroup.id]) == (tgt = this.nNodes[cNode.cGroup.id])) continue;
                        NEdge.of().delta(1).weight(100.0).source(src).target(tgt).create();
                    }
                }
                if (tgtPort.getSide() != PortSide.EAST || !LPort.INPUT_PREDICATE.apply((Object)tgtPort)) continue;
                for (CNode n : lEdgeMap.get((Object)lEdge)) {
                    if (!(n.hitbox.x > cNode.hitbox.x) || (src = this.nNodes[cNode.cGroup.id]) == (tgt = this.nNodes[n.cGroup.id])) continue;
                    NEdge.of().delta(1).weight(100.0).source(src).target(tgt).create();
                }
            }
        }
    }

    private void addArtificialSourceNode() {
        LinkedList sources = Lists.newLinkedList();
        for (NNode n : this.networkSimplexGraph.nodes) {
            if (!n.getIncomingEdges().isEmpty()) continue;
            sources.add(n);
        }
        if (sources.size() > 1) {
            NNode dummySource = NNode.of().id(this.index++).create(this.networkSimplexGraph);
            for (NNode src : sources) {
                NEdge.of().delta(1).weight(0.0).source(dummySource).target(src).create();
            }
        }
    }
}

