/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.intermediate.compaction;

import de.cau.cs.kieler.core.math.KVector;
import de.cau.cs.kieler.core.math.KVectorChain;
import de.cau.cs.kieler.kiml.options.LayoutOptions;
import de.cau.cs.kieler.klay.layered.compaction.oned.CNode;
import de.cau.cs.kieler.klay.layered.compaction.oned.CompareFuzzy;
import de.cau.cs.kieler.klay.layered.graph.LEdge;

public final class VerticalSegment
implements Comparable<VerticalSegment> {
    public CNode parentNode;
    public double relativePosition;
    public KVector bend1;
    public KVector bend2;
    public KVectorChain junctionPoints = new KVectorChain();
    public double x1;
    public double y1;
    public double y2;
    public LEdge lEdge;
    public boolean blockTopSpacing = true;
    public boolean blockBottomSpacing = false;

    public VerticalSegment(KVector bend1, KVector bend2, CNode cNode, LEdge lEdge) {
        this.bend1 = bend1;
        this.bend2 = bend2;
        if (bend1.y < bend2.y) {
            this.x1 = bend1.x;
            this.y1 = bend1.y;
            this.y2 = bend2.y;
        } else {
            this.x1 = bend2.x;
            this.y1 = bend2.y;
            this.y2 = bend1.y;
        }
        KVectorChain inJPs = (KVectorChain)lEdge.getProperty(LayoutOptions.JUNCTION_POINTS);
        if (inJPs != null) {
            for (KVector jp : inJPs) {
                if (!CompareFuzzy.eq(jp.x, bend1.x)) continue;
                this.junctionPoints.add((Object)jp);
            }
        }
        this.parentNode = cNode;
        if (this.parentNode != null) {
            this.relativePosition = this.x1 - cNode.hitbox.x;
        }
        this.lEdge = lEdge;
    }

    public boolean intersects(VerticalSegment o) {
        return CompareFuzzy.eq(this.x1, o.x1) && !CompareFuzzy.lt(this.y2, o.y1) && !CompareFuzzy.lt(o.y2, this.y1);
    }

    @Override
    public int compareTo(VerticalSegment o) {
        int d = Double.compare(this.x1, o.x1);
        if (d == 0) {
            return Double.compare(this.y1, o.y1);
        }
        return d;
    }
}

