/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.intermediate.greedyswitch;

import de.cau.cs.kieler.klay.layered.graph.LEdge;
import de.cau.cs.kieler.klay.layered.graph.LPort;
import de.cau.cs.kieler.klay.layered.graph.Layer;

public class ComparableEdgeAndPort
implements Comparable<ComparableEdgeAndPort> {
    private final LPort port;
    private final LEdge edge;
    private int[] portPositions;

    public ComparableEdgeAndPort(LPort port, LEdge edge, int[] portPositions) {
        this.port = port;
        this.edge = edge;
        this.portPositions = portPositions;
    }

    private boolean isInLayer(LEdge e) {
        Layer targetLayer;
        Layer sourceLayer = e.getSource().getNode().getLayer();
        return sourceLayer == (targetLayer = e.getTarget().getNode().getLayer());
    }

    public LEdge getEdge() {
        return this.edge;
    }

    private LPort otherEndOf(LEdge e, LPort fromPort) {
        return fromPort == e.getSource() ? e.getTarget() : e.getSource();
    }

    @Override
    public int compareTo(ComparableEdgeAndPort other) {
        if (this.position(this) < this.position(other)) {
            return -1;
        }
        if (this.position(this) > this.position(other)) {
            return 1;
        }
        if (!this.isInLayer(this.edge) || !this.isInLayer(other.edge)) {
            return 0;
        }
        if (this.thisEdgeEndsAfter(other)) {
            return -1;
        }
        if (this.thisEdgeEndSamePositionAs(other)) {
            return 0;
        }
        return 1;
    }

    private boolean thisEdgeEndSamePositionAs(ComparableEdgeAndPort other) {
        return this.position(this.otherEndOf(this.edge, this.getPort())) == this.position(this.otherEndOf(other.edge, other.getPort()));
    }

    private boolean thisEdgeEndsAfter(ComparableEdgeAndPort other) {
        return this.position(this.otherEndOf(this.edge, this.getPort())) > this.position(this.otherEndOf(other.edge, other.getPort()));
    }

    public String toString() {
        return "ComparableEdgeAndPort [port=" + (Object)((Object)this.getPort()) + ", edge=" + (Object)((Object)this.edge) + ", portPosition=" + this.position(this) + "]" + ", inLayer: " + this.isInLayer(this.edge);
    }

    private int position(LPort p) {
        return this.portPositions[p.id];
    }

    private int position(ComparableEdgeAndPort cep) {
        return this.portPositions[cep.port.id];
    }

    public LPort getPort() {
        return this.port;
    }
}

