/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.intermediate.greedyswitch;

import de.cau.cs.kieler.core.alg.IKielerProgressMonitor;
import de.cau.cs.kieler.klay.layered.ILayoutProcessor;
import de.cau.cs.kieler.klay.layered.graph.LGraph;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.graph.Layer;
import de.cau.cs.kieler.klay.layered.intermediate.greedyswitch.AllCrossingsCounter;
import de.cau.cs.kieler.klay.layered.intermediate.greedyswitch.CrossingMatrixFiller;
import de.cau.cs.kieler.klay.layered.intermediate.greedyswitch.SwitchDecider;
import de.cau.cs.kieler.klay.layered.properties.GreedySwitchType;
import de.cau.cs.kieler.klay.layered.properties.Properties;
import java.util.ListIterator;

public class GreedySwitchProcessor
implements ILayoutProcessor {
    private LGraph layeredGraph;
    private GreedySwitchType greedySwitchType;
    private SwitchDecider switchDecider;
    private LNode[][] originalNodeOrder;
    private LNode[][] currentNodeOrder;
    private LNode[][] bestNodeOrder;
    private AllCrossingsCounter crossingCounter;
    private int currentCrossings;
    private boolean sweepDownwardInLayer = true;

    @Override
    public void process(LGraph graph, IKielerProgressMonitor progressMonitor) {
        progressMonitor.begin("Greedy switch crossing reduction", 1.0f);
        this.greedySwitchType = (GreedySwitchType)((Object)graph.getProperty(Properties.GREEDY_SWITCH_TYPE));
        int layerCount = graph.getLayers().size();
        if (layerCount < 2 || this.greedySwitchType == GreedySwitchType.OFF) {
            progressMonitor.done();
            return;
        }
        this.initialize(graph);
        if (this.greedySwitchType.useBestOfUpOrDown()) {
            this.compareSweepingUpwardOrDownward();
        } else {
            this.sweepOneSidedOrTwoSided();
        }
        this.setAsGraph(this.bestNodeOrder);
        progressMonitor.done();
    }

    private void compareSweepingUpwardOrDownward() {
        this.sweepOneSidedOrTwoSided();
        LNode[][] downwardSweepOrder = this.copyNodeOrder();
        int downwardSweepCrossings = this.getCrossingCount();
        this.sweepDownwardInLayer = !this.sweepDownwardInLayer;
        this.currentNodeOrder = this.originalNodeOrder;
        this.sweepOneSidedOrTwoSided();
        int upwardSweepCrossings = this.getCrossingCount();
        if (downwardSweepCrossings <= upwardSweepCrossings) {
            this.setAsBestNodeOrder(downwardSweepOrder);
        }
    }

    private void sweepOneSidedOrTwoSided() {
        if (this.greedySwitchType.isOneSided()) {
            this.oneSidedLayerSweep();
        } else {
            this.twoSidedlayerSweep();
        }
    }

    private LNode[][] copyNodeOrder() {
        LNode[][] order = new LNode[this.bestNodeOrder.length][];
        int i = 0;
        while (i < order.length) {
            int length = this.bestNodeOrder[i].length;
            LNode[] copy = new LNode[length];
            System.arraycopy(this.bestNodeOrder[i], 0, copy, 0, length);
            order[i] = copy;
            ++i;
        }
        return order;
    }

    private int getCrossingCount() {
        return this.greedySwitchType.isOneSided() ? this.currentCrossings : this.countCurrentNumberOfCrossings();
    }

    private void oneSidedLayerSweep() {
        int crossingsInGraph = this.countCurrentNumberOfCrossings();
        int oldNumberOfCrossings = Integer.MAX_VALUE;
        while (oldNumberOfCrossings > crossingsInGraph) {
            this.setAsBestNodeOrder(this.currentNodeOrder);
            if (crossingsInGraph == 0) {
                oldNumberOfCrossings = crossingsInGraph;
                break;
            }
            this.sweepForwardReducingCrossings();
            this.sweepBackwardReducingCrossings();
            oldNumberOfCrossings = crossingsInGraph;
            crossingsInGraph = this.countCurrentNumberOfCrossings();
        }
        this.currentCrossings = oldNumberOfCrossings;
    }

    private void twoSidedlayerSweep() {
        boolean improved;
        boolean forward = true;
        do {
            improved = forward ? this.sweepForwardReducingCrossings() : this.sweepBackwardReducingCrossings();
            boolean bl = forward = !forward;
        } while (improved);
        this.setAsBestNodeOrder(this.currentNodeOrder);
    }

    private boolean sweepForwardReducingCrossings() {
        boolean improved = false;
        int freeLayerIndex = 0;
        while (freeLayerIndex < this.currentNodeOrder.length) {
            this.switchDecider = this.getNewSwitchDecider(freeLayerIndex, SwitchDecider.CrossingCountSide.WEST);
            improved |= this.continueSwitchingUntilNoImprovementInLayer(freeLayerIndex);
            ++freeLayerIndex;
        }
        return improved;
    }

    private SwitchDecider getNewSwitchDecider(int freeLayerIndex, SwitchDecider.CrossingCountSide side) {
        CrossingMatrixFiller crossingMatrixFiller = new CrossingMatrixFiller(this.greedySwitchType, this.currentNodeOrder, freeLayerIndex, side);
        return new SwitchDecider(freeLayerIndex, this.currentNodeOrder, crossingMatrixFiller);
    }

    private boolean sweepBackwardReducingCrossings() {
        boolean improved = false;
        int freeLayerIndex = this.currentNodeOrder.length - 1;
        while (freeLayerIndex >= 0) {
            this.switchDecider = this.getNewSwitchDecider(freeLayerIndex, SwitchDecider.CrossingCountSide.EAST);
            improved |= this.continueSwitchingUntilNoImprovementInLayer(freeLayerIndex);
            --freeLayerIndex;
        }
        return improved;
    }

    private boolean continueSwitchingUntilNoImprovementInLayer(int freeLayerIndex) {
        boolean continueSwitching;
        boolean improved = false;
        do {
            continueSwitching = this.sweepDownwardInLayer ? this.sweepDownwardInLayer(freeLayerIndex) : this.sweepUpwardInLayer(freeLayerIndex);
            improved |= continueSwitching;
        } while (continueSwitching);
        return improved;
    }

    private boolean sweepDownwardInLayer(int layerIndex) {
        boolean continueSwitching = false;
        int lengthOfFreeLayer = this.currentNodeOrder[layerIndex].length;
        int upperNodeIndex = 0;
        while (upperNodeIndex < lengthOfFreeLayer - 1) {
            int lowerNodeIndex = upperNodeIndex + 1;
            continueSwitching |= this.switchIfImproves(layerIndex, upperNodeIndex, lowerNodeIndex);
            ++upperNodeIndex;
        }
        return continueSwitching;
    }

    private boolean sweepUpwardInLayer(int layerIndex) {
        boolean continueSwitching = false;
        int lengthOfFreeLayer = this.currentNodeOrder[layerIndex].length;
        int lowerNodeIndex = lengthOfFreeLayer - 1;
        while (lowerNodeIndex > 0) {
            int upperNodeIndex = lowerNodeIndex - 1;
            continueSwitching |= this.switchIfImproves(layerIndex, upperNodeIndex, lowerNodeIndex);
            --lowerNodeIndex;
        }
        return continueSwitching;
    }

    private boolean switchIfImproves(int layerIndex, int upperNodeIndex, int lowerNodeIndex) {
        boolean continueSwitching = false;
        if (this.switchDecider.doesSwitchReduceCrossings(upperNodeIndex, lowerNodeIndex)) {
            this.exchangeNodes(upperNodeIndex, lowerNodeIndex, layerIndex);
            continueSwitching = true;
        }
        return continueSwitching;
    }

    private int countCurrentNumberOfCrossings() {
        return this.crossingCounter.countAllCrossingsInGraphWithOrder(this.currentNodeOrder);
    }

    private void setAsBestNodeOrder(LNode[][] nodeOrder) {
        int i = 0;
        while (i < this.bestNodeOrder.length) {
            int j = 0;
            while (j < this.bestNodeOrder[i].length) {
                this.bestNodeOrder[i][j] = nodeOrder[i][j];
                ++j;
            }
            ++i;
        }
    }

    private void exchangeNodes(int indexOne, int indexTwo, int layerIndex) {
        this.switchDecider.notifyOfSwitch(this.currentNodeOrder[layerIndex][indexOne], this.currentNodeOrder[layerIndex][indexTwo]);
        LNode[] layer = this.currentNodeOrder[layerIndex];
        LNode temp = layer[indexTwo];
        layer[indexTwo] = layer[indexOne];
        layer[indexOne] = temp;
    }

    private void setAsGraph(LNode[][] nodeOrder) {
        ListIterator<Layer> layerIter = this.layeredGraph.getLayers().listIterator();
        while (layerIter.hasNext()) {
            Layer layer = layerIter.next();
            LNode[] nodes = nodeOrder[layerIter.previousIndex()];
            ListIterator<LNode> nodeIter = layer.getNodes().listIterator();
            while (nodeIter.hasNext()) {
                nodeIter.next();
                nodeIter.set(nodes[nodeIter.previousIndex()]);
            }
        }
    }

    private void initialize(LGraph graph) {
        this.layeredGraph = graph;
        int layerCount = graph.getLayers().size();
        this.bestNodeOrder = new LNode[layerCount][];
        this.currentNodeOrder = new LNode[layerCount][];
        this.originalNodeOrder = new LNode[layerCount][];
        ListIterator<Layer> layerIter = graph.getLayers().listIterator();
        while (layerIter.hasNext()) {
            Layer layer = layerIter.next();
            int layerNodeCount = layer.getNodes().size();
            assert (layerNodeCount > 0);
            int layerIndex = layerIter.previousIndex();
            this.bestNodeOrder[layerIndex] = new LNode[layerNodeCount];
            this.currentNodeOrder[layerIndex] = new LNode[layerNodeCount];
            this.originalNodeOrder[layerIndex] = new LNode[layerNodeCount];
            ListIterator<LNode> nodeIter = layer.getNodes().listIterator();
            int id = 0;
            while (nodeIter.hasNext()) {
                LNode node = nodeIter.next();
                node.id = id++;
                this.currentNodeOrder[layerIndex][nodeIter.previousIndex()] = node;
                this.bestNodeOrder[layerIndex][nodeIter.previousIndex()] = node;
                this.originalNodeOrder[layerIndex][nodeIter.previousIndex()] = node;
            }
        }
        this.crossingCounter = new AllCrossingsCounter(this.currentNodeOrder);
        if (this.greedySwitchType.useHyperedgeCounter()) {
            this.crossingCounter.useHyperedgeCounter();
        }
    }
}

