/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.intermediate.greedyswitch;

import com.google.common.collect.BoundType;
import com.google.common.collect.Sets;
import com.google.common.collect.SortedMultiset;
import com.google.common.collect.TreeMultiset;
import com.google.common.primitives.Ints;
import de.cau.cs.kieler.kiml.options.LayoutOptions;
import de.cau.cs.kieler.kiml.options.PortConstraints;
import de.cau.cs.kieler.kiml.options.PortSide;
import de.cau.cs.kieler.klay.layered.graph.LEdge;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.graph.LPort;
import de.cau.cs.kieler.klay.layered.graph.Layer;
import de.cau.cs.kieler.klay.layered.intermediate.greedyswitch.PortIterable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class InLayerEdgeAllCrossingsCounter {
    private final int[] eastNodeCardinalities;
    private final int[] westNodeCardinalities;
    private int[] portPositions;
    private final LNode[] nodeOrder;
    private final SortedMultiset<Integer> inLayerPorts;
    private final Set<LEdge> inLayerEdges;

    public InLayerEdgeAllCrossingsCounter(LNode[] nodeOrder) {
        this.eastNodeCardinalities = new int[nodeOrder.length];
        this.westNodeCardinalities = new int[nodeOrder.length];
        this.inLayerEdges = Sets.newHashSet();
        this.inLayerPorts = TreeMultiset.create();
        this.nodeOrder = nodeOrder;
        this.initializeLayer(nodeOrder);
    }

    private void initializeLayer(LNode[] layer) {
        ArrayList<Integer> pPositions = new ArrayList<Integer>();
        int portId = 0;
        portId = this.initializeSide(layer, pPositions, PortSide.EAST, portId, this.eastNodeCardinalities);
        portId = this.initializeSide(layer, pPositions, PortSide.WEST, portId, this.westNodeCardinalities);
        this.portPositions = Ints.toArray(pPositions);
    }

    private int initializeSide(LNode[] layer, List<Integer> pPositions, PortSide side, int portId, int[] nodeCardinalities) {
        int currentPortId = portId;
        int portPos = 0;
        int i = 0;
        while (i < layer.length) {
            LNode node = layer[i];
            node.id = i;
            int cardinality = 0;
            boolean hasPorts = false;
            Iterable<LPort> ports = PortIterable.inNorthSouthEastWestOrder(node, side);
            for (LPort port : ports) {
                hasPorts = true;
                port.id = currentPortId++;
                pPositions.add(portPos);
                if (!this.portOrderIsFixedFor(node) && port.getDegree() <= 1) continue;
                ++cardinality;
                ++portPos;
            }
            if (!this.portOrderIsFixedFor(node) && hasPorts) {
                ++portPos;
            }
            nodeCardinalities[node.id] = ++cardinality;
            ++i;
        }
        return currentPortId;
    }

    private boolean portOrderIsFixedFor(LNode node) {
        return ((PortConstraints)node.getProperty(LayoutOptions.PORT_CONSTRAINTS)).isOrderFixed();
    }

    public int countCrossings() {
        int crossings = 0;
        crossings = this.iterateEdgesTopDownAndCountCrossingsOnSide(PortSide.WEST);
        return crossings += this.iterateEdgesTopDownAndCountCrossingsOnSide(PortSide.EAST);
    }

    private int iterateEdgesTopDownAndCountCrossingsOnSide(PortSide portSide) {
        int crossings = 0;
        LNode[] lNodeArray = this.nodeOrder;
        int n = this.nodeOrder.length;
        int n2 = 0;
        while (n2 < n) {
            LNode node = lNodeArray[n2];
            Iterable<LPort> ports = PortIterable.inNorthSouthEastWestOrder(node, portSide);
            for (LPort port : ports) {
                for (LEdge edge : port.getConnectedEdges()) {
                    if (edge.isSelfLoop()) continue;
                    crossings += this.countCrossingsOn(edge, port);
                }
            }
            ++n2;
        }
        return crossings;
    }

    protected int countCrossingsOn(LEdge edge, LPort port) {
        int crossings = 0;
        if (this.isInLayer(edge)) {
            if (this.notVisited(edge)) {
                this.add(edge);
            } else {
                this.remove(edge);
                crossings += this.numberOfPortsInBetweenEndsOf(edge, this.inLayerPorts);
            }
        } else {
            int portsOnNodeWithFreePortOrder = this.inLayerPorts.count((Object)this.positionOf(port));
            crossings += this.inLayerEdges.size() - portsOnNodeWithFreePortOrder;
        }
        return crossings;
    }

    private boolean notVisited(LEdge edge) {
        return !this.inLayerEdges.contains((Object)edge);
    }

    private int numberOfPortsInBetweenEndsOf(LEdge edge, SortedMultiset<Integer> set) {
        int lowerBound = Math.min(this.positionOf(edge.getTarget()), this.positionOf(edge.getSource()));
        int upperBound = Math.max(this.positionOf(edge.getTarget()), this.positionOf(edge.getSource()));
        return set.subMultiset((Object)lowerBound, BoundType.OPEN, (Object)upperBound, BoundType.OPEN).size();
    }

    private void remove(LEdge edge) {
        this.inLayerPorts.remove((Object)this.positionOf(edge.getSource()));
        this.inLayerPorts.remove((Object)this.positionOf(edge.getTarget()));
        this.inLayerEdges.remove((Object)edge);
    }

    private void add(LEdge edge) {
        this.inLayerEdges.add(edge);
        this.inLayerPorts.add((Object)this.positionOf(edge.getSource()));
        this.inLayerPorts.add((Object)this.positionOf(edge.getTarget()));
    }

    protected boolean isInLayer(LEdge edge) {
        Layer targetLayer;
        Layer sourceLayer = edge.getSource().getNode().getLayer();
        return sourceLayer == (targetLayer = edge.getTarget().getNode().getLayer());
    }

    protected int positionOf(LPort port) {
        return this.portPositions[port.id];
    }

    public void notifyOfSwitch(LNode wasUpperNode, LNode wasLowerNode) {
        this.updatePortIds(wasUpperNode, wasLowerNode, PortSide.EAST, this.eastNodeCardinalities);
        this.updatePortIds(wasUpperNode, wasLowerNode, PortSide.WEST, this.westNodeCardinalities);
    }

    private void updatePortIds(LNode firstNode, LNode secondNode, PortSide side, int[] cardinalities) {
        Iterable<LPort> ports = PortIterable.inNorthSouthEastWestOrder(firstNode, side);
        for (LPort port : ports) {
            this.portPositions[port.id] = this.positionOf(port) + cardinalities[secondNode.id];
        }
        ports = PortIterable.inNorthSouthEastWestOrder(secondNode, side);
        for (LPort port : ports) {
            this.portPositions[port.id] = this.positionOf(port) - cardinalities[firstNode.id];
        }
    }

    protected int[] getPortPositions() {
        return this.portPositions;
    }
}

