/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.intermediate.greedyswitch;

import com.google.common.collect.Lists;
import de.cau.cs.kieler.kiml.options.PortSide;
import de.cau.cs.kieler.klay.layered.graph.LEdge;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.graph.LPort;
import de.cau.cs.kieler.klay.layered.intermediate.greedyswitch.ComparableEdgeAndPort;
import de.cau.cs.kieler.klay.layered.intermediate.greedyswitch.InLayerEdgeAllCrossingsCounter;
import de.cau.cs.kieler.klay.layered.intermediate.greedyswitch.PortIterable;
import java.util.Collections;
import java.util.List;

public class InLayerEdgeTwoNodeCrossingCounter
extends InLayerEdgeAllCrossingsCounter {
    private final List<ComparableEdgeAndPort> relevantEdgesAndPorts = Lists.newArrayList();
    private int upperLowerCrossings;
    private int lowerUpperCrossings;
    private LNode upperNode;
    private LNode lowerNode;

    public InLayerEdgeTwoNodeCrossingCounter(LNode[] nodeOrder) {
        super(nodeOrder);
    }

    public void countCrossingsBetweenNodes(LNode upper, LNode lower) {
        this.upperNode = upper;
        this.lowerNode = lower;
        this.upperLowerCrossings = this.countCrossingsOnSide(PortSide.EAST);
        this.upperLowerCrossings += this.countCrossingsOnSide(PortSide.WEST);
        this.notifyOfSwitch(upper, lower);
        this.lowerUpperCrossings = this.countCrossingsOnSide(PortSide.EAST);
        this.lowerUpperCrossings += this.countCrossingsOnSide(PortSide.WEST);
        this.notifyOfSwitch(lower, upper);
    }

    private int countCrossingsOnSide(PortSide side) {
        this.relevantEdgesAndPorts.clear();
        this.addEdgesAndPortsConnectedToNodesAndSort(side);
        return this.iterateThroughRelevantEdgesAndPortsAndCountCrossings();
    }

    private void addEdgesAndPortsConnectedToNodesAndSort(PortSide side) {
        this.iterateThroughEdgesAndCollectThem(this.upperNode, side);
        this.iterateThroughEdgesAndCollectThem(this.lowerNode, side);
        Collections.sort(this.relevantEdgesAndPorts);
    }

    private void iterateThroughEdgesAndCollectThem(LNode node, PortSide side) {
        Iterable<LPort> ports = PortIterable.inNorthSouthEastWestOrder(node, side);
        for (LPort port : ports) {
            for (LEdge edge : port.getConnectedEdges()) {
                if (edge.isSelfLoop()) continue;
                this.addThisEndOrBothEndsOfEdge(node, port, edge);
            }
        }
    }

    private int iterateThroughRelevantEdgesAndPortsAndCountCrossings() {
        int crossings = 0;
        for (ComparableEdgeAndPort eP : this.relevantEdgesAndPorts) {
            crossings += super.countCrossingsOn(eP.getEdge(), eP.getPort());
        }
        return crossings;
    }

    private void addThisEndOrBothEndsOfEdge(LNode node, LPort port, LEdge edge) {
        if (this.isInLayer(edge)) {
            this.relevantEdgesAndPorts.add(new ComparableEdgeAndPort(port, edge, this.getPortPositions()));
        }
        if (this.isInLayer(edge) && this.notConnectedToOtherNode(edge, node)) {
            LPort otherEnd = this.otherEndOf(edge, port);
            this.relevantEdgesAndPorts.add(new ComparableEdgeAndPort(otherEnd, edge, this.getPortPositions()));
        }
    }

    private boolean notConnectedToOtherNode(LEdge edge, LNode node) {
        if (((Object)((Object)node)).equals((Object)this.upperNode)) {
            return !((Object)((Object)edge.getTarget().getNode())).equals((Object)this.lowerNode) && !((Object)((Object)edge.getSource().getNode())).equals((Object)this.lowerNode);
        }
        return !((Object)((Object)edge.getTarget().getNode())).equals((Object)this.upperNode) && !((Object)((Object)edge.getSource().getNode())).equals((Object)this.upperNode);
    }

    public int getUpperLowerCrossings() {
        return this.upperLowerCrossings;
    }

    public int getLowerUpperCrossings() {
        return this.lowerUpperCrossings;
    }

    private LPort otherEndOf(LEdge edge, LPort fromPort) {
        return fromPort == edge.getSource() ? edge.getTarget() : edge.getSource();
    }
}

