/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.networksimplex;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import de.cau.cs.kieler.core.kgraph.KEdge;
import de.cau.cs.kieler.core.kgraph.KLabel;
import de.cau.cs.kieler.core.kgraph.KLabeledGraphElement;
import de.cau.cs.kieler.core.kgraph.KNode;
import de.cau.cs.kieler.kiml.klayoutdata.KLayoutData;
import de.cau.cs.kieler.kiml.options.Direction;
import de.cau.cs.kieler.kiml.options.LayoutOptions;
import de.cau.cs.kieler.kiml.util.KimlUtil;
import de.cau.cs.kieler.klay.layered.networksimplex.NEdge;
import de.cau.cs.kieler.klay.layered.networksimplex.NNode;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;

public class NGraph {
    public List<NNode> nodes = Lists.newArrayList();

    public void writeDebugGraph(String filePath) {
        KNode root = KimlUtil.createInitializedNode();
        ((KLayoutData)root.getData(KLayoutData.class)).setProperty(LayoutOptions.DIRECTION, (Object)Direction.DOWN);
        HashMap nodeMap = Maps.newHashMap();
        for (NNode nNode : this.nodes) {
            KNode kNode = KimlUtil.createInitializedNode();
            root.getChildren().add((Object)kNode);
            nodeMap.put(nNode, kNode);
            KLabel label = KimlUtil.createInitializedLabel((KLabeledGraphElement)kNode);
            label.setText(String.valueOf(nNode.type) + " " + nNode.layer);
        }
        for (NNode nNode : this.nodes) {
            for (NEdge nEdge : nNode.getOutgoingEdges()) {
                KEdge kEdge = KimlUtil.createInitializedEdge();
                kEdge.setSource((KNode)nodeMap.get(nEdge.source));
                kEdge.setTarget((KNode)nodeMap.get(nEdge.target));
                KLabel label = KimlUtil.createInitializedLabel((KLabeledGraphElement)kEdge);
                label.setText(String.valueOf(nEdge.weight) + " " + nEdge.delta);
            }
        }
        ResourceSetImpl rs = new ResourceSetImpl();
        Resource r = rs.createResource(URI.createFileURI((String)filePath));
        r.getContents().add((Object)root);
        try {
            r.save(Collections.emptyMap());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * Unable to fully structure code
     */
    public boolean isAcyclic() {
        id = 0;
        for (NNode n : this.nodes) {
            n.id = id++;
        }
        incident = new int[this.nodes.size()];
        layer = new int[this.nodes.size()];
        for (NNode node : this.nodes) {
            v0 = node.id;
            incident[v0] = incident[v0] + node.getIncomingEdges().size();
        }
        roots = Lists.newLinkedList();
        for (NNode node : this.nodes) {
            if (!node.getIncomingEdges().isEmpty()) continue;
            roots.add(node);
        }
        if (!roots.isEmpty() || this.nodes.isEmpty()) ** GOTO lbl29
        return false;
lbl-1000:
        // 1 sources

        {
            node = (NNode)roots.poll();
            for (NEdge edge : node.getOutgoingEdges()) {
                target = edge.getTarget();
                layer[target.id] = Math.max(layer[target.id], layer[node.id] + 1);
                v1 = target.id;
                incident[v1] = incident[v1] - 1;
                if (incident[target.id] != 0) continue;
                roots.add(target);
            }
lbl29:
            // 2 sources

            ** while (!roots.isEmpty())
        }
lbl30:
        // 2 sources

        for (NNode node : this.nodes) {
            for (NEdge edge : node.getOutgoingEdges()) {
                if (layer[edge.target.id] > layer[edge.source.id]) continue;
                return false;
            }
        }
        return true;
    }
}

