/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.networksimplex;

import com.google.common.collect.Lists;
import de.cau.cs.kieler.klay.layered.networksimplex.NEdge;
import de.cau.cs.kieler.klay.layered.networksimplex.NGraph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public final class NNode {
    public int id;
    public Object origin;
    public String type = "";
    public int layer;
    private ChangeAwareArrayList<NEdge> outgoingEdges = new ChangeAwareArrayList();
    private int outgoingEdgesModCnt = -1;
    private ChangeAwareArrayList<NEdge> incomingEdges = new ChangeAwareArrayList();
    private int incomingEdgesModCnt = -1;
    private ArrayList<NEdge> allEdges = Lists.newArrayList();
    protected boolean treeNode = false;
    protected Collection<NEdge> unknownCutvalues = Lists.newArrayList();

    private NNode() {
    }

    public static NNodeBuilder of() {
        return new NNodeBuilder();
    }

    public List<NEdge> getOutgoingEdges() {
        return this.outgoingEdges;
    }

    public List<NEdge> getIncomingEdges() {
        return this.incomingEdges;
    }

    public List<NEdge> getConnectedEdges() {
        if (this.incomingEdgesModCnt != this.incomingEdges.getModCnt() || this.outgoingEdgesModCnt != this.outgoingEdges.getModCnt()) {
            this.allEdges.clear();
            this.allEdges.ensureCapacity(this.incomingEdges.size() + this.outgoingEdges.size());
            this.allEdges.addAll(this.incomingEdges);
            this.allEdges.addAll(this.outgoingEdges);
            this.incomingEdgesModCnt = this.incomingEdges.getModCnt();
            this.outgoingEdgesModCnt = this.outgoingEdges.getModCnt();
        }
        return this.allEdges;
    }

    private static class ChangeAwareArrayList<E>
    extends ArrayList<E> {
        private static final long serialVersionUID = 7137934731310022891L;

        private ChangeAwareArrayList() {
        }

        private int getModCnt() {
            return this.modCount;
        }
    }

    public static final class NNodeBuilder {
        private NNode node = new NNode();

        private NNodeBuilder() {
        }

        public NNodeBuilder id(int id) {
            this.node.id = id;
            return this;
        }

        public NNodeBuilder origin(Object origin) {
            this.node.origin = origin;
            return this;
        }

        public NNodeBuilder type(String type) {
            this.node.type = type;
            return this;
        }

        public NNode create(NGraph graph) {
            graph.nodes.add(this.node);
            return this.node;
        }
    }
}

