/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.p1cycles;

import com.google.common.collect.Lists;
import de.cau.cs.kieler.core.alg.IKielerProgressMonitor;
import de.cau.cs.kieler.klay.layered.ILayoutPhase;
import de.cau.cs.kieler.klay.layered.IntermediateProcessingConfiguration;
import de.cau.cs.kieler.klay.layered.graph.LEdge;
import de.cau.cs.kieler.klay.layered.graph.LGraph;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.graph.LPort;
import de.cau.cs.kieler.klay.layered.intermediate.IntermediateProcessorStrategy;
import de.cau.cs.kieler.klay.layered.properties.PortType;
import java.util.ArrayList;
import java.util.List;

public final class InteractiveCycleBreaker
implements ILayoutPhase {
    private static final IntermediateProcessingConfiguration INTERMEDIATE_PROCESSING_CONFIGURATION = IntermediateProcessingConfiguration.createEmpty().addBeforePhase1(IntermediateProcessorStrategy.INTERACTIVE_EXTERNAL_PORT_POSITIONER).addAfterPhase5(IntermediateProcessorStrategy.REVERSED_EDGE_RESTORER);

    @Override
    public IntermediateProcessingConfiguration getIntermediateProcessingConfiguration(LGraph graph) {
        return INTERMEDIATE_PROCESSING_CONFIGURATION;
    }

    @Override
    public void process(LGraph layeredGraph, IKielerProgressMonitor monitor) {
        monitor.begin("Interactive cycle breaking", 1.0f);
        ArrayList revEdges = Lists.newArrayList();
        for (LNode source : layeredGraph.getLayerlessNodes()) {
            source.id = 1;
            double sourcex = source.getInteractiveReferencePoint().x;
            for (LPort port : source.getPorts(PortType.OUTPUT)) {
                for (LEdge edge : port.getOutgoingEdges()) {
                    double targetx;
                    LNode target = edge.getTarget().getNode();
                    if (target == source || !((targetx = target.getInteractiveReferencePoint().x) < sourcex)) continue;
                    revEdges.add(edge);
                }
            }
        }
        for (LEdge edge : revEdges) {
            edge.reverse(layeredGraph, true);
        }
        revEdges.clear();
        for (LNode node : layeredGraph.getLayerlessNodes()) {
            if (node.id <= 0) continue;
            this.findCycles(node, revEdges);
        }
        for (LEdge edge : revEdges) {
            edge.reverse(layeredGraph, true);
        }
        revEdges.clear();
        monitor.done();
    }

    private void findCycles(LNode node1, List<LEdge> revEdges) {
        node1.id = -1;
        for (LPort port : node1.getPorts(PortType.OUTPUT)) {
            for (LEdge edge : port.getOutgoingEdges()) {
                LNode node2 = edge.getTarget().getNode();
                if (node1 == node2) continue;
                if (node2.id < 0) {
                    revEdges.add(edge);
                    continue;
                }
                if (node2.id <= 0) continue;
                this.findCycles(node2, revEdges);
            }
        }
        node1.id = 0;
    }
}

