/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.p2layers;

import de.cau.cs.kieler.core.alg.IKielerProgressMonitor;
import de.cau.cs.kieler.klay.layered.ILayoutPhase;
import de.cau.cs.kieler.klay.layered.IntermediateProcessingConfiguration;
import de.cau.cs.kieler.klay.layered.graph.LEdge;
import de.cau.cs.kieler.klay.layered.graph.LGraph;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.graph.LPort;
import de.cau.cs.kieler.klay.layered.graph.Layer;
import de.cau.cs.kieler.klay.layered.intermediate.IntermediateProcessorStrategy;
import de.cau.cs.kieler.klay.layered.properties.Properties;
import de.cau.cs.kieler.klay.layered.properties.WideNodesStrategy;
import java.util.List;

public final class LongestPathLayerer
implements ILayoutPhase {
    private static final IntermediateProcessingConfiguration BASELINE_PROCESSING_CONFIGURATION = IntermediateProcessingConfiguration.createEmpty().addBeforePhase1(IntermediateProcessorStrategy.EDGE_AND_LAYER_CONSTRAINT_EDGE_REVERSER).addBeforePhase3(IntermediateProcessorStrategy.LAYER_CONSTRAINT_PROCESSOR);
    private static final IntermediateProcessingConfiguration BIG_NODES_PROCESSING_ADDITIONS_AGGRESSIVE = IntermediateProcessingConfiguration.createEmpty().addBeforePhase2(IntermediateProcessorStrategy.BIG_NODES_PREPROCESSOR).addBeforePhase3(IntermediateProcessorStrategy.BIG_NODES_INTERMEDIATEPROCESSOR).addAfterPhase5(IntermediateProcessorStrategy.BIG_NODES_POSTPROCESSOR);
    private static final IntermediateProcessingConfiguration BIG_NODES_PROCESSING_ADDITIONS_CAREFUL = IntermediateProcessingConfiguration.createEmpty().addBeforePhase4(IntermediateProcessorStrategy.BIG_NODES_SPLITTER).addAfterPhase5(IntermediateProcessorStrategy.BIG_NODES_POSTPROCESSOR);
    private LGraph layeredGraph;
    private int[] nodeHeights;

    @Override
    public IntermediateProcessingConfiguration getIntermediateProcessingConfiguration(LGraph graph) {
        IntermediateProcessingConfiguration strategy = IntermediateProcessingConfiguration.fromExisting(BASELINE_PROCESSING_CONFIGURATION);
        if (((Boolean)graph.getProperty(Properties.DISTRIBUTE_NODES)).booleanValue() || graph.getProperty(Properties.WIDE_NODES_ON_MULTIPLE_LAYERS) == WideNodesStrategy.AGGRESSIVE) {
            strategy.addAll(BIG_NODES_PROCESSING_ADDITIONS_AGGRESSIVE);
        } else if (graph.getProperty(Properties.WIDE_NODES_ON_MULTIPLE_LAYERS) == WideNodesStrategy.CAREFUL) {
            strategy.addAll(BIG_NODES_PROCESSING_ADDITIONS_CAREFUL);
        }
        if (((Boolean)graph.getProperty(Properties.SAUSAGE_FOLDING)).booleanValue()) {
            strategy.addBeforePhase4(IntermediateProcessorStrategy.SAUSAGE_COMPACTION);
        }
        return strategy;
    }

    @Override
    public void process(LGraph thelayeredGraph, IKielerProgressMonitor monitor) {
        monitor.begin("Longest path layering", 1.0f);
        this.layeredGraph = thelayeredGraph;
        List<LNode> nodes = this.layeredGraph.getLayerlessNodes();
        this.nodeHeights = new int[nodes.size()];
        int index = 0;
        for (LNode node : nodes) {
            node.id = index;
            this.nodeHeights[index] = -1;
            ++index;
        }
        for (LNode node : nodes) {
            this.visit(node);
        }
        nodes.clear();
        this.layeredGraph = null;
        this.nodeHeights = null;
        monitor.done();
    }

    private int visit(LNode node) {
        int height = this.nodeHeights[node.id];
        if (height >= 0) {
            return height;
        }
        int maxHeight = 1;
        for (LPort port : node.getPorts()) {
            for (LEdge edge : port.getOutgoingEdges()) {
                LNode targetNode = edge.getTarget().getNode();
                if (node == targetNode) continue;
                int targetHeight = this.visit(targetNode);
                maxHeight = Math.max(maxHeight, targetHeight + 1);
            }
        }
        this.putNode(node, maxHeight);
        return maxHeight;
    }

    private void putNode(LNode node, int height) {
        List<Layer> layers = this.layeredGraph.getLayers();
        int i = layers.size();
        while (i < height) {
            layers.add(0, new Layer(this.layeredGraph));
            ++i;
        }
        node.setLayer(layers.get(layers.size() - height));
        this.nodeHeights[node.id] = height;
    }
}

