/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.p2layers;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import de.cau.cs.kieler.core.alg.IKielerProgressMonitor;
import de.cau.cs.kieler.klay.layered.ILayoutPhase;
import de.cau.cs.kieler.klay.layered.IntermediateProcessingConfiguration;
import de.cau.cs.kieler.klay.layered.graph.LEdge;
import de.cau.cs.kieler.klay.layered.graph.LGraph;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.graph.LPort;
import de.cau.cs.kieler.klay.layered.graph.Layer;
import de.cau.cs.kieler.klay.layered.intermediate.IntermediateProcessorStrategy;
import de.cau.cs.kieler.klay.layered.networksimplex.NEdge;
import de.cau.cs.kieler.klay.layered.networksimplex.NGraph;
import de.cau.cs.kieler.klay.layered.networksimplex.NNode;
import de.cau.cs.kieler.klay.layered.networksimplex.NetworkSimplex;
import de.cau.cs.kieler.klay.layered.properties.InternalProperties;
import de.cau.cs.kieler.klay.layered.properties.Properties;
import de.cau.cs.kieler.klay.layered.properties.WideNodesStrategy;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public final class NetworkSimplexLayerer
implements ILayoutPhase {
    private static final IntermediateProcessingConfiguration BASELINE_PROCESSING_CONFIGURATION = IntermediateProcessingConfiguration.createEmpty().addBeforePhase1(IntermediateProcessorStrategy.EDGE_AND_LAYER_CONSTRAINT_EDGE_REVERSER).addBeforePhase3(IntermediateProcessorStrategy.LAYER_CONSTRAINT_PROCESSOR);
    private static final IntermediateProcessingConfiguration BIG_NODES_PROCESSING_ADDITIONS_AGGRESSIVE = IntermediateProcessingConfiguration.createEmpty().addBeforePhase2(IntermediateProcessorStrategy.BIG_NODES_PREPROCESSOR).addBeforePhase3(IntermediateProcessorStrategy.BIG_NODES_INTERMEDIATEPROCESSOR).addAfterPhase5(IntermediateProcessorStrategy.BIG_NODES_POSTPROCESSOR);
    private static final IntermediateProcessingConfiguration BIG_NODES_PROCESSING_ADDITIONS_CAREFUL = IntermediateProcessingConfiguration.createEmpty().addBeforePhase4(IntermediateProcessorStrategy.BIG_NODES_SPLITTER).addAfterPhase5(IntermediateProcessorStrategy.BIG_NODES_POSTPROCESSOR);
    private LGraph layeredGraph;
    private List<LNode> componentNodes;
    private boolean[] nodeVisited;
    private WideNodesStrategy wideNodesStrategy = WideNodesStrategy.OFF;
    private static final int ITER_LIMIT_FACTOR = 4;

    @Override
    public IntermediateProcessingConfiguration getIntermediateProcessingConfiguration(LGraph graph) {
        IntermediateProcessingConfiguration strategy = IntermediateProcessingConfiguration.fromExisting(BASELINE_PROCESSING_CONFIGURATION);
        if (((Boolean)graph.getProperty(Properties.DISTRIBUTE_NODES)).booleanValue() || graph.getProperty(Properties.WIDE_NODES_ON_MULTIPLE_LAYERS) == WideNodesStrategy.AGGRESSIVE) {
            strategy.addAll(BIG_NODES_PROCESSING_ADDITIONS_AGGRESSIVE);
            this.wideNodesStrategy = WideNodesStrategy.AGGRESSIVE;
        } else if (graph.getProperty(Properties.WIDE_NODES_ON_MULTIPLE_LAYERS) == WideNodesStrategy.CAREFUL) {
            strategy.addAll(BIG_NODES_PROCESSING_ADDITIONS_CAREFUL);
            this.wideNodesStrategy = WideNodesStrategy.CAREFUL;
        }
        return strategy;
    }

    private List<List<LNode>> connectedComponents(List<LNode> theNodes) {
        if (this.nodeVisited == null || this.nodeVisited.length < theNodes.size()) {
            this.nodeVisited = new boolean[theNodes.size()];
        } else {
            Arrays.fill(this.nodeVisited, false);
        }
        this.componentNodes = Lists.newArrayList();
        int counter = 0;
        for (LNode node : theNodes) {
            node.id = counter++;
        }
        LinkedList components = Lists.newLinkedList();
        for (LNode node : theNodes) {
            if (this.nodeVisited[node.id]) continue;
            this.connectedComponentsDFS(node);
            if (components.isEmpty() || ((List)components.getFirst()).size() < this.componentNodes.size()) {
                components.addFirst(this.componentNodes);
            } else {
                components.addLast(this.componentNodes);
            }
            this.componentNodes = Lists.newArrayList();
        }
        return components;
    }

    private void connectedComponentsDFS(LNode node) {
        this.nodeVisited[node.id] = true;
        this.componentNodes.add(node);
        for (LPort port : node.getPorts()) {
            for (LEdge edge : port.getConnectedEdges()) {
                LNode opposite = this.getOpposite(port, edge).getNode();
                if (this.nodeVisited[opposite.id]) continue;
                this.connectedComponentsDFS(opposite);
            }
        }
    }

    private NGraph initialize(List<LNode> theNodes) {
        HashMap nodeMap = Maps.newHashMap();
        int counter = 0;
        NGraph graph = new NGraph();
        for (LNode lNode : theNodes) {
            NNode nNode = NNode.of().id(counter++).origin((Object)lNode).create(graph);
            nodeMap.put(lNode, nNode);
        }
        for (LNode lNode : theNodes) {
            for (LEdge lEdge : lNode.getOutgoingEdges()) {
                if (lEdge.isSelfLoop()) continue;
                NEdge.of((Object)lEdge).weight(1 * Math.max(1, (Integer)lEdge.getProperty(InternalProperties.PRIORITY))).delta(1).source((NNode)nodeMap.get((Object)lEdge.getSource().getNode())).target((NNode)nodeMap.get((Object)lEdge.getTarget().getNode())).create();
            }
        }
        return graph;
    }

    private void dispose() {
        this.componentNodes = null;
        this.layeredGraph = null;
        this.nodeVisited = null;
    }

    @Override
    public void process(LGraph theLayeredGraph, IKielerProgressMonitor monitor) {
        monitor.begin("Network simplex layering", 1.0f);
        this.layeredGraph = theLayeredGraph;
        int thoroughness = (Integer)theLayeredGraph.getProperty(Properties.THOROUGHNESS) * 4;
        List<LNode> theNodes = this.layeredGraph.getLayerlessNodes();
        if (theNodes.size() < 1) {
            monitor.done();
            return;
        }
        for (List<LNode> connComp : this.connectedComponents(theNodes)) {
            int iterLimit = thoroughness * (int)Math.sqrt(connComp.size());
            NGraph graph = this.initialize(connComp);
            NetworkSimplex.forGraph(graph).withIterationLimit(iterLimit).withPreviousLayering(this.layeredGraph).withBalancing(this.wideNodesStrategy == WideNodesStrategy.AGGRESSIVE).execute(monitor.subTask(1.0f));
            List<Layer> layers = this.layeredGraph.getLayers();
            for (NNode nNode : graph.nodes) {
                while (layers.size() <= nNode.layer) {
                    layers.add(layers.size(), new Layer(this.layeredGraph));
                }
                LNode lNode = (LNode)((Object)nNode.origin);
                lNode.setLayer(layers.get(nNode.layer));
            }
        }
        theNodes.clear();
        this.dispose();
        monitor.done();
    }

    private LPort getOpposite(LPort port, LEdge edge) {
        if (((Object)((Object)edge.getSource())).equals((Object)port)) {
            return edge.getTarget();
        }
        if (((Object)((Object)edge.getTarget())).equals((Object)port)) {
            return edge.getSource();
        }
        throw new IllegalArgumentException("Input edge is not connected to the input port.");
    }
}

