/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.p3order;

import de.cau.cs.kieler.kiml.options.LayoutOptions;
import de.cau.cs.kieler.kiml.options.PortConstraints;
import de.cau.cs.kieler.kiml.options.PortSide;
import de.cau.cs.kieler.klay.layered.graph.LEdge;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.graph.LPort;
import de.cau.cs.kieler.klay.layered.graph.Layer;
import de.cau.cs.kieler.klay.layered.p3order.AbstractCrossingsCounter;
import de.cau.cs.kieler.klay.layered.p3order.NodeGroup;
import java.util.Iterator;

public class BarthJuengerMutzelCrossingsCounter
extends AbstractCrossingsCounter {
    private final int[] portPos;

    public BarthJuengerMutzelCrossingsCounter(int[] inLayerEdgeCount, boolean[] hasNorthSouthPorts, int[] portPos) {
        super(inLayerEdgeCount, hasNorthSouthPorts);
        this.portPos = portPos;
    }

    @Override
    public int countCrossings(NodeGroup[] leftLayer, NodeGroup[] rightLayer) {
        int targetCount = 0;
        int edgeCount = 0;
        Layer leftLayerRef = leftLayer[0].getNode().getLayer();
        Layer rightLayerRef = rightLayer[0].getNode().getLayer();
        NodeGroup[] nodeGroupArray = rightLayer;
        int n = rightLayer.length;
        int n2 = 0;
        while (n2 < n) {
            NodeGroup nodeGroup = nodeGroupArray[n2];
            LNode node = nodeGroup.getNode();
            assert (node.getLayer() == rightLayerRef);
            if (((PortConstraints)node.getProperty(LayoutOptions.PORT_CONSTRAINTS)).isOrderFixed()) {
                int northInputPorts = 0;
                block1: for (LPort port : node.getPorts()) {
                    if (port.getSide() != PortSide.NORTH) break;
                    for (LEdge lEdge : port.getIncomingEdges()) {
                        if (lEdge.getSource().getNode().getLayer() != leftLayerRef) continue;
                        ++northInputPorts;
                        continue block1;
                    }
                }
                int otherInputPorts = 0;
                Iterator<LPort> portIter = node.getPorts().listIterator(node.getPorts().size());
                while (portIter.hasPrevious()) {
                    LPort lPort = (LPort)((Object)portIter.previous());
                    int portEdges = 0;
                    for (LEdge edge : lPort.getIncomingEdges()) {
                        if (edge.getSource().getNode().getLayer() != leftLayerRef) continue;
                        ++portEdges;
                    }
                    if (portEdges <= 0) continue;
                    if (lPort.getSide() == PortSide.NORTH) {
                        this.portPos[lPort.id] = targetCount++;
                    } else {
                        this.portPos[lPort.id] = targetCount + northInputPorts + otherInputPorts;
                        ++otherInputPorts;
                    }
                    edgeCount += portEdges;
                }
                targetCount += otherInputPorts;
            } else {
                int nodeEdges = 0;
                for (LPort port : node.getPorts()) {
                    for (LEdge lEdge : port.getIncomingEdges()) {
                        if (lEdge.getSource().getNode().getLayer() != leftLayerRef) continue;
                        ++nodeEdges;
                    }
                    this.portPos[port.id] = targetCount;
                }
                if (nodeEdges > 0) {
                    ++targetCount;
                    edgeCount += nodeEdges;
                }
            }
            ++n2;
        }
        int[] southSequence = new int[edgeCount];
        int i = 0;
        NodeGroup[] nodeEdges = leftLayer;
        int node = leftLayer.length;
        int n3 = 0;
        while (n3 < node) {
            NodeGroup nodeGroup = nodeEdges[n3];
            LNode node2 = nodeGroup.getNode();
            assert (node2.getLayer() == leftLayerRef);
            if (((PortConstraints)node2.getProperty(LayoutOptions.PORT_CONSTRAINTS)).isOrderFixed()) {
                for (LPort port : node2.getPorts()) {
                    int start = i;
                    for (LEdge edge : port.getOutgoingEdges()) {
                        target = edge.getTarget();
                        if (target.getNode().getLayer() != rightLayerRef) continue;
                        assert (i < edgeCount);
                        BarthJuengerMutzelCrossingsCounter.insert(southSequence, start, i++, this.portPos[target.id]);
                    }
                }
            } else {
                int start = i;
                for (LPort lPort : node2.getPorts()) {
                    for (LEdge edge : lPort.getOutgoingEdges()) {
                        target = edge.getTarget();
                        if (target.getNode().getLayer() != rightLayerRef) continue;
                        assert (i < edgeCount);
                        BarthJuengerMutzelCrossingsCounter.insert(southSequence, start, i++, this.portPos[target.id]);
                    }
                }
            }
            ++n3;
        }
        int firstIndex = 1;
        while (firstIndex < targetCount) {
            firstIndex *= 2;
        }
        int treeSize = 2 * firstIndex - 1;
        --firstIndex;
        int[] tree = new int[treeSize];
        int crossCount = 0;
        int k = 0;
        while (k < edgeCount) {
            int index;
            int n4 = index = southSequence[k] + firstIndex;
            tree[n4] = tree[n4] + 1;
            while (index > 0) {
                if (index % 2 > 0) {
                    crossCount += tree[index + 1];
                }
                int n5 = index = (index - 1) / 2;
                tree[n5] = tree[n5] + 1;
            }
            ++k;
        }
        return crossCount;
    }

    private static void insert(int[] array, int start, int end, int n) {
        int insx = BarthJuengerMutzelCrossingsCounter.binarySearch(array, start, end, n);
        if (insx < 0) {
            insx = -insx - 1;
        }
        int j = end - 1;
        while (j >= insx) {
            array[j + 1] = array[j];
            --j;
        }
        array[insx] = n;
    }

    private static int binarySearch(int[] a, int fromIndex, int toIndex, int key) {
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            int midVal = a[mid];
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }
}

