/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.p3order;

import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.graph.LPort;
import de.cau.cs.kieler.klay.layered.p3order.IConstraintResolver;
import de.cau.cs.kieler.klay.layered.p3order.ICrossingMinimizationHeuristic;
import de.cau.cs.kieler.klay.layered.p3order.NodeGroup;
import de.cau.cs.kieler.klay.layered.properties.InternalProperties;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Random;

public final class BarycenterHeuristic
implements ICrossingMinimizationHeuristic {
    private final float[] portRanks;
    private final Random random;
    private final IConstraintResolver constraintResolver;
    private static final float RANDOM_AMOUNT = 0.07f;

    public BarycenterHeuristic(IConstraintResolver constraintResolver, Random graphRandom, float[] portRanks) {
        this.constraintResolver = constraintResolver;
        this.random = graphRandom;
        this.portRanks = portRanks;
    }

    @Override
    public void minimizeCrossings(List<NodeGroup> layer, boolean preOrdered, boolean randomize, boolean forward) {
        if (randomize) {
            this.randomizeBarycenters(layer);
        } else {
            this.calculateBarycenters(layer, forward);
            this.fillInUnknownBarycenters(layer, preOrdered);
        }
        if (layer.size() > 1) {
            Collections.sort(layer);
            this.constraintResolver.processConstraints(layer);
        }
    }

    private void randomizeBarycenters(List<NodeGroup> nodeGroups) {
        for (NodeGroup nodeGroup : nodeGroups) {
            if (nodeGroup.getNodes().length != 1) continue;
            nodeGroup.barycenter = this.random.nextDouble();
            nodeGroup.summedWeight = nodeGroup.barycenter;
            nodeGroup.degree = 1;
        }
    }

    private void fillInUnknownBarycenters(List<NodeGroup> nodeGroups, boolean preOrdered) {
        if (preOrdered) {
            double lastValue = -1.0;
            ListIterator<NodeGroup> nodeGroupIterator = nodeGroups.listIterator();
            while (nodeGroupIterator.hasNext()) {
                NodeGroup nodeGroup = nodeGroupIterator.next();
                Double value = nodeGroup.barycenter;
                if (value == null) {
                    double nextValue = lastValue + 1.0;
                    ListIterator<NodeGroup> nextNodeGroupIterator = nodeGroups.listIterator(nodeGroupIterator.nextIndex());
                    while (nextNodeGroupIterator.hasNext()) {
                        Double x = nextNodeGroupIterator.next().barycenter;
                        if (x == null) continue;
                        nextValue = x;
                        break;
                    }
                    nodeGroup.barycenter = value = Double.valueOf((lastValue + nextValue) / 2.0);
                    nodeGroup.summedWeight = value;
                    nodeGroup.degree = 1;
                }
                lastValue = value;
            }
        } else {
            double maxBary = 0.0;
            for (NodeGroup nodeGroup : nodeGroups) {
                if (nodeGroup.barycenter == null) continue;
                maxBary = Math.max(maxBary, nodeGroup.barycenter);
            }
            maxBary += 2.0;
            for (NodeGroup nodeGroup : nodeGroups) {
                if (nodeGroup.barycenter != null) continue;
                double value = (double)this.random.nextFloat() * maxBary - 1.0;
                nodeGroup.barycenter = value;
                nodeGroup.summedWeight = value;
                nodeGroup.degree = 1;
            }
        }
    }

    private void calculateBarycenters(List<NodeGroup> nodeGroups, boolean forward) {
        for (NodeGroup nodeGroup : nodeGroups) {
            nodeGroup.visited = false;
        }
        for (NodeGroup nodeGroup : nodeGroups) {
            if (nodeGroup.getNodes().length != 1) continue;
            this.calculateBarycenter(nodeGroup, forward);
        }
    }

    private void calculateBarycenter(NodeGroup nodeGroup, boolean forward) {
        if (nodeGroup.visited) {
            return;
        }
        nodeGroup.visited = true;
        nodeGroup.degree = 0;
        nodeGroup.summedWeight = 0.0;
        nodeGroup.barycenter = null;
        LNode node = nodeGroup.getNode();
        for (LPort freePort : node.getPorts()) {
            Iterable<LPort> portIterable = forward ? freePort.getPredecessorPorts() : freePort.getSuccessorPorts();
            for (LPort fixedPort : portIterable) {
                LNode fixedNode = fixedPort.getNode();
                if (fixedNode.getLayer() == node.getLayer()) {
                    if (fixedNode == node) continue;
                    NodeGroup fixedNodeGroup = (NodeGroup)fixedNode.getProperty(InternalProperties.NODE_GROUP);
                    this.calculateBarycenter(fixedNodeGroup, forward);
                    nodeGroup.degree += fixedNodeGroup.degree;
                    nodeGroup.summedWeight += fixedNodeGroup.summedWeight;
                    continue;
                }
                nodeGroup.summedWeight += (double)this.portRanks[fixedPort.id];
                ++nodeGroup.degree;
            }
        }
        List barycenterAssociates = (List)node.getProperty(InternalProperties.BARYCENTER_ASSOCIATES);
        if (barycenterAssociates != null) {
            for (LNode associate : barycenterAssociates) {
                if (node.getLayer() != associate.getLayer()) continue;
                NodeGroup associateNodeGroup = (NodeGroup)associate.getProperty(InternalProperties.NODE_GROUP);
                this.calculateBarycenter(associateNodeGroup, forward);
                nodeGroup.degree += associateNodeGroup.degree;
                nodeGroup.summedWeight += associateNodeGroup.summedWeight;
            }
        }
        if (nodeGroup.degree > 0) {
            nodeGroup.summedWeight += (double)(this.random.nextFloat() * 0.07f - 0.035f);
            nodeGroup.barycenter = nodeGroup.summedWeight / (double)nodeGroup.degree;
        }
    }
}

