/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.p3order;

import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import de.cau.cs.kieler.core.util.Pair;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.p3order.IConstraintResolver;
import de.cau.cs.kieler.klay.layered.p3order.NodeGroup;
import de.cau.cs.kieler.klay.layered.properties.InternalProperties;
import java.util.List;
import java.util.ListIterator;

public final class ForsterConstraintResolver
implements IConstraintResolver {
    private final Multimap<LNode, LNode> layoutUnits;
    private static final float BARYCENTER_EQUALITY_DELTA = 1.0E-4f;

    public ForsterConstraintResolver(Multimap<LNode, LNode> layoutUnits) {
        this.layoutUnits = layoutUnits;
    }

    @Override
    public void processConstraints(List<NodeGroup> nodeGroups) {
        this.buildConstraintsGraph(nodeGroups);
        Pair<NodeGroup, NodeGroup> violatedConstraint = null;
        while ((violatedConstraint = this.findViolatedConstraint(nodeGroups)) != null) {
            this.handleViolatedConstraint((NodeGroup)violatedConstraint.getFirst(), (NodeGroup)violatedConstraint.getSecond(), nodeGroups);
        }
    }

    private void buildConstraintsGraph(List<NodeGroup> nodeGroups) {
        for (NodeGroup nodeGroup : nodeGroups) {
            nodeGroup.resetOutgoingConstraints();
            nodeGroup.incomingConstraintsCount = 0;
        }
        LNode lastNonDummyNode = null;
        for (NodeGroup nodeGroup : nodeGroups) {
            LNode node = nodeGroup.getNode();
            for (LNode successor : (List)node.getProperty(InternalProperties.IN_LAYER_SUCCESSOR_CONSTRAINTS)) {
                NodeGroup successorNodeGroup = (NodeGroup)successor.getProperty(InternalProperties.NODE_GROUP);
                nodeGroup.getOutgoingConstraints().add(successorNodeGroup);
                ++successorNodeGroup.incomingConstraintsCount;
            }
            if (node.getType() != LNode.NodeType.NORMAL) continue;
            if (lastNonDummyNode != null) {
                for (LNode lastUnitNode : this.layoutUnits.get((Object)lastNonDummyNode)) {
                    NodeGroup lastUnitNodeGroup = (NodeGroup)lastUnitNode.getProperty(InternalProperties.NODE_GROUP);
                    for (LNode currentUnitNode : this.layoutUnits.get((Object)node)) {
                        NodeGroup currentUnitNodeGroup = (NodeGroup)currentUnitNode.getProperty(InternalProperties.NODE_GROUP);
                        lastUnitNodeGroup.getOutgoingConstraints().add(currentUnitNodeGroup);
                        ++currentUnitNodeGroup.incomingConstraintsCount;
                    }
                }
            }
            lastNonDummyNode = node;
        }
    }

    private Pair<NodeGroup, NodeGroup> findViolatedConstraint(List<NodeGroup> nodeGroups) {
        List activeNodeGroups = null;
        double lastValue = -32768.0;
        for (NodeGroup nodeGroup : nodeGroups) {
            assert (nodeGroup.barycenter != null && nodeGroup.barycenter >= lastValue);
            lastValue = nodeGroup.barycenter;
            nodeGroup.resetIncomingConstraints();
            if (!nodeGroup.hasOutgoingConstraints() || nodeGroup.incomingConstraintsCount != 0) continue;
            if (activeNodeGroups == null) {
                activeNodeGroups = Lists.newArrayList();
            }
            activeNodeGroups.add(nodeGroup);
        }
        if (activeNodeGroups != null) {
            while (!activeNodeGroups.isEmpty()) {
                NodeGroup nodeGroup;
                nodeGroup = (NodeGroup)activeNodeGroups.remove(0);
                if (nodeGroup.hasIncomingConstraints()) {
                    for (NodeGroup predecessor : nodeGroup.getIncomingConstraints()) {
                        if (!(predecessor.barycenter.floatValue() == nodeGroup.barycenter.floatValue() ? nodeGroups.indexOf(predecessor) > nodeGroups.indexOf(nodeGroup) : predecessor.barycenter > nodeGroup.barycenter)) continue;
                        return Pair.of((Object)predecessor, (Object)nodeGroup);
                    }
                }
                for (NodeGroup successor : nodeGroup.getOutgoingConstraints()) {
                    List<NodeGroup> successorIncomingList = successor.getIncomingConstraints();
                    successorIncomingList.add(0, nodeGroup);
                    if (successor.incomingConstraintsCount != successorIncomingList.size()) continue;
                    activeNodeGroups.add(successor);
                }
            }
        }
        return null;
    }

    private void handleViolatedConstraint(NodeGroup firstNodeGroup, NodeGroup secondNodeGroup, List<NodeGroup> nodeGroups) {
        NodeGroup newNodeGroup = new NodeGroup(firstNodeGroup, secondNodeGroup);
        assert (newNodeGroup.barycenter + (double)1.0E-4f >= secondNodeGroup.barycenter);
        assert (newNodeGroup.barycenter - (double)1.0E-4f <= firstNodeGroup.barycenter);
        ListIterator<NodeGroup> nodeGroupIterator = nodeGroups.listIterator();
        boolean alreadyInserted = false;
        while (nodeGroupIterator.hasNext()) {
            NodeGroup nodeGroup = nodeGroupIterator.next();
            if (nodeGroup == firstNodeGroup || nodeGroup == secondNodeGroup) {
                nodeGroupIterator.remove();
                continue;
            }
            if (!alreadyInserted && nodeGroup.barycenter > newNodeGroup.barycenter) {
                nodeGroupIterator.previous();
                nodeGroupIterator.add(newNodeGroup);
                alreadyInserted = true;
                continue;
            }
            if (!nodeGroup.hasOutgoingConstraints()) continue;
            boolean firstNodeGroupConstraint = nodeGroup.getOutgoingConstraints().remove(firstNodeGroup);
            boolean secondNodeGroupConstraint = nodeGroup.getOutgoingConstraints().remove(secondNodeGroup);
            if (!firstNodeGroupConstraint && !secondNodeGroupConstraint) continue;
            nodeGroup.getOutgoingConstraints().add(newNodeGroup);
            ++newNodeGroup.incomingConstraintsCount;
        }
        if (!alreadyInserted) {
            nodeGroups.add(newNodeGroup);
        }
    }
}

